/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.service;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.SystemClock;
import com.aniways.Log;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.service.AlarmListener;
import com.aniways.service.AniwaysIntentService;
import com.aniways.service.WakefulIntentService;
import com.aniways.service.utils.AniwaysServiceUtils;

public class AniwaysAlarmListener
implements AlarmListener {
    private static final String TAG = "AniwaysAlarmListener";

    @Override
    public void scheduleAlarms(AlarmManager alarmManager, PendingIntent pendingIntent, long interval, long timeOfFirstAlarmFromNow, Context context, String alarmName) {
        try {
            Log.i(TAG, "Scheduling alarms to wake the process and perform " + alarmName + ". Interval: " + interval + ". Time of first alarm from now: " + timeOfFirstAlarmFromNow);
            alarmManager.cancel(pendingIntent);
            alarmManager.setRepeating(2, SystemClock.elapsedRealtime() + timeOfFirstAlarmFromNow, interval, pendingIntent);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in scheduleAlrams", ex);
        }
    }

    @Override
    public void sendWakefulWork(Context context, boolean fromAlarm) {
        try {
            if (AniwaysServiceUtils.shouldPerformSync(context)) {
                long now = System.currentTimeMillis();
                long lastSuccessfulUpdate = AniwaysServiceUtils.getLastSuccessfulUpdate(context);
                if (lastSuccessfulUpdate < 1L) {
                    lastSuccessfulUpdate = now;
                }
                if (!AniwaysPhraseReplacementData.isInit()) {
                    Log.i(TAG, "Requesting to perform sync with the Aniways Backend Server because alarm was fired while process was down");
                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Statistics", "Request backend sync" + (fromAlarm ? "-from alarm" : "") + (lastSuccessfulUpdate == now ? "-first time" : ""), "unknown", (now - lastSuccessfulUpdate) / 3600000L);
                } else {
                    boolean keywordsVersionIsZero = AniwaysPhraseReplacementData.getDataParser().getKeywordsVersion().equalsIgnoreCase("0.0");
                    Log.i(TAG, "Requesting to perform sync with the Aniways Backend Server because " + (keywordsVersionIsZero ? "keywords version is 0.0" : "its been too long since the last successful sync") + " and the service is not currently running");
                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Statistics", "Request backend sync" + (fromAlarm ? "-from alarm" : "") + (lastSuccessfulUpdate == now ? "-first time" : ""), AniwaysPhraseReplacementData.getDataParser().getKeywordsVersion(), (now - lastSuccessfulUpdate) / 3600000L);
                }
                AnalyticsReporter.reportRequestBackendSync(now - lastSuccessfulUpdate, fromAlarm);
                WakefulIntentService.sendWakefulWork(context, AniwaysIntentService.class, fromAlarm);
            } else {
                Log.v(TAG, "Not performing sync. Following alarm: " + fromAlarm);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in sendWakefulWork", ex);
        }
    }
}

