/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.aniways.Log;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.data.AniwaysStatics;
import com.aniways.service.AniwaysAlarmListener;
import com.aniways.service.WakefulIntentService;
import com.aniways.service.utils.AniwaysServiceUtils;

public class AlarmReceiver
extends BroadcastReceiver {
    private static final String TAG = "AniwaysBroadcastReceiver";
    static final String ANIWAYS_HEARTBEAT_ACTION = "com.aniways.heartbeat.action";

    public void onReceive(Context context, Intent intent) {
        try {
            AniwaysStatics.init(context.getApplicationContext(), context, true);
            AniwaysAlarmListener alarmListener = new AniwaysAlarmListener();
            if (null == intent.getAction()) {
                Log.i(TAG, "Broadcast received with null intent action - performing work in the service");
                alarmListener.sendWakefulWork(context, true);
            } else if (intent.getAction().equals(ANIWAYS_HEARTBEAT_ACTION)) {
                AlarmReceiver.sendAppInstalledEvent(context, true);
            } else {
                Log.i(TAG, "Broadcast received with " + intent.getAction() + " intent action - schedueling alarms");
                WakefulIntentService.scheduleAlarms(alarmListener, context);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onReceive", ex);
        }
    }

    static void sendAppInstalledEvent(Context context, boolean fromAlarm) {
        Log.i(TAG, (fromAlarm ? "Broadcast received" : "") + " with heartbeat intent action - sending app (still) installed event");
        long now = System.currentTimeMillis();
        long installTime = AniwaysServiceUtils.getAppInstallTime(context, now);
        AnalyticsReporter.reportAppStillInstalled(installTime, now);
        if (installTime == now) {
            Log.i(TAG, "Setting app install time to be: " + now);
            AniwaysServiceUtils.setAppInstallTime(context, now);
        }
    }
}

