/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.quick.action;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.support.v7.widget.GridLayout;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.blur.BlurLinearLayout;
import com.aniways.blur.ContextualBubbleFrameLayout;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.JsonParser;
import com.aniways.quick.action.ActionItem;
import com.aniways.quick.action.PopupWindows;
import com.aniways.quick.action.QuickActionIconClickContext;
import com.aniways.settings.AniwaysSettingsActivity;
import com.aniways.ui.AniwaysUiUtil;
import com.aniways.ui.views.AniwaysSlidingLayer;
import com.aniways.volley.toolbox.IResponseListener;
import com.aniways.volley.toolbox.NetworkImageView;
import com.aniways.volley.toolbox.Volley;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class QuickAction
extends PopupWindows
implements PopupWindow.OnDismissListener,
ViewTreeObserver.OnGlobalLayoutListener {
    private TextView mCreditsBalance;
    private Animation mTrackAnim;
    private LayoutInflater inflater;
    private GridLayout mTrack;
    private OnActionItemClickListener mItemClickListener;
    private OnDismissListener mDismissListener;
    private static HashSet<QuickAction> sOpenedQuickActions = new HashSet();
    private ImageView showMore;
    private View.OnTouchListener mOnTouchListener;
    private List<ActionItem> mActionItemList = new ArrayList<ActionItem>();
    private List<View> mActionItemViewsList = new ArrayList<View>();
    private boolean mAnimateTrack;
    private int mChildPos;
    private int mAnimStyle;
    public static final int ANIM_GROW_FROM_LEFT = 1;
    public static final int ANIM_GROW_FROM_RIGHT = 2;
    public static final int ANIM_GROW_FROM_CENTER = 3;
    public static final int ANIM_AUTO = 4;
    private static final String TAG = "AniwaysQuickAction";
    private AniwaysLockedIconHelper mLockedIconHelper;
    private AniwaysLockedIconHelper.OnItemContainingLockedIconClickListener mOnItemContainingLockedIconClickListener;
    private View mAnchor;
    private Point mArrowCenterOffsetFromAnchorTopLeft;
    private Point mArrowCenterOffsetFromAnchorBottomLeft;
    private TextView mIconText;
    private boolean isIconInfo;
    private ImageView showMoreIcons;
    private AniwaysSlidingLayer slidingLayer;

    public QuickAction(Context context, View anchor, JsonParser parser, boolean showCreditsIfStoreIsEnabled, boolean isIconInfo, boolean delayAutoDismiss) {
        super(context, delayAutoDismiss);
        this.mAnchor = anchor;
        this.isIconInfo = isIconInfo;
        this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mTrackAnim = AnimationUtils.loadAnimation((Context)context, (int)R.anim.aniways_rail);
        if (isIconInfo) {
            this.setRootViewId(R.layout.aniways_icon_info_popup);
        } else {
            this.setRootViewId(R.layout.aniways_contextual_suggestions_popup);
        }
        this.mOnItemContainingLockedIconClickListener = new AniwaysLockedIconHelper.OnItemContainingLockedIconClickListener(){

            @Override
            public void onItemClick(Object iconClickContext) {
                QuickActionIconClickContext context = (QuickActionIconClickContext)iconClickContext;
                QuickAction.this.callItemClickListener(context);
            }
        };
        if (!isIconInfo) {
            this.mLockedIconHelper = new AniwaysLockedIconHelper(parser, this.mOnItemContainingLockedIconClickListener, null, this.mCreditsBalance, this.mWindow, this.mAnchor, showCreditsIfStoreIsEnabled, this.mContext, "SP");
            this.mAnimateTrack = true;
        }
        this.mAnimStyle = 4;
        this.mChildPos = 0;
        super.setOnDismissListener(this);
        anchor.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    public static double bezierPoint(double point1, double point2, double point3, double point4, double time) {
        double t1 = 1.0 - time;
        return point1 * t1 * t1 * t1 + 3.0 * point2 * time * t1 * t1 + 3.0 * point3 * time * time * t1 + point4 * time * time * time;
    }

    public ActionItem getActionItem(int index) {
        return this.mActionItemList.get(index);
    }

    public void setRootViewId(int id2) {
        this.mRootView = (ViewGroup)this.inflater.inflate(id2, null);
        if (this.isIconInfo) {
            this.mIconText = (TextView)this.mRootView.findViewById(R.id.aniways_quickaction_tracks);
        } else {
            this.mTrack = (GridLayout)this.mRootView.findViewById(R.id.aniways_quickaction_tracks);
            this.mCreditsBalance = (TextView)this.mRootView.findViewById(R.id.aniways_quickaction_credits_balance);
            if (this.mCreditsBalance == null) {
                this.mCreditsBalance = new TextView(this.mContext);
            }
        }
        BlurLinearLayout bubbleView = (BlurLinearLayout)this.mRootView.findViewById(R.id.aniways_contextual_popup_blured_linear_layout);
        bubbleView.setViewBehindPopup(this.mAnchor);
        this.setContentView(this.mRootView);
    }

    public void addActionItems(List<ActionItem> actionItemList) {
        boolean isLastItemInRow = false;
        boolean isLastRow = false;
        boolean isSettingItem = false;
        int pullStripHeightInPixels = AniwaysUiUtil.convertDipsToPixels(16);
        int itemLeftRightMarginInPixels = AniwaysUiUtil.convertDipsToPixels(9);
        int itemTopBottomMarginInPixels = AniwaysUiUtil.convertDipsToPixels(9);
        this.clearActionItems();
        this.initSlidingLayer();
        if (actionItemList == null || actionItemList.isEmpty()) {
            Log.i(TAG, "trying to add action items to track with null or empty list");
            return;
        }
        int total = actionItemList.size() + 1;
        int maxNumItemsInColumn = this.calcColumnsNumber(AniwaysPrivateConfig.getInstance().iconInSuggestionPopupWidth + itemLeftRightMarginInPixels, itemLeftRightMarginInPixels);
        int columns = Math.min(total, maxNumItemsInColumn);
        int rows = this.calcRowNumber(total, columns);
        if (columns <= 0) {
            this.clearActionItems();
            this.dismiss();
            return;
        }
        if (rows > 1) {
            this.addPullupStripAsFirstRow();
        }
        this.adjustSlideLayerHeight(rows, columns, AniwaysPrivateConfig.getInstance().iconInSuggestionPopupHeight + itemTopBottomMarginInPixels, itemTopBottomMarginInPixels, pullStripHeightInPixels);
        this.mTrack.setColumnCount(columns);
        this.mTrack.setRowCount(rows);
        int i = 0;
        int c = 0;
        int r = 0;
        while (i < total) {
            if (i == total - 1) {
                isSettingItem = true;
            }
            IconData icon = null;
            if (!isSettingItem) {
                icon = actionItemList.get(i).getIconData();
            }
            if (icon == null && !isSettingItem) {
                --c;
            } else {
                if (c == columns - 1) {
                    isLastItemInRow = true;
                }
                if (c == columns) {
                    c = 0;
                    ++r;
                }
                if (r == rows - 1) {
                    isLastRow = true;
                }
                ActionItem action = null;
                if (!isSettingItem) {
                    action = actionItemList.get(i);
                }
                this.addActionItemToGridContainer(c, r, action, itemLeftRightMarginInPixels, itemTopBottomMarginInPixels, isLastRow, isLastItemInRow, isSettingItem);
                isLastItemInRow = false;
                isLastRow = false;
            }
            ++i;
            ++c;
        }
    }

    private void initSlidingLayer() {
        if (this.slidingLayer == null) {
            this.slidingLayer = (AniwaysSlidingLayer)this.mRootView.findViewById(R.id.sliding_layer);
        }
        this.slidingLayer.setOnInteractListener(new AniwaysSlidingLayer.OnInteractListener(){

            @Override
            public void onOpen() {
                QuickAction.this.rotateShowMoreIndicator(R.anim.aniways_chevron_rotate_down, true);
            }

            @Override
            public void onClose() {
                QuickAction.this.rotateShowMoreIndicator(R.anim.aniways_chevron_rotate_up, false);
            }

            @Override
            public void onOpened() {
            }

            @Override
            public void onClosed() {
            }
        });
    }

    private void rotateShowMoreIndicator(int animationId, boolean setFillAfter) {
        if (this.showMore == null) {
            return;
        }
        Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)animationId);
        animation.setRepeatCount(1);
        this.showMore.startAnimation(animation);
        animation.setFillAfter(setFillAfter);
    }

    private void adjustSlideLayerHeight(int rows, int columns, int singleIconHeight, int heightMargin, int pullStripHeightInPixels) {
        int showMoreStripHeight = rows == 1 ? 0 : pullStripHeightInPixels;
        int availableHeight = this.calcAvailableHeight();
        int fitInRowsNumber = availableHeight / singleIconHeight;
        if (fitInRowsNumber * singleIconHeight + showMoreStripHeight > availableHeight) {
            --fitInRowsNumber;
        }
        int maxRows = Math.min(rows, fitInRowsNumber);
        this.slidingLayer.setOffsetWidth(singleIconHeight + heightMargin + showMoreStripHeight);
        this.slidingLayer.getLayoutParams().height = maxRows * singleIconHeight + heightMargin + showMoreStripHeight;
    }

    private int calcAvailableHeight() {
        int[] location = new int[2];
        this.mAnchor.getLocationOnScreen(location);
        Rect rectangle = new Rect();
        this.mAnchor.getWindowVisibleDisplayFrame(rectangle);
        int statusBarHeight = rectangle.top;
        return location[1] - statusBarHeight;
    }

    private int calcRowNumber(int total, int columns) {
        if (columns == 0) {
            return 0;
        }
        int row = total / columns;
        return row += total % columns == 0 ? 0 : 1;
    }

    private void addPullupStripAsFirstRow() {
        this.showMore = (ImageView)this.mRootView.findViewById(R.id.show_more_icons);
        this.showMore.setVisibility(0);
        this.mRootView.findViewById(R.id.show_more_icons_up_strip).setVisibility(0);
        this.mRootView.findViewById(R.id.show_more_icons_down_strip).setVisibility(0);
    }

    private void addActionItemToGridContainer(int column, int row, ActionItem action, int itemLeftRightMarginInPixels, int itemTopBottomMarginInPixels, boolean isLastRow, boolean isLastItemInRow, boolean isSettingItem) {
        if (isSettingItem) {
            GridLayout.LayoutParams lp = this.getItemInGridLayoutParams(column, row, itemLeftRightMarginInPixels, itemTopBottomMarginInPixels, isLastRow, isLastItemInRow);
            this.addSettingsBtnToTrack(lp);
            return;
        }
        this.mActionItemList.add(action);
        View iconContainer = this.inflater.inflate(R.layout.aniways_contextual_suggestions_popup_emoticon_item, null);
        this.mActionItemViewsList.add(iconContainer);
        this.addProgressBar(iconContainer);
        ImageView lock = (ImageView)iconContainer.findViewById(R.id.aniways_ebp_emoticons_item_locked_icon);
        NetworkImageView img = (NetworkImageView)iconContainer.findViewById(R.id.aniways_action_item_icon);
        ViewGroup.LayoutParams lp = img.getLayoutParams();
        lp.width = AniwaysPrivateConfig.getInstance().iconInSuggestionPopupWidth;
        lp.height = AniwaysPrivateConfig.getInstance().iconInSuggestionPopupHeight;
        img.setMinimumWidth(AniwaysPrivateConfig.getInstance().iconInSuggestionPopupWidth);
        img.setMinimumHeight(AniwaysPrivateConfig.getInstance().iconInSuggestionPopupHeight);
        img.setScaleType(ImageView.ScaleType.FIT_CENTER);
        img.setLayoutParams(lp);
        GridLayout.LayoutParams containerLp = this.getItemInGridLayoutParams(column, row, itemLeftRightMarginInPixels, itemTopBottomMarginInPixels, isLastRow, isLastItemInRow);
        iconContainer.setLayoutParams((ViewGroup.LayoutParams)containerLp);
        this.registerImgerResponseListener(img, lock, iconContainer, action);
        this.addImageToRequestQueue(action, img);
        this.bindImageContainer(action, iconContainer, lock, img, this.mChildPos);
        this.mTrack.addView(iconContainer);
        ++this.mChildPos;
    }

    private GridLayout.LayoutParams getItemInGridLayoutParams(int column, int row, int itemLeftRightMarginInPixels, int itemTopBottomMarginInPixels, boolean isLastRow, boolean isLastItemInRow) {
        GridLayout.LayoutParams containerLp = new GridLayout.LayoutParams();
        containerLp.height = -2;
        containerLp.width = -2;
        containerLp.leftMargin = itemLeftRightMarginInPixels;
        containerLp.topMargin = itemTopBottomMarginInPixels;
        if (isLastItemInRow) {
            containerLp.rightMargin = itemLeftRightMarginInPixels;
        }
        if (isLastRow) {
            containerLp.bottomMargin = itemTopBottomMarginInPixels;
        }
        containerLp.setGravity(17);
        containerLp.columnSpec = GridLayout.spec((int)column);
        containerLp.rowSpec = GridLayout.spec((int)row);
        return containerLp;
    }

    private void addImageToRequestQueue(ActionItem action, NetworkImageView img) {
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        IconData icon = action.getIconData();
        img.setImageUrl(config.getIconUrl(icon, false, false), icon, Volley.getImageLoader(), config.getMaxWidthForCache(icon), config.getMaxHeightForCache(icon), true);
    }

    private void registerImgerResponseListener(final NetworkImageView img, final ImageView lockImage, final View imageContainer, final ActionItem action) {
        img.registerResponseListener(new IResponseListener(){

            @Override
            public void onSuccess() {
                try {
                    QuickAction.this.mLockedIconHelper.setIconAndLockVisibility(img, lockImage, action.getIconData());
                    ProgressBar spinner = (ProgressBar)imageContainer.findViewById(R.id.aniways_progress_bar_id);
                    spinner.setVisibility(8);
                }
                catch (Throwable t) {
                    Log.e(true, QuickAction.TAG, "Exception in IResponseListener onSuccess", t);
                }
            }

            @Override
            public void onError() {
                boolean closePopup = AniwaysPrivateConfig.getInstance().noInternetPopupClose;
                Log.i(QuickAction.TAG, "Error loading image in quick action" + (closePopup ? ". Closing the popup" : ""));
                Handler h = new Handler(Looper.getMainLooper());
                h.postDelayed((Runnable)new NonThrowingRunnable(QuickAction.TAG, "addActionItem.onError", ""){

                    @Override
                    public void innerRun() {
                        if (QuickAction.this.isShowing().booleanValue()) {
                            Log.i(QuickAction.TAG, "Dissmissing window because of error loading image");
                            String toastString = "Please make sure you are connected to the Internet";
                            try {
                                toastString = QuickAction.this.mContext.getResources().getString(R.string.aniways_check_internet_connection);
                            }
                            catch (Throwable ex) {
                                Log.w(true, QuickAction.TAG, "Caught Exception while getting make sure connected to intenet toast string", ex);
                            }
                            Toast toast = Toast.makeText((Context)QuickAction.this.mContext, (CharSequence)toastString, (int)1);
                            toast.setGravity(17, 0, 0);
                            toast.show();
                            QuickAction.this.dismiss();
                        }
                    }
                }, AniwaysPrivateConfig.getInstance().noInternetPopupCloseDelay);
            }
        });
    }

    private int calcColumnsNumber(int singleIconWidth, int margin) {
        DisplayMetrics dm = new DisplayMetrics();
        this.mWindowManager.getDefaultDisplay().getMetrics(dm);
        int screenWidth = dm.widthPixels;
        int columnNumber = (screenWidth - margin) / singleIconWidth;
        return columnNumber;
    }

    @SuppressLint(value={"InflateParams"})
    public void addActionItem(ActionItem action) {
        this.mActionItemList.add(action);
        IconData icon = action.getIconData();
        View container = this.inflater.inflate(R.layout.aniways_contextual_suggestions_popup_emoticon_item, null);
        this.mActionItemViewsList.add(container);
        this.addProgressBar(container);
        ImageView lock = (ImageView)container.findViewById(R.id.aniways_ebp_emoticons_item_locked_icon);
        NetworkImageView img = (NetworkImageView)container.findViewById(R.id.aniways_action_item_icon);
        ViewGroup.LayoutParams lp = img.getLayoutParams();
        lp.width = AniwaysPrivateConfig.getInstance().iconInSuggestionPopupWidth;
        lp.height = AniwaysPrivateConfig.getInstance().iconInSuggestionPopupHeight;
        img.setMinimumWidth(AniwaysPrivateConfig.getInstance().iconInSuggestionPopupWidth);
        img.setMinimumHeight(AniwaysPrivateConfig.getInstance().iconInSuggestionPopupHeight);
        img.setScaleType(ImageView.ScaleType.FIT_CENTER);
        img.setLayoutParams(lp);
        if (icon != null) {
            this.registerImgerResponseListener(img, lock, container, action);
            this.addImageToRequestQueue(action, img);
        } else {
            img.setVisibility(8);
        }
        int position = this.mChildPos;
        this.bindImageContainer(action, container, lock, img, position);
        this.mTrack.addView(container, this.mChildPos);
        ++this.mChildPos;
    }

    private void bindImageContainer(final ActionItem action, View container, final ImageView lock, final NetworkImageView img, final int position) {
        container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View clickedOnActionItem) {
                try {
                    QuickAction.this.mLockedIconHelper.onIconClicked(img, lock, action.getIconData(), new QuickActionIconClickContext(clickedOnActionItem, position, action.getActionId()));
                }
                catch (Throwable ex) {
                    Log.e(true, QuickAction.TAG, "Caught Exception in onClick on action item", ex);
                }
            }
        });
    }

    public void clearActionItems() {
        this.mTrack.removeAllViews();
        this.mChildPos = 0;
        this.mActionItemViewsList.clear();
        this.mActionItemList.clear();
    }

    public void addSettingsBtnToTrack(GridLayout.LayoutParams layoutParams) {
        if (this.mTrack == null) {
            return;
        }
        layoutParams.setGravity(17);
        ImageView settingBtn = new ImageView(this.mContext);
        settingBtn.setImageResource(R.drawable.aniways_settings_btn);
        settingBtn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        settingBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(v.getContext(), AniwaysSettingsActivity.class);
                QuickAction.this.mContext.startActivity(intent);
            }
        });
        this.mTrack.addView((View)settingBtn);
    }

    private void addProgressBar(View container) {
        View relativeLayout = container.findViewById(R.id.relative_container);
        int progressBarStyle = AniwaysPrivateConfig.getInstance().iconInSuggestionPopupWidth >= AniwaysUiUtil.convertDipsToPixels(76) ? 16842874 : 16842873;
        ProgressBar pb = new ProgressBar(this.mContext, null, progressBarStyle);
        pb.setId(R.id.aniways_progress_bar_id);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13, -1);
        pb.setLayoutParams((ViewGroup.LayoutParams)params);
        ((ViewGroup)relativeLayout).addView((View)pb);
    }

    public void addActionIconInfo(ActionItem action) {
        this.mIconText.setText((CharSequence)action.getTitle());
    }

    public void setOnActionItemClickListener(OnActionItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    public void show(Point arrowCenterOffsetFromAnchorTopLeft, Point arrowCenterOffsetFromAnchorBottomLeft, boolean fillParentWidth) {
        sOpenedQuickActions.add(this);
        this.preShow(fillParentWidth);
        this.setAnimationStyle();
        this.adjustLayout(arrowCenterOffsetFromAnchorTopLeft, arrowCenterOffsetFromAnchorBottomLeft);
        if (this.mAnimateTrack) {
            int offsetBase = this.mContext.getResources().getInteger(R.integer.aniwaysPopupAimationTime) - 50;
            int fadeInOffset = this.mContext.getResources().getInteger(R.integer.aniwaysContextualPopupFadeInAimationOffset);
            this.mTrackAnim.setStartOffset((long)offsetBase);
            if (!this.isIconInfo) {
                this.mTrack.startAnimation(this.mTrackAnim);
                int numChildren = this.mTrack.getChildCount();
                for (int i = 0; i < numChildren; ++i) {
                    Animation fadeInAnimation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.aniways_contextual_fade_in);
                    fadeInAnimation.setStartOffset((long)(offsetBase + i * fadeInOffset));
                    this.mTrack.getChildAt(i).startAnimation(fadeInAnimation);
                }
            }
        }
    }

    public void showAndCloseAfterDelay(Point centerPoint, Point centerPoint1, boolean fillParentWidth) {
        this.show(centerPoint, centerPoint1, fillParentWidth);
        this.mRootView.postDelayed(new Runnable(){

            @Override
            public void run() {
                QuickAction.this.dismiss();
            }
        }, AniwaysPrivateConfig.getInstance().popupDismissDelay);
    }

    @SuppressLint(value={"NewApi"})
    public void onGlobalLayout() {
        if (this.mDismissed) {
            if (Utils.isAndroidVersionAtLeast(16)) {
                this.mAnchor.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        } else if (this.mArrowCenterOffsetFromAnchorTopLeft != null && this.mArrowCenterOffsetFromAnchorBottomLeft != null) {
            this.adjustLayout(this.mArrowCenterOffsetFromAnchorTopLeft, this.mArrowCenterOffsetFromAnchorBottomLeft);
        }
    }

    private void adjustLayout(Point arrowCenterOffsetFromAnchorTopLeft, Point arrowCenterOffsetFromAnchorBottomLeft) {
        int halfWidth;
        int[] location = new int[2];
        this.mArrowCenterOffsetFromAnchorTopLeft = arrowCenterOffsetFromAnchorTopLeft;
        this.mArrowCenterOffsetFromAnchorBottomLeft = arrowCenterOffsetFromAnchorBottomLeft;
        this.mAnchor.getLocationOnScreen(location);
        Rect anchorRect = new Rect(location[0], location[1], location[0] + this.mAnchor.getWidth(), location[1] + this.mAnchor.getHeight());
        this.mRootView.measure(0, 0);
        int rootWidthWithMode = this.mRootView.getMeasuredWidth();
        int rootHeightWithMode = this.mRootView.getMeasuredHeight();
        int rootWidth = View.MeasureSpec.getSize((int)rootWidthWithMode);
        int rootHeight = View.MeasureSpec.getSize((int)rootHeightWithMode);
        DisplayMetrics dm = new DisplayMetrics();
        this.mWindowManager.getDefaultDisplay().getMetrics(dm);
        int screenWidth = dm.widthPixels;
        int xPos = 0;
        int xPosArrowCenter = anchorRect.left + this.mArrowCenterOffsetFromAnchorTopLeft.x;
        xPos = rootWidth > screenWidth ? 0 : ((halfWidth = rootWidth / 2) > xPosArrowCenter ? 0 : (xPosArrowCenter + halfWidth > screenWidth ? screenWidth - rootWidth : xPosArrowCenter - halfWidth));
        int xPosOffsetFromAnchor = xPos - anchorRect.left;
        if (!this.isIconInfo) {
            xPosOffsetFromAnchor = 0 - anchorRect.left;
        }
        boolean onTop = true;
        Rect rectgle = new Rect();
        this.mAnchor.getWindowVisibleDisplayFrame(rectgle);
        int statusBarHeight = rectgle.top;
        int rootTop = anchorRect.top - rootHeight + this.mArrowCenterOffsetFromAnchorTopLeft.y - statusBarHeight;
        if (rootTop < 0) {
            onTop = false;
        }
        int arrowCenterInRoot = xPosArrowCenter - xPos;
        View bubbleLayout = this.mRootView.findViewById(R.id.aniways_contextual_popup_frame_layout);
        if (onTop) {
            if (bubbleLayout != null && bubbleLayout instanceof ContextualBubbleFrameLayout) {
                ((ContextualBubbleFrameLayout)bubbleLayout).setArrowDown(arrowCenterInRoot);
            }
            int heightOffset = AniwaysUiUtil.convertDipsToPixels(2) - rootHeight - anchorRect.height();
            try {
                if (this.mWindow.isShowing()) {
                    this.mWindow.update(this.mAnchor, xPosOffsetFromAnchor, heightOffset, this.mWindow.getWidth(), this.mWindow.getHeight());
                }
                this.mWindow.showAsDropDown(this.mAnchor, xPosOffsetFromAnchor, heightOffset);
            }
            catch (Throwable ex) {
                Log.e(true, TAG, "Caught error while opening popup", ex);
                return;
            }
        } else {
            if (bubbleLayout != null && bubbleLayout instanceof ContextualBubbleFrameLayout) {
                ((ContextualBubbleFrameLayout)bubbleLayout).setArrowUp(arrowCenterInRoot);
            }
            try {
                if (this.mWindow.isShowing()) {
                    this.mWindow.update(this.mAnchor, xPosOffsetFromAnchor, -this.mArrowCenterOffsetFromAnchorBottomLeft.y, this.mWindow.getWidth(), this.mWindow.getHeight());
                } else {
                    this.mWindow.showAsDropDown(this.mAnchor, xPosOffsetFromAnchor, -this.mArrowCenterOffsetFromAnchorBottomLeft.y);
                }
            }
            catch (Throwable ex) {
                Log.e(true, TAG, "Caught error while opening popup", ex);
                return;
            }
        }
    }

    private void setAnimationStyle() {
        this.mWindow.setAnimationStyle(0);
    }

    public void setOnDismissListener(OnDismissListener listener) {
        this.mDismissListener = listener;
    }

    public void onDismiss() {
        this.mDismissed = true;
        Log.d(TAG, "removing quick action from hashset of opened quick actions");
        sOpenedQuickActions.remove(this);
        if (this.mDismissListener != null) {
            this.mDismissListener.onDismiss();
        }
    }

    private void callItemClickListener(QuickActionIconClickContext context) {
        if (this.mItemClickListener != null) {
            this.mItemClickListener.onItemClick(this, context.pos, context.actionId);
        }
        if (!this.getActionItem(context.pos).isSticky()) {
            context.clickedOnActionItem.post((Runnable)new NonThrowingRunnable(TAG, "after calling onItemClick", ""){

                @Override
                public void innerRun() {
                    QuickAction.this.dismiss();
                }
            });
        }
    }

    public static boolean dismissAllOpenQuickActions() {
        boolean closedSomething = false;
        try {
            Log.d(TAG, "dismissing all quick actions");
            Log.d(TAG, "Closing opened quickactions");
            HashSet<QuickAction> secondary = new HashSet<QuickAction>(sOpenedQuickActions);
            for (QuickAction qa : secondary) {
                if (qa.isShowing().booleanValue()) {
                    qa.dismiss();
                    closedSomething = true;
                    continue;
                }
                Log.d(TAG, "An opened quickaction is not showing");
            }
        }
        catch (Exception e) {
            Log.w(true, TAG, "caught Exception while dismissing all opened quick actions", e);
        }
        return closedSomething;
    }

    public static void cancelAutoDismissOfAllOpenQuickActions() {
        for (QuickAction quickAction : sOpenedQuickActions) {
            quickAction.cancelDismissal();
        }
    }

    public void setTouchInterceptor(View.OnTouchListener onTouchListener) {
        this.mOnTouchListener = onTouchListener;
    }

    @Override
    protected boolean processPopupTouchEvent(View v, MotionEvent event) {
        boolean retConsumed = super.processPopupTouchEvent(v, event);
        if (this.mOnTouchListener != null) {
            retConsumed |= this.mOnTouchListener.onTouch(v, event);
        }
        return retConsumed;
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    public static interface OnActionItemClickListener {
        public void onItemClick(QuickAction var1, int var2, int var3);
    }
}

