/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.quick.action;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import com.aniways.Log;
import java.util.Timer;
import java.util.TimerTask;

public class PopupWindows {
    protected Context mContext;
    protected PopupWindow mWindow;
    protected View mRootView;
    protected WindowManager mWindowManager;
    protected boolean mDismissed;
    private boolean mDelayAutoDismiss;
    private Timer mDismissalDelayTimer;
    private static final String TAG = "AniwaysPopupWindow";

    public PopupWindows(Context context, boolean delayAutoDismiss) {
        this.mContext = context;
        this.mWindow = new PopupWindow(context);
        this.mDelayAutoDismiss = delayAutoDismiss;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    protected void preShow(boolean fillParentWidth) {
        if (this.mRootView == null) {
            throw new IllegalStateException("setContentView was not called with a view to display.");
        }
        this.mWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mWindow.setWidth(fillParentWidth ? -1 : -2);
        this.mWindow.setHeight(-2);
        this.mWindow.setTouchable(true);
        this.mWindow.setFocusable(false);
        this.mWindow.setInputMethodMode(2);
        this.mWindow.setOutsideTouchable(true);
        this.mWindow.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return PopupWindows.this.processPopupTouchEvent(v, event);
            }
        });
        this.mWindow.setContentView(this.mRootView);
    }

    public void cancelDismissal() {
        Timer activeTimer = this.mDismissalDelayTimer;
        if (activeTimer != null) {
            activeTimer.cancel();
        }
    }

    public void setContentView(View root) {
        this.mRootView = root;
        this.mWindow.setContentView(root);
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mWindow.setOnDismissListener(listener);
    }

    public void dismiss() {
        try {
            this.mDismissalDelayTimer = null;
            this.mWindow.dismiss();
            this.mDismissed = true;
        }
        catch (Exception e) {
            Log.w(true, TAG, "caught Exception while dismissing popup", e);
        }
    }

    public Boolean isShowing() {
        return this.mWindow != null && this.mWindow.isShowing();
    }

    protected boolean processPopupTouchEvent(View v, MotionEvent event) {
        try {
            if (event.getAction() == 4) {
                if (this.mDelayAutoDismiss) {
                    this.mDismissalDelayTimer = new Timer();
                    this.mDismissalDelayTimer.schedule((TimerTask)new DismissalDelayTask(this), 400L);
                } else {
                    this.dismiss();
                }
                return true;
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onTouch", ex);
        }
        return false;
    }

    private class DismissalDelayTask
    extends TimerTask {
        private final PopupWindows mPopupToDismiss;

        public DismissalDelayTask(PopupWindows popupToDismiss) {
            this.mPopupToDismiss = popupToDismiss;
        }

        @Override
        public void run() {
            ((Activity)this.mPopupToDismiss.mContext).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DismissalDelayTask.this.mPopupToDismiss.dismiss();
                }
            });
        }
    }
}

