/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.emoticons.button;

import android.annotation.SuppressLint;
import android.support.v4.view.AniwaysDirectionalViewPager;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import com.aniways.Log;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.volley.toolbox.NetworkImageView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

abstract class EmoticonsOnDemandPagerAdapterBase
extends PagerAdapter {
    private HashMap<Integer, InstantiatedViewHolder> viewHolders;
    private String mName;
    protected int mAssetCode;
    protected int mCategoryPage;
    protected int mFamilyPage;
    private AdapterType mAdapterType;
    private int mPrimaryPosition = -1;
    private EmoticonsOnDemandPagerAdapterBase mParent;
    private int mPositionInParent;

    EmoticonsOnDemandPagerAdapterBase(String name, AdapterType type, int assetCode, int categoryPage, int familyPage, EmoticonsOnDemandPagerAdapterBase parent, int positionInParent) {
        this.mName = name;
        this.mAdapterType = type;
        this.mAssetCode = assetCode;
        this.mCategoryPage = categoryPage;
        this.mFamilyPage = familyPage;
        this.mParent = parent;
        this.mPositionInParent = positionInParent;
    }

    public Object instantiateItem(View collection, int position) {
        try {
            Log.i(this.mName, "Instatiating item to be in position: " + position);
            View view = this.instantiateItem(collection);
            ((AniwaysDirectionalViewPager)collection).addView(view);
            InstantiatedViewHolder holder = new InstantiatedViewHolder(position, view);
            this.onHolderCreated(holder);
            return holder;
        }
        catch (Throwable ex) {
            Log.e(true, this.mName, "Caught Exception in instantiateItem", ex);
            return null;
        }
    }

    public void setPrimaryItem(View container, int position, Object object) {
        try {
            InstantiatedViewHolder holder;
            Log.i(this.mName, "Setting primary item to be in position: " + position);
            this.mPrimaryPosition = position;
            if (this.mParent != null && !this.mParent.isChildVisible(this.mAssetCode, this.mFamilyPage, this.mCategoryPage)) {
                Log.i(this.mName, "ignored..");
                return;
            }
            if (AniwaysPrivateConfig.getInstance().isLowMemoryDevice()) {
                this.recycleImagesInOtherPositions(position);
            }
            if ((holder = (InstantiatedViewHolder)object) == null) {
                return;
            }
            if (!holder.instantiated) {
                this.instantiateItemInternal(holder);
                this.finishInstantiateItemInternal(holder);
                holder.instantiated = true;
            } else {
                this.regeneratePrimaryItem();
            }
        }
        catch (Throwable ex) {
            Log.e(true, this.mName, "Caught Exception in setPrimaryItem", ex);
        }
    }

    public void destroyItem(View collection, int position, Object object) {
        try {
            Log.i(this.mName, "destroying item number: " + position);
            InstantiatedViewHolder holder = (InstantiatedViewHolder)object;
            if (holder == null) {
                Log.e(true, this.mName, "destroying a null holder: " + object + " in position: " + position);
                return;
            }
            ((AniwaysDirectionalViewPager)collection).removeView(holder.view);
            this.viewHolders.remove(position);
            if (AniwaysPrivateConfig.getInstance().isLowMemoryDevice() && holder.instantiated) {
                this.recycleBitmapsInPosition(holder);
            }
        }
        catch (Throwable ex) {
            Log.e(true, this.mName, "Caught Exception in destroyItem", ex);
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        try {
            if (object == null) {
                return false;
            }
            return view == ((InstantiatedViewHolder)object).view;
        }
        catch (Throwable ex) {
            Log.e(true, this.mName, "Caught Exception in setPrimaryItem", ex);
            return false;
        }
    }

    void recycleAllBitmaps() {
        if (this.viewHolders == null) {
            return;
        }
        for (Map.Entry<Integer, InstantiatedViewHolder> entry : this.viewHolders.entrySet()) {
            if (!entry.getValue().instantiated) continue;
            this.recycleBitmapsInPosition(entry.getValue());
        }
    }

    protected void recycleBitmapsInPosition(InstantiatedViewHolder holder) {
        ((EmoticonsOnDemandPagerAdapterBase)holder.pager.getAdapter()).recycleAllBitmaps();
    }

    protected void regenerateItem(InstantiatedViewHolder holder) {
        if (holder == null) {
            Log.e(true, this.mName, "Trying to regenerate a null holder");
            return;
        }
        EmoticonsOnDemandPagerAdapterBase primaryChild = holder.adapter;
        if (primaryChild == null) {
            Log.e(true, this.mName, "primary child is null");
        }
        primaryChild.regeneratePrimaryItem();
    }

    protected void onHolderCreated(InstantiatedViewHolder holder) {
        if (!AniwaysPrivateConfig.getInstance().isLowMemoryDevice()) {
            this.instantiateItemInternal(holder);
            this.finishInstantiateItemInternal(holder);
            holder.instantiated = true;
        }
    }

    protected abstract View instantiateItem(View var1);

    protected abstract void instantiateItemInternal(InstantiatedViewHolder var1);

    private void recycleImagesInOtherPositions(int position) {
        if (this.viewHolders == null) {
            return;
        }
        for (Map.Entry<Integer, InstantiatedViewHolder> entry : this.viewHolders.entrySet()) {
            if (entry.getKey() == position || !entry.getValue().instantiated) continue;
            this.recycleBitmapsInPosition(entry.getValue());
        }
    }

    private void regeneratePrimaryItem() {
        if (this.mPrimaryPosition < 0) {
            return;
        }
        if (this.viewHolders == null) {
            return;
        }
        this.regenerateItem(this.viewHolders.get(this.mPrimaryPosition));
    }

    @SuppressLint(value={"UseSparseArrays"})
    private void finishInstantiateItemInternal(InstantiatedViewHolder holder) {
        if (this.viewHolders == null) {
            this.viewHolders = new HashMap();
        }
        if (holder.pager != null) {
            holder.adapter = (EmoticonsOnDemandPagerAdapterBase)holder.pager.getAdapter();
        }
        this.viewHolders.put(holder.position, holder);
    }

    private boolean isChildVisible(int assetCode, int familyNumber, int categoryNumber) {
        switch (this.mAdapterType) {
            case Asset: {
                return assetCode == this.mPrimaryPosition;
            }
            case Category: {
                if (categoryNumber == this.mPrimaryPosition) {
                    return this.mParent.isChildVisible(assetCode, familyNumber, categoryNumber);
                }
                return false;
            }
            case Family: {
                if (familyNumber == this.mPrimaryPosition) {
                    return this.mParent.isChildVisible(assetCode, familyNumber, categoryNumber);
                }
                return false;
            }
        }
        Log.e(true, this.mName, "Unknown adapter type: " + (Object)((Object)this.mAdapterType));
        return false;
    }

    public boolean isVisible(int position) {
        if (this.mPrimaryPosition != position) {
            return false;
        }
        if (this.mParent == null) {
            return true;
        }
        return this.mParent.isVisible(this.mPositionInParent);
    }

    class InstantiatedViewHolder {
        EmoticonsOnDemandPagerAdapterBase adapter;
        AniwaysDirectionalViewPager pager;
        View view;
        boolean instantiated = false;
        boolean iconsCleared;
        int position;
        ArrayList<NetworkImageView> images;

        public InstantiatedViewHolder(int pos, View v) {
            this.position = pos;
            this.view = v;
        }
    }

    static enum AdapterType {
        Asset,
        Category,
        Family,
        Table;

    }
}

