/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.emoticons.button;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.AniwaysDirectionalViewPager;
import android.view.LayoutInflater;
import android.view.View;
import com.aniways.AssetType;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.data.AniwaysLockedIconHelper;
import com.aniways.data.JsonParser;
import com.aniways.emoticons.button.AniwaysEmoticonsButtonMaker;
import com.aniways.emoticons.button.AniwaysRecentIconsManager;
import com.aniways.emoticons.button.EmoticonFamiliesPagerAdapter;
import com.aniways.emoticons.button.EmoticonsOnDemandPagerAdapterBase;
import com.aniways.emoticons.button.EmoticonsPagerAdapterWithTable;
import com.aniways.viewpagerindicator.CirclePageIndicator;
import com.aniways.viewpagerindicator.IconPagerAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EmoticonCategoriesPagerAdapter
extends EmoticonsOnDemandPagerAdapterBase
implements IconPagerAdapter {
    static final String RECENT = "Recent";
    private String TAG = "AniwaysEmoticonCategoriesPagerAdapter";
    private String[] mSuperCategoriesInOrder;
    private AniwaysLockedIconHelper mLockedIconHelper;
    private AniwaysEmoticonsButtonMaker.LastPagesLocation mLastPagesLocation;
    private static Drawable[] ICONS_FOR_TABS = null;
    private List<IconData> mIconsForGenious = null;
    private AssetType mAssetType;

    public EmoticonCategoriesPagerAdapter(AniwaysLockedIconHelper lockedIconHelper, AniwaysEmoticonsButtonMaker.LastPagesLocation lastPagesLocation, AssetType assetType, Context context, List<IconData> iconsForGenious, EmoticonsOnDemandPagerAdapterBase parent) {
        super("AniwaysEmoticonCategoriesPagerAdapter-" + assetType.getAssetCode(), EmoticonsOnDemandPagerAdapterBase.AdapterType.Category, assetType.getAssetCode(), 0, 0, parent, assetType.getAssetCode());
        try {
            this.TAG = this.TAG + "-" + assetType.getAssetCode();
            this.mAssetType = assetType;
            this.mLockedIconHelper = lockedIconHelper;
            this.mLastPagesLocation = lastPagesLocation;
            this.mIconsForGenious = iconsForGenious == null ? new ArrayList() : iconsForGenious;
            this.mSuperCategoriesInOrder = this.mLockedIconHelper.getDataParser().getIconCategoriesInOrderByAssetType(this.mAssetType);
            if (this.mSuperCategoriesInOrder == null || this.mSuperCategoriesInOrder.length == 0) {
                Log.e(true, this.TAG, "No Icon categories in parser for asset type '" + assetType.toString() + "'");
            } else {
                this.calculateIconsForTabs(lockedIconHelper, context);
            }
        }
        catch (Throwable ex) {
            Log.e(true, this.TAG, "Caught Exception in constructor", ex);
        }
    }

    @Override
    public int getCount() {
        if (this.mSuperCategoriesInOrder == null) {
            return 0;
        }
        return this.mSuperCategoriesInOrder.length;
    }

    public String getCategoryName(int position) {
        try {
            return this.mSuperCategoriesInOrder[position];
        }
        catch (Throwable ex) {
            Log.e(true, this.TAG, "Caught Exception in getCategoryName", ex);
            return "EMPTY";
        }
    }

    @Override
    public Drawable getIconDrawable(int index) {
        if (index < 0) {
            Log.e(true, this.TAG, "index < 0 - " + index);
            index = 0;
        }
        if (ICONS_FOR_TABS == null) {
            Log.e(true, this.TAG, "ICONS_FOR_TABS is null. index is: " + index);
            return null;
        }
        if (index >= ICONS_FOR_TABS.length) {
            Log.e(true, this.TAG, "index >= ICONS_FOR_TABS.length. Index:" + index + " . Length: " + ICONS_FOR_TABS.length);
            index = 0;
        }
        return ICONS_FOR_TABS[index];
    }

    public int getItemPosition(Object object) {
        try {
            EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder = (EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder)object;
            String category = this.getCategoryName(holder.position);
            boolean isRecentsCategory = category.equalsIgnoreCase(RECENT);
            if (isRecentsCategory) {
                return -2;
            }
            return super.getItemPosition((Object)holder);
        }
        catch (Throwable ex) {
            Log.e(true, this.TAG, "Caught Exception in getItemPosition", ex);
            return -2;
        }
    }

    @Override
    protected View instantiateItem(View collection) {
        try {
            LayoutInflater inflater = (LayoutInflater)collection.getContext().getSystemService("layout_inflater");
            return inflater.inflate(R.layout.aniways_emoticons_button_popup_icon_families_pager, null);
        }
        catch (Throwable ex) {
            Log.e(true, this.TAG, "Caught Exception in instantiateItem", ex);
            return null;
        }
    }

    @Override
    protected void onHolderCreated(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder) {
    }

    @Override
    @SuppressLint(value={"NewApi"})
    protected void instantiateItemInternal(EmoticonsOnDemandPagerAdapterBase.InstantiatedViewHolder holder) {
        View layout2 = holder.view;
        String category = this.getCategoryName(holder.position);
        AniwaysDirectionalViewPager pager = (AniwaysDirectionalViewPager)layout2.findViewById(R.id.aniways_ebp_icon_families_pager);
        pager.setOffscreenPageLimit(1);
        holder.pager = pager;
        boolean isRecentsCategory = category.equalsIgnoreCase(RECENT);
        HashMap<String, List<IconData>> recentIcons = new HashMap<String, List<IconData>>();
        if (isRecentsCategory && (!AniwaysRecentIconsManager.isEmpty(this.mAssetType) || this.mIconsForGenious.size() > 0)) {
            List<IconData> geniousAndRecentIcons = new ArrayList<IconData>();
            geniousAndRecentIcons.addAll(this.mIconsForGenious);
            String[] recentIconIds = AniwaysRecentIconsManager.getRecentIcons(this.mAssetType);
            JsonParser parser = this.mLockedIconHelper.getDataParser();
            for (String id2 : recentIconIds) {
                IconData icon = parser.getIconById(Integer.parseInt(id2));
                if (icon == null) {
                    Log.w(false, this.TAG, "No icon for id even though it is in the recents list: " + id2);
                    continue;
                }
                geniousAndRecentIcons.add(icon);
            }
            ArrayList<IconData> filteredIcons = new ArrayList<IconData>();
            for (IconData icon : geniousAndRecentIcons) {
                if (icon.assetType != this.mAssetType) continue;
                filteredIcons.add(icon);
            }
            geniousAndRecentIcons = filteredIcons;
            int maxItems = EmoticonsPagerAdapterWithTable.getMaxItemsPerPage(this.mAssetCode);
            if (geniousAndRecentIcons.size() > maxItems) {
                geniousAndRecentIcons = geniousAndRecentIcons.subList(0, maxItems);
            }
            recentIcons.put("default", geniousAndRecentIcons);
        }
        HashMap<String, List<IconData>> categoryFamiliesAndIcons = isRecentsCategory ? recentIcons : this.mLockedIconHelper.getDataParser().getFamiliesToIconsByAssetTypeAndCategory(this.mAssetType, category);
        EmoticonFamiliesPagerAdapter adapter = new EmoticonFamiliesPagerAdapter(categoryFamiliesAndIcons, this.mAssetCode, category, holder.position, this.mLockedIconHelper, isRecentsCategory, this.mIconsForGenious.size(), this.mLastPagesLocation, this);
        pager.setAdapter(adapter);
        pager.setOrientation(0);
        CirclePageIndicator indicator = (CirclePageIndicator)layout2.findViewById(R.id.aniways_ebp_icon_families_pager_indicator);
        indicator.setViewPager(pager);
        indicator.setOrientation(0);
        if (categoryFamiliesAndIcons.size() == 1) {
            String family = (String)categoryFamiliesAndIcons.keySet().toArray()[0];
            if (categoryFamiliesAndIcons.get(family).size() > EmoticonsPagerAdapterWithTable.getMaxItemsPerPage(this.mAssetCode) && this.mAssetType == AssetType.Emoji) {
                indicator.setVisibility(8);
            } else {
                indicator.setVisibility(4);
            }
        }
        indicator.setOnPageChangeListener(new AniwaysDirectionalViewPager.OnPageChangeListener(){

            @Override
            public void onPageScrollStateChanged(int arg0) {
            }

            @Override
            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            @Override
            public void onPageSelected(int familyPage) {
                try {
                    EmoticonCategoriesPagerAdapter.this.mLastPagesLocation.setFamilyPage(familyPage);
                    Log.i(EmoticonCategoriesPagerAdapter.this.TAG, "Selected family num: " + familyPage);
                }
                catch (Throwable ex) {
                    Log.e(true, EmoticonCategoriesPagerAdapter.this.TAG, "Caught Exception in onPageSelected", ex);
                }
            }
        });
        if (this.mLastPagesLocation.getSelectedAssetType().getAssetCode() == this.mAssetCode && this.mLastPagesLocation.getCategoryPage() == holder.position) {
            indicator.setCurrentItem(this.mLastPagesLocation.getFamilyPage());
        }
        holder.instantiated = true;
    }

    private void calculateIconsForTabs(AniwaysLockedIconHelper lockedIconHelper, Context context) {
        Drawable[] tabDrawables = new Drawable[this.mSuperCategoriesInOrder.length];
        int counter = 0;
        for (String category : this.mSuperCategoriesInOrder) {
            String iconName = lockedIconHelper.getDataParser().getSuperCategoryTabIconName(category);
            if (iconName == null) {
                Log.e(true, this.TAG, "No icon name defined for category: " + category + " Keywords version: " + lockedIconHelper.getDataParser().getKeywordsVersion());
                tabDrawables[counter] = context.getResources().getDrawable(R.drawable.aniways_ebp_food_and_drinks_button);
            } else {
                String packageName = context.getPackageName();
                if (packageName == null) {
                    Log.e(true, this.TAG, "package Name is null");
                    tabDrawables[counter] = context.getResources().getDrawable(R.drawable.aniways_ebp_food_and_drinks_button);
                } else {
                    int iconId = context.getResources().getIdentifier(iconName, "drawable", packageName);
                    if (iconId == 0) {
                        Log.e(true, this.TAG, "Could not find resource with name: " + iconName + " for tab icon of category: " + category);
                        tabDrawables[counter] = context.getResources().getDrawable(R.drawable.aniways_ebp_food_and_drinks_button);
                    } else {
                        tabDrawables[counter] = context.getResources().getDrawable(iconId);
                    }
                }
            }
            ++counter;
        }
        ICONS_FOR_TABS = tabDrawables;
    }
}

