/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.emoticons.button;

import android.content.Context;
import android.content.SharedPreferences;
import com.aniways.AssetType;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.data.AniwaysPrivateConfig;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Stack;

public class AniwaysRecentIconsManager {
    private static final String KEY_RECENT_ICONS_OLD = "com.aniways.RECENT_ICONS_V2";
    private static final String KEY_RECENT_EMOJI = "com.aniways.RECENT_EMOJI";
    private static final String KEY_RECENT_EMOTICONS = "com.aniways.RECENT_EMOTICONS";
    private static final String IDS_DIVIDER = ";;";
    private static final String TAG = "AniwaysRecentIconsManager";
    private static Dictionary<AssetType, Stack<String>> sRecentIconsByAssetType;
    private static Context sContext;

    public static void forceInit(Context context) {
        if (sContext != null) {
            Log.w(true, TAG, "Calling init of AniwaysRecentIconsManager more than once");
        }
        sContext = context;
        AniwaysRecentIconsManager.populateRecentIds();
    }

    public static void addRecentIcon(long iconId, AssetType assetType) {
        String idString = Long.toString(iconId);
        Stack<String> recentIcons = sRecentIconsByAssetType.get((Object)assetType);
        recentIcons.remove(idString);
        recentIcons.push(idString);
        while (recentIcons.size() > AniwaysPrivateConfig.getInstance().maxIconsInRecentsTab) {
            recentIcons.remove(0);
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (int i = 0; i < recentIcons.size(); ++i) {
            set.add((String)recentIcons.get(i));
        }
        SharedPreferences prefs = sContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        String recentIds = AniwaysRecentIconsManager.convertSetToIdsString(set);
        SharedPreferences.Editor edit = prefs.edit();
        if (assetType == AssetType.Emoji) {
            edit.putString(KEY_RECENT_EMOJI, recentIds);
        } else if (assetType == AssetType.Emoticons) {
            edit.putString(KEY_RECENT_EMOTICONS, recentIds);
        }
        edit.commit();
    }

    static boolean isEmpty(AssetType assetType) {
        Stack<String> idsStack = sRecentIconsByAssetType.get((Object)assetType);
        return idsStack == null || idsStack.isEmpty();
    }

    static String[] getRecentIcons(AssetType assetType) {
        Stack<String> idsStack = sRecentIconsByAssetType.get((Object)assetType);
        if (idsStack != null && idsStack.size() > 0) {
            int lastIndex;
            String[] result = new String[idsStack.size()];
            for (int i = lastIndex = result.length - 1; i > -1; --i) {
                result[lastIndex - i] = (String)idsStack.get(i);
            }
            return result;
        }
        return new String[0];
    }

    private static void populateRecentIds() {
        SharedPreferences prefs = sContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        sRecentIconsByAssetType = new Hashtable<AssetType, Stack<String>>();
        Stack<String> emojiIds = new Stack<String>();
        Stack<String> emoticonIds = new Stack<String>();
        sRecentIconsByAssetType.put(AssetType.Emoji, emojiIds);
        sRecentIconsByAssetType.put(AssetType.Emoticons, emoticonIds);
        if (prefs.contains(KEY_RECENT_ICONS_OLD)) {
            Log.i(TAG, "Shared preferences contains the old recent icons key. Converting to new format.");
            String recentIdsString = prefs.getString(KEY_RECENT_ICONS_OLD, "");
            if (recentIdsString.length() > 0) {
                LinkedHashSet<String> recentIds = AniwaysRecentIconsManager.convertIdsStringToSet(recentIdsString);
                for (String recentIdStr : recentIds) {
                    try {
                        int recentId = Integer.parseInt(recentIdStr);
                        if (recentId >= 1000 && recentId <= 1845) {
                            emojiIds.push(recentIdStr);
                            continue;
                        }
                        emoticonIds.push(recentIdStr);
                    }
                    catch (NumberFormatException e) {
                        emoticonIds.push(recentIdStr);
                    }
                }
            }
            SharedPreferences.Editor editor = prefs.edit();
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.addAll(emojiIds);
            String recentIds = AniwaysRecentIconsManager.convertSetToIdsString(set);
            editor.putString(KEY_RECENT_EMOJI, recentIds);
            set.clear();
            set.addAll(emoticonIds);
            recentIds = AniwaysRecentIconsManager.convertSetToIdsString(set);
            editor.putString(KEY_RECENT_EMOTICONS, recentIds);
            editor.remove(KEY_RECENT_ICONS_OLD);
            editor.commit();
        } else {
            String recentEmojiIdsString = prefs.getString(KEY_RECENT_EMOJI, "");
            if (recentEmojiIdsString.length() > 0) {
                LinkedHashSet<String> recentEmojiIds = AniwaysRecentIconsManager.convertIdsStringToSet(recentEmojiIdsString);
                emojiIds.addAll(recentEmojiIds);
            } else {
                Log.i(TAG, "Shared preferences do not contain a value for recent emojis, the recent emoji this tab will be empty");
            }
            String recentEmoticonsIdsString = prefs.getString(KEY_RECENT_EMOTICONS, "");
            if (recentEmoticonsIdsString.length() > 0) {
                LinkedHashSet<String> recentEmoticonIds = AniwaysRecentIconsManager.convertIdsStringToSet(recentEmoticonsIdsString);
                emoticonIds.addAll(recentEmoticonIds);
            } else {
                Log.i(TAG, "Shared preferences do not contain a value for recent emoticons, the recent emoticons this tab will be empty");
            }
        }
    }

    private static LinkedHashSet<String> convertIdsStringToSet(String idsString) {
        String[] ids = idsString.split(IDS_DIVIDER);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (ids.length > 0) {
            result.addAll(Arrays.asList(ids));
        } else {
            Log.w(false, TAG, "No ids to extract from ids string:" + idsString);
        }
        return result;
    }

    private static String convertSetToIdsString(LinkedHashSet<String> ids) {
        StringBuilder sb = new StringBuilder("");
        if (ids != null && !ids.isEmpty()) {
            for (String id2 : ids) {
                sb.append(id2);
                sb.append(IDS_DIVIDER);
            }
            sb.delete(sb.length() - IDS_DIVIDER.length(), sb.length());
        } else {
            Log.w(false, TAG, "No ids to convert to string:" + ids);
        }
        return sb.toString();
    }
}

