/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.text.TextUtils;
import com.aniways.Log;
import com.aniways.data.AnimatedGifsProviders;
import com.aniways.data.AniwaysAnimatedAssetInfo;
import com.aniways.data.AniwaysClientConfig;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.GiphyIconData;
import com.aniways.data.IPhraseAnimatedAssetInfoBuilder;
import com.aniways.data.Phrase;
import com.aniways.service.utils.AniwaysAction;
import com.aniways.volley.Response;
import com.aniways.volley.VolleyError;
import com.aniways.volley.toolbox.JsonObjectRequest;
import com.aniways.volley.toolbox.Volley;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class GiphyPhraseToAnimatedAssetInfoBuilder
implements IPhraseAnimatedAssetInfoBuilder {
    private static final String TAG = "GiphyPhraseToAnimatedAssetInfoBuilder";
    private String apiKey;
    private String apiSearchTermUrlFormat;
    private String apiSearchByIdUrlFormat;
    private int limit;
    private int offset;
    private List<AniwaysAnimatedAssetInfo> assetsInfos;
    private AniwaysAction callback;
    private int numberOfRequestToPerform;
    private int numberOfRequestDone;
    private static final Phrase phrase = new Phrase("gif", null);
    private String rating;

    public GiphyPhraseToAnimatedAssetInfoBuilder() {
        this.initMembers();
    }

    private void initMembers() {
        this.apiKey = AniwaysClientConfig.getInstance().getResourceString("aniways_giphy_api_key");
        this.apiSearchTermUrlFormat = AniwaysClientConfig.getInstance().getResourceString("aniways_giphy_api_search_term_url_format");
        this.apiSearchByIdUrlFormat = AniwaysClientConfig.getInstance().getResourceString("aniways_giphy_api_search_by_id_url_format");
        this.limit = AniwaysPrivateConfig.getInstance().animatedGifsRequestSize;
        this.rating = AniwaysPrivateConfig.getInstance().animatedGifsRating;
        this.offset = 0;
    }

    @Override
    public boolean canBuild(String providerName) {
        return AnimatedGifsProviders.GIPHY.getStringRepresentaion().equalsIgnoreCase(providerName);
    }

    @Override
    public void build(String[] resourcesId, AniwaysAction callback) {
        try {
            this.callback = callback;
            if (callback == null) {
                return;
            }
            if (resourcesId == null || resourcesId.length == 0) {
                this.callback.call(null);
                return;
            }
            this.assetsInfos = new LinkedList<AniwaysAnimatedAssetInfo>();
            this.numberOfRequestToPerform = resourcesId.length;
            this.numberOfRequestDone = 0;
            for (int i = 0; i < resourcesId.length; ++i) {
                String resource = resourcesId[i];
                if (this.searchingBySerachTermRequired(resource)) {
                    this.performSearchByTermRequest(resource);
                    continue;
                }
                this.performSearchByIdRequest(resource);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception while building", ex);
        }
    }

    @Override
    public void cancelAllInProgressRequests() {
        Volley.cancelPendingRequests(TAG);
    }

    private void performSearchByIdRequest(String resource) {
        String url = String.format(this.apiSearchByIdUrlFormat, resource, this.apiKey);
        this.performSearchRequest(url, new AniwaysAction<JSONObject>(){

            @Override
            public synchronized void call(JSONObject response) {
                if (response == null) {
                    GiphyPhraseToAnimatedAssetInfoBuilder.this.aggregateResults(null);
                    return;
                }
                try {
                    JSONObject data = response.getJSONObject("data");
                    GiphyPhraseToAnimatedAssetInfoBuilder.this.aggregateResults(data);
                }
                catch (JSONException e) {
                    Log.e(true, GiphyPhraseToAnimatedAssetInfoBuilder.TAG, "Unable to parse Giphy api response:" + response.toString(), e);
                    GiphyPhraseToAnimatedAssetInfoBuilder.this.aggregateResults(null);
                }
            }
        });
    }

    private void performSearchByTermRequest(String resource) {
        String requestUrl;
        try {
            String searchTerm = resource.split(":")[1];
            searchTerm = searchTerm.replace(' ', '+');
            requestUrl = String.format(this.apiSearchTermUrlFormat, searchTerm, this.apiKey, this.limit, this.offset);
            if (!TextUtils.isEmpty((CharSequence)this.rating)) {
                requestUrl = requestUrl + "&rating=" + this.rating;
            }
        }
        catch (Exception e) {
            Log.e(true, TAG, "Unable to extract search term from resource, resource is:" + resource, e);
            this.aggregateResults(null);
            return;
        }
        this.performSearchRequest(requestUrl, new AniwaysAction<JSONObject>(){

            @Override
            public synchronized void call(JSONObject response) {
                if (response == null) {
                    GiphyPhraseToAnimatedAssetInfoBuilder.this.aggregateResults(null);
                    return;
                }
                try {
                    JSONArray array = response.getJSONArray("data");
                    if (array.length() == 0) {
                        GiphyPhraseToAnimatedAssetInfoBuilder.this.aggregateResults(null);
                        return;
                    }
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject row = array.getJSONObject(i);
                        GiphyPhraseToAnimatedAssetInfoBuilder.this.AddGiphyInfoToCollection(row);
                    }
                }
                catch (JSONException e) {
                    Log.e(true, GiphyPhraseToAnimatedAssetInfoBuilder.TAG, "Unable to parse Giphy api response:" + response.toString(), e);
                }
                GiphyPhraseToAnimatedAssetInfoBuilder.this.aggregateResults(null);
            }
        });
    }

    private void performSearchRequest(final String requestUrl, final AniwaysAction<JSONObject> callback) {
        try {
            JsonObjectRequest jsonObjectRequest = new JsonObjectRequest(0, requestUrl, null, new Response.Listener<JSONObject>(){

                @Override
                public void onResponse(JSONObject response) {
                    callback.call(response);
                }
            }, new Response.ErrorListener(){

                @Override
                public void onErrorResponse(VolleyError error) {
                    Log.e(true, GiphyPhraseToAnimatedAssetInfoBuilder.TAG, "Unable to search Giphy api using the following url:" + requestUrl, error);
                    callback.call(null);
                }
            });
            Volley.addToRequestQueue(jsonObjectRequest, TAG);
        }
        catch (Exception e) {
            Log.e(true, TAG, "Exception thrown while trying to search Giphy api using the following url:" + requestUrl, e);
            callback.call(null);
        }
    }

    private synchronized void aggregateResults(JSONObject giphyImageObj) {
        ++this.numberOfRequestDone;
        this.AddGiphyInfoToCollection(giphyImageObj);
        if (this.numberOfRequestDone == this.numberOfRequestToPerform) {
            this.callback.call(this.assetsInfos);
        }
    }

    private void AddGiphyInfoToCollection(JSONObject giphyImageObj) {
        if (giphyImageObj != null) {
            try {
                this.assetsInfos.add(this.mapGifyObjectToAssetInfo(giphyImageObj));
            }
            catch (JSONException e) {
                Log.e(true, TAG, "Exception thrown while trying to aggregate result:", e);
            }
        }
    }

    private JSONObject extractGiphyImageObject(JSONObject ghiphyImageObject) throws JSONException {
        return ghiphyImageObject.getJSONObject("images").getJSONObject(AniwaysPrivateConfig.getInstance().giphyLowQualityImageObjectName);
    }

    private boolean searchingBySerachTermRequired(String resource) {
        return resource.startsWith(AniwaysPrivateConfig.getInstance().animatedGifsSearchTermPrefix);
    }

    private AniwaysAnimatedAssetInfo mapGifyObjectToAssetInfo(JSONObject gipyDataObject) throws JSONException {
        JSONObject images = gipyDataObject.getJSONObject("images");
        JSONObject highQualityObj = images.getJSONObject(AniwaysPrivateConfig.getInstance().giphyHighQualityImageObjectName);
        JSONObject lowQualityObj = images.getJSONObject(AniwaysPrivateConfig.getInstance().giphyLowQualityImageObjectName);
        JSONObject stillObj = images.getJSONObject(AniwaysPrivateConfig.getInstance().giphyHighQualityStillImageObjectName);
        String id2 = gipyDataObject.getString("id");
        String stilUrl = stillObj.getString("url");
        String highQualityAnimationUrl = highQualityObj.getString("url");
        String lowQualityAnimationUrl = lowQualityObj.getString("url");
        AniwaysAnimatedAssetInfo result = new AniwaysAnimatedAssetInfo(new GiphyIconData(id2, stilUrl, lowQualityAnimationUrl, highQualityAnimationUrl, phrase));
        result.setId(id2);
        result.setHighQualityAnimatedGifUrl(highQualityAnimationUrl);
        result.setLowQualityAnimatedGifUrl(lowQualityAnimationUrl);
        result.setHighHeight(highQualityObj.getInt("height"));
        result.setLowHeight(lowQualityObj.getInt("height"));
        result.setHighWidth(highQualityObj.getInt("width"));
        result.setLowWidth(lowQualityObj.getInt("width"));
        result.setStillUrl(stilUrl);
        result.setStillHeight(stillObj.getInt("height"));
        result.setStillWidth(stillObj.getInt("width"));
        result.setJson(gipyDataObject);
        return result;
    }
}

