/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import com.aniways.IconData;
import com.aniways.data.CustomHashSet;

public class EmojiHashSet
extends CustomHashSet<IconData> {
    public EmojiHashSet(int capacity) {
        super(capacity);
    }

    @Override
    protected void generateKeys(int capacity) {
        this.keys = new IconData[capacity];
    }

    @Override
    public IconData put(IconData key) {
        if (key == this.NULL) {
            throw new IllegalArgumentException("key cannot be " + this.NULL);
        }
        if (this.size == ((IconData[])this.keys).length) {
            throw new IllegalStateException("map is full");
        }
        int index = this.indexFor(key.firstEmojiCodepoint);
        while (((IconData[])this.keys)[index] != this.NULL) {
            index = this.successor(index);
        }
        ((IconData[])this.keys)[index] = key;
        ++this.size;
        return key;
    }

    @Override
    public IconData get(IconData key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IconData get(int key) {
        int index = this.indexFor(key);
        IconData candidate = ((IconData[])this.keys)[index];
        while (candidate != this.NULL) {
            if (candidate.firstEmojiCodepoint == key && candidate.secondEmojiCodepoint == -1) {
                return candidate;
            }
            index = this.successor(index);
            candidate = ((IconData[])this.keys)[index];
        }
        return (IconData)this.NULL;
    }

    @Override
    public IconData get(int[] key) {
        int index = this.indexFor(key[0]);
        IconData candidate = ((IconData[])this.keys)[index];
        while (candidate != this.NULL) {
            if (candidate.firstEmojiCodepoint == key[0] && candidate.secondEmojiCodepoint == key[1]) {
                return candidate;
            }
            index = this.successor(index);
            candidate = ((IconData[])this.keys)[index];
        }
        return (IconData)this.NULL;
    }

    private int indexFor(int key) {
        return Math.abs(key % ((IconData[])this.keys).length);
    }
}

