/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import java.util.Arrays;
import java.util.Iterator;

public abstract class CustomHashSet<T>
implements Iterable<T> {
    private static final float LOAD_FACTOR = 1.5f;
    protected T NULL = null;
    protected T[] keys;
    protected int size;
    private int capacity;

    public CustomHashSet(int numberOfItems) {
        this.capacity = (int)((float)numberOfItems * 1.5f);
        if (this.capacity < 1) {
            this.capacity = 1;
        }
        this.generateKeys(this.capacity);
        Arrays.fill(this.keys, this.NULL);
    }

    protected abstract void generateKeys(int var1);

    public T put(T key) {
        if (key == this.NULL) {
            throw new IllegalArgumentException("key cannot be " + this.NULL);
        }
        if (this.size == this.keys.length) {
            throw new IllegalStateException("map is full");
        }
        int index = this.indexFor(key);
        while (this.keys[index] != this.NULL) {
            index = this.successor(index);
        }
        this.keys[index] = key;
        ++this.size;
        return key;
    }

    public T get(T key) {
        if (key == this.NULL) {
            throw new IllegalArgumentException("key cannot be " + this.NULL);
        }
        int index = this.indexFor(key);
        T candidate = this.keys[index];
        while (candidate != this.NULL) {
            if (candidate.hashCode() == key.hashCode() && candidate.equals(key)) {
                return candidate;
            }
            index = this.successor(index);
            candidate = this.keys[index];
        }
        return this.NULL;
    }

    private int indexFor(T key) {
        return Math.abs(key.hashCode() % this.keys.length);
    }

    protected int successor(int index) {
        return ++index >= this.keys.length ? index - this.keys.length : index;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator it = new Iterator<T>(){
            private int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < CustomHashSet.this.capacity;
            }

            @Override
            public T next() {
                while (CustomHashSet.this.keys[this.currentIndex] == null) {
                    ++this.currentIndex;
                }
                return CustomHashSet.this.keys[this.currentIndex++];
            }

            @Override
            public void remove() {
            }
        };
        return it;
    }
}

