/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.content.Context;
import android.content.SharedPreferences;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.data.AniwaysStatics;
import com.aniways.data.ObjectSerializer;
import java.util.ArrayList;

public class AppData {
    private static String sEmptyArrayListString;
    private static String sSharedPreferencesFileName;
    private static Context sApplicationContext;
    private static SharedPreferences sPreferences;
    private static final String TAG = "AniwaysAppData";

    public static int getInt(String key) {
        return AppData.getInt(key, 0);
    }

    public static int getInt(String key, int defaultValue) {
        AppData.verifyInit();
        return sPreferences.getInt(key, defaultValue);
    }

    public static void putInt(String key, int value) {
        AppData.verifyInit();
        SharedPreferences.Editor editor = sPreferences.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return sPreferences.getBoolean(key, defaultValue);
    }

    public static void putBoolean(String key, boolean value) {
        SharedPreferences.Editor editor = sPreferences.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public static String getString(String key) {
        AppData.verifyInit();
        return sPreferences.getString(key, "");
    }

    public static void putString(String key, String value) {
        AppData.verifyInit();
        SharedPreferences.Editor editor = sPreferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static ArrayList<String> getStringList(String key) {
        AppData.verifyInit();
        ArrayList retStringList = new ArrayList();
        try {
            String serializedStringList = sPreferences.getString(key, sEmptyArrayListString);
            retStringList = (ArrayList)ObjectSerializer.deserialize(serializedStringList);
        }
        catch (Exception e) {
            Log.e(false, TAG, "Failed while deserializing the value under key: '" + key + "'.");
        }
        return retStringList;
    }

    public static void putStringList(String key, ArrayList<String> value) {
        AppData.verifyInit();
        SharedPreferences.Editor editor = sPreferences.edit();
        try {
            editor.putString(key, ObjectSerializer.serialize(value));
        }
        catch (Exception e) {
            Log.e(false, TAG, "Failed while serializing the value to be stored under key: '" + key + "'.");
        }
        editor.commit();
    }

    public static synchronized int incrementInt(String key) {
        AppData.verifyInit();
        int retValue = sPreferences.getInt(key, 0) + 1;
        SharedPreferences.Editor editor = sPreferences.edit();
        editor.putInt(key, retValue);
        editor.commit();
        return retValue;
    }

    private static void verifyInit() {
        if (sSharedPreferencesFileName == null) {
            Log.e(true, TAG, "using AppData before initializing");
        }
    }

    static {
        sApplicationContext = AniwaysStatics.getApplicationContext();
        sSharedPreferencesFileName = "com.aniways.SHARED_PREFERENCES";
        sPreferences = sApplicationContext.getSharedPreferences(sSharedPreferencesFileName, Utils.getSharedPreferencesFlags());
        try {
            sEmptyArrayListString = ObjectSerializer.serialize(new ArrayList());
        }
        catch (Exception e) {
            Log.w(false, TAG, "Failed serializing an empty ArrayList<String>.");
        }
    }
}

