/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class AniwaysStoreManager {
    private static final String TAG = "AniwaysStoreManager";
    private static final String KEY_STORE_CREDITS = "com.aniways.KEY_STORE_CREDITS";
    private static final String KEY_UNLOCKED_ICONS = "com.aniways.UNLOCKED_ICONS";
    private static final HashSet<String> EMPTY_UNLOCKED_ICONS = new HashSet();
    private static final String IDS_DIVIDER = ";;";
    private static HashSet<String> sUnlockedIds;
    private static Context sContext;
    private static HashMap<String, String> sOldPathsToIds;

    static void forceInit(Context applicationContext) {
        if (sContext != null) {
            Log.e(true, TAG, "Calling init of AniwaysStoreManager more than once");
        }
        sContext = applicationContext;
        sOldPathsToIds = new HashMap();
        sOldPathsToIds.put("usa_eagle.png", "494");
        sOldPathsToIds.put("bye_flag.png", "145");
        sOldPathsToIds.put("time_pocketwatch.png", "612");
        sOldPathsToIds.put("shy_rambo_turtle.png", "391");
        sOldPathsToIds.put("sad_rambo_turtle.png", "365");
        sOldPathsToIds.put("in_love_rambo_turtle.png", "183");
        sOldPathsToIds.put("burned_peacok.png", "74");
        sOldPathsToIds.put("cool_peacok.png", "164");
        sOldPathsToIds.put("depressed_peacok.png", "148");
        sOldPathsToIds.put("in_love_peacok.png", "357");
        sOldPathsToIds.put("socks_chirstmas.png", "622");
        sOldPathsToIds.put("bells.png", "33");
        sOldPathsToIds.put("lollipop_chirstmas.png", "300");
        sOldPathsToIds.put("rose.png", "563");
        sOldPathsToIds.put("penguin.png", "377");
        sOldPathsToIds.put("panda.png", "328");
        sOldPathsToIds.put("beer_bottle.png", "184");
        sOldPathsToIds.put("guitar_electric.png", "204");
        sOldPathsToIds.put("guitar_classic.png", "180");
        AniwaysStoreManager.populateUnlockedIds();
    }

    public static boolean isStoreEnabled() {
        return AniwaysPrivateConfig.getInstance().creditsStoreEnabled;
    }

    public static boolean isIconLocked(IconData icon) {
        if (icon == null) {
            return false;
        }
        return AniwaysStoreManager.isStoreEnabled() && icon.isLocked && !AniwaysStoreManager.isIconUnlocked(icon);
    }

    public static void addUserCreditsAvailable(int amount) {
        int currentAmount = AniwaysStoreManager.getUserCreditsLeft();
        int newAmount = currentAmount + amount;
        Log.i(TAG, "Adding more credits. Current amount: " + currentAmount + ". Addition: " + amount + ". New total: " + newAmount);
        AniwaysStoreManager.writeNewValueToUserCredits(newAmount);
    }

    private static void writeNewValueToUserCredits(int newAmount) {
        SharedPreferences prefs = sContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        edit.putInt(KEY_STORE_CREDITS, newAmount);
        edit.commit();
    }

    public static boolean canUserBuyIcon(IconData icon) {
        return AniwaysStoreManager.getUserCreditsLeft() >= AniwaysPrivateConfig.getInstance().getIconPriceInCredits(icon);
    }

    @SuppressLint(value={"NewApi"})
    public static void unlockIconAndDecreaseCredits(String sourceScreen, IconData icon) {
        String id2 = Integer.toString(icon.id);
        boolean added = sUnlockedIds.add(id2);
        int iconPrice = AniwaysPrivateConfig.getInstance().getIconPriceInCredits(icon);
        if (!added) {
            Log.e(true, TAG, "Unlocking icon id which is already unlocked:" + id2);
        } else {
            Log.i(TAG, "Unlocked icon id: " + id2);
            GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, "Store", "Unlocked Icon", id2, 0L);
            AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.unlockIcon, null, AniwaysStoreManager.getUserCreditsLeft(), AniwaysStoreManager.getUserCreditsLeft() - iconPrice, iconPrice, false, id2, sourceScreen, null, null, null);
        }
        SharedPreferences prefs = sContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        SharedPreferences.Editor edit = prefs.edit();
        if (Utils.isAndroidVersionAtLeast(11)) {
            edit.putStringSet(KEY_UNLOCKED_ICONS, sUnlockedIds);
        } else {
            String unlockedIdsString = AniwaysStoreManager.convertSetToIdsString(sUnlockedIds);
            edit.putString(KEY_UNLOCKED_ICONS, unlockedIdsString);
        }
        edit.commit();
        AniwaysStoreManager.decreaseUserCreditsAvailable(iconPrice);
    }

    private static void decreaseUserCreditsAvailable(int amount) {
        int currentAmount = AniwaysStoreManager.getUserCreditsLeft();
        int newAmount = currentAmount - amount;
        Log.i(TAG, "Decreasing credits. Current amount: " + currentAmount + ". Decrease: " + amount);
        AniwaysStoreManager.writeNewValueToUserCredits(newAmount);
    }

    public static boolean isIconUnlocked(IconData icon) {
        return sUnlockedIds.contains(Integer.toString(icon.id));
    }

    public static int getUserCreditsLeft() {
        SharedPreferences prefs = sContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        if (!prefs.contains(KEY_STORE_CREDITS)) {
            Log.i(TAG, "Shared perfs do not contain a value for remaining credits, setting it to the configured initial value of: " + AniwaysPrivateConfig.getInstance().creditsStoreInitialCredits);
            AniwaysStoreManager.writeNewValueToUserCredits(AniwaysPrivateConfig.getInstance().creditsStoreInitialCredits);
        }
        int result = prefs.getInt(KEY_STORE_CREDITS, AniwaysPrivateConfig.getInstance().creditsStoreInitialCredits);
        return result;
    }

    @SuppressLint(value={"NewApi"})
    private static void populateUnlockedIds() {
        SharedPreferences prefs = sContext.getSharedPreferences("com.aniways.SHARED_PREFERENCES", Utils.getSharedPreferencesFlags());
        if (!prefs.contains(KEY_UNLOCKED_ICONS)) {
            Log.i(TAG, "Shared perfs do not contain a value for unlocked icons, so no locked icon will be unlocked");
        }
        Set<String> result = null;
        if (Utils.isAndroidVersionAtLeast(11)) {
            try {
                result = prefs.getStringSet(KEY_UNLOCKED_ICONS, EMPTY_UNLOCKED_ICONS);
            }
            catch (ClassCastException ex) {
                Log.i(TAG, "Unlocked icons key doesn't contain a set, so user probably upgraded android version. Converting to a set");
                String resultString = prefs.getString(KEY_UNLOCKED_ICONS, "");
                result = AniwaysStoreManager.convertIdsStringToSet(resultString);
                SharedPreferences.Editor edit = prefs.edit();
                edit.putStringSet(KEY_UNLOCKED_ICONS, result);
                edit.commit();
            }
        } else {
            String resultString = prefs.getString(KEY_UNLOCKED_ICONS, "");
            result = AniwaysStoreManager.convertIdsStringToSet(resultString);
        }
        sUnlockedIds = new HashSet();
        for (String path : result) {
            String newName = sOldPathsToIds.get(path);
            if (newName == null) {
                sUnlockedIds.add(path);
                continue;
            }
            sUnlockedIds.add(newName);
        }
    }

    private static Set<String> convertIdsStringToSet(String idsString) {
        String[] ids = idsString.split(IDS_DIVIDER);
        HashSet<String> result = new HashSet<String>();
        if (ids != null && ids.length > 0) {
            result.addAll(Arrays.asList(ids));
        } else {
            Log.w(false, TAG, "No ids to extract from ids string:" + idsString);
        }
        return result;
    }

    private static String convertSetToIdsString(HashSet<String> ids) {
        StringBuilder sb = new StringBuilder("");
        if (ids != null && !ids.isEmpty()) {
            for (String id2 : ids) {
                sb.append(id2);
                sb.append(IDS_DIVIDER);
            }
        } else {
            Log.w(false, TAG, "No ids to convert to string:" + ids);
        }
        return sb.toString();
    }

    static {
        sContext = null;
        sOldPathsToIds = null;
    }
}

