/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.content.Context;
import com.aniways.AniwaysNotInitializedException;
import com.aniways.Log;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.blur.BlurRenderer;
import com.aniways.data.AniwaysBackendSyncChecker;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysCustomExceptionHandler;
import com.aniways.data.AniwaysNetworkStateChecker;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStorageManager;
import com.aniways.data.AniwaysStoreManager;
import com.aniways.emoticons.button.AniwaysRecentIconsManager;
import com.aniways.service.manager.UpdateManager;
import com.aniways.volley.toolbox.Volley;

public class AniwaysStatics {
    private static final String TAG = "AniwaysStatics";
    private static boolean sIsApplicationInit;
    private static boolean sIsServiceInit;
    private static boolean sIsInitializing;
    private static Context sApplicationContext;

    public static void makeSureAniwaysIsInitialized(boolean isBackendService) {
        if (!AniwaysStatics.isInit(isBackendService)) {
            throw new AniwaysNotInitializedException();
        }
    }

    public static void makeSureBackendSyncThreadIsRunning() {
        AniwaysBackendSyncChecker.makeSureRunning();
    }

    public static synchronized void init(Context applicationContext, Context context, boolean isBackendService) {
        long startTime = System.currentTimeMillis();
        if (applicationContext == null) {
            throw new IllegalArgumentException("context is null");
        }
        if (AniwaysStatics.isInit(isBackendService)) {
            android.util.Log.i((String)TAG, (String)("Not initializing Aniways statics, because it is already initialized. Is service: " + isBackendService));
            return;
        }
        sIsInitializing = true;
        sApplicationContext = applicationContext.getApplicationContext();
        if (!sIsApplicationInit && !sIsServiceInit) {
            Thread.UncaughtExceptionHandler existingHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (!(existingHandler instanceof AniwaysCustomExceptionHandler)) {
                Thread.setDefaultUncaughtExceptionHandler(new AniwaysCustomExceptionHandler());
            }
            AniwaysPrivateConfig.forceInit(applicationContext);
            Log.forceInit(applicationContext);
            AnalyticsReporter.forceInit(applicationContext, context);
            AniwaysStorageManager.forceInit(applicationContext);
        }
        if (!sIsApplicationInit && !isBackendService) {
            AniwaysPhraseReplacementData.forceInit(applicationContext);
            AniwaysBackendSyncChecker.forceInit(applicationContext);
            try {
                BlurRenderer.initRenderScript(applicationContext);
            }
            catch (Throwable ex) {
                Log.e(true, TAG, "Could not init renderscript", ex);
            }
            AniwaysRecentIconsManager.forceInit(applicationContext);
            AniwaysStoreManager.forceInit(applicationContext);
            UpdateManager.startUpdates(applicationContext);
            AniwaysNetworkStateChecker.forceInit(applicationContext);
            Volley.forceInit(applicationContext);
        }
        AniwaysStatics.setInit(isBackendService);
        AnalyticsReporter.ReportTiming(AniwaysConfiguration.Verbosity.Info, startTime, "Performance", "Initialization. Service:" + isBackendService, "", TAG, "");
    }

    public static boolean isInit(boolean isBackendService) {
        if (isBackendService) {
            return sIsServiceInit;
        }
        return sIsApplicationInit;
    }

    private static void setInit(boolean isBackendService) {
        sIsServiceInit = true;
        if (!isBackendService) {
            sIsApplicationInit = true;
        }
        sIsInitializing = false;
    }

    public static boolean isInitializing() {
        return sIsInitializing;
    }

    public static Context getApplicationContext() {
        return sApplicationContext;
    }
}

