/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import com.aniways.AssetType;
import com.aniways.data.AniwaysPhraseAnimatedGifsModel;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPhraseToContentModel;
import com.aniways.data.DataForAssetTypeInPhrase;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.service.utils.AniwaysAction;
import java.util.HashMap;
import java.util.List;

public class AniwaysPharseContentModelBuilder {
    private static final int EMPTY_REQUEST_ID = -1;
    private AniwaysAction<AniwaysPhraseToContentModel> callback;
    private AniwaysPhraseToContentModel model;
    private boolean duringFetchingProcess;
    private int currentRequestId = -1;
    private DataForAssetTypeInPhrase assetTypeData;
    private static HashMap<AssetType, AniwaysPharseContentModelBuilder> instances = new HashMap();
    private AssetType assetType;

    public AniwaysPharseContentModelBuilder(AssetType assetType) {
        this.assetType = assetType;
    }

    public static AniwaysPharseContentModelBuilder getInstance(AssetType assetType) {
        AniwaysPharseContentModelBuilder instance = instances.get((Object)assetType);
        if (instance == null) {
            instance = new AniwaysPharseContentModelBuilder(assetType);
            instances.put(assetType, instance);
        }
        return instance;
    }

    public void extract(Phrase phrase, final AniwaysAction<AniwaysPhraseToContentModel> callback) {
        if (this.duringFetchingProcess) {
            this.cancelAllgetDataForAssetTypeRequests();
        }
        JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
        DataForAssetTypeInPhrase assetTypeData = phrase.getDataForAssetType(this.assetType);
        Phrase referencePhrase = assetTypeData.getReferencePhrase(parser, phrase);
        if (referencePhrase == null) {
            callback.call(null);
            return;
        }
        phrase = referencePhrase;
        this.resetMembers(callback);
        if (phrase == null) {
            callback.call(null);
            return;
        }
        Phrase finalPhrase = phrase;
        this.assetTypeData = phrase.getDataForAssetType(this.assetType);
        if (this.assetTypeData == null || this.assetTypeData.isEmpty()) {
            callback.call(null);
            return;
        }
        this.currentRequestId = this.assetTypeData.buildAssetInfos(new AniwaysAction<List<IAniwaysAssetInfo>>(){

            @Override
            public void call(List<IAniwaysAssetInfo> assetInfos) {
                if (assetInfos != null && !assetInfos.isEmpty()) {
                    AniwaysPharseContentModelBuilder.this.model.addAssetInfos(assetInfos);
                    callback.call(AniwaysPharseContentModelBuilder.this.model);
                }
            }
        }, finalPhrase);
    }

    private void resetMembers(AniwaysAction<AniwaysPhraseToContentModel> callback) {
        this.callback = callback;
        this.model = new AniwaysPhraseAnimatedGifsModel();
        this.duringFetchingProcess = false;
        this.currentRequestId = -1;
        this.assetTypeData = null;
    }

    private void cancelAllgetDataForAssetTypeRequests() {
        if (this.assetTypeData != null && this.currentRequestId != -1) {
            this.assetTypeData.cancellBuildAssetInfosRequest(this.currentRequestId);
        }
    }
}

