/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import android.content.Context;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.analytics.utils.LooperThreadWithHandler;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AniwaysNetworkStateChecker
extends NonThrowingRunnable {
    private static final String TAG = "AniwaysNetworkStateChecker";
    private static final String THREAD_NAME = "AniwaysNetworkStateChecker";
    private static AniwaysNetworkStateChecker sInstance;
    private Context mContext;
    private LooperThreadWithHandler mThread;
    Queue<AniwaysNetworkSateCheckCallback> mCallbacks = new ConcurrentLinkedQueue<AniwaysNetworkSateCheckCallback>();

    public static void forceInit(Context applicationContext) {
        if (sInstance != null) {
            Log.e(true, "AniwaysNetworkStateChecker", "Calling init of AniwaysNetworkStateChecker more than once");
        }
        AniwaysNetworkStateChecker instance = new AniwaysNetworkStateChecker(applicationContext);
        LooperThreadWithHandler thread = new LooperThreadWithHandler("AniwaysNetworkStateChecker");
        instance.setThread(thread);
        if (sInstance != null) {
            Log.i("AniwaysNetworkStateChecker", "There is already a AniwaysNetworkStateChecker thread running, so interrupting it");
            LooperThreadWithHandler oldThread = sInstance.getThread();
            ((Thread)((Object)oldThread)).interrupt();
        }
        Log.i("AniwaysNetworkStateChecker", "Starting the AniwaysNetworkStateChecker..");
        thread.start();
        sInstance = instance;
    }

    private LooperThreadWithHandler getThread() {
        return this.mThread;
    }

    private void setThread(LooperThreadWithHandler thread) {
        this.mThread = thread;
    }

    public AniwaysNetworkStateChecker(Context context) {
        super("AniwaysNetworkStateChecker", "run", "");
        this.mContext = context;
    }

    @Override
    public void innerRun() {
        if (this.mCallbacks.size() < 1) {
            return;
        }
        boolean available = Utils.isInternetAvailable(this.mContext) != null;
        AniwaysNetworkSateCheckCallback callback = this.mCallbacks.poll();
        while (callback != null) {
            try {
                callback.run(available);
            }
            catch (Throwable tr) {
                Log.e(true, "AniwaysNetworkStateChecker", "Caught Exception in callback", tr);
            }
            callback = this.mCallbacks.poll();
        }
    }

    public static void checkInternet(AniwaysNetworkSateCheckCallback callback) {
        AniwaysNetworkStateChecker.sInstance.mCallbacks.offer(callback);
        sInstance.getThread().handler().post((Runnable)sInstance);
    }

    public static interface AniwaysNetworkSateCheckCallback {
        public void run(boolean var1);
    }
}

