/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.data;

import com.aniways.IconData;
import com.aniways.data.AnimatedGifsProviders;
import com.aniways.data.AniwaysPhraseAnimatedGifsUrlsBuilderProvider;
import com.aniways.data.DataForAssetTypeInPhrase;
import com.aniways.data.DataForPhraseRequestContext;
import com.aniways.data.IAniwaysAssetInfo;
import com.aniways.data.IPhraseAnimatedAssetInfoBuilder;
import com.aniways.data.JsonParser;
import com.aniways.data.Phrase;
import com.aniways.service.utils.AniwaysAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnimatedGifsDataForPhrase
extends DataForAssetTypeInPhrase {
    public static final AnimatedGifsDataForPhrase SEARCH_PHRASE_IN_ALL_PROVIDERS = AnimatedGifsDataForPhrase.initSearchPhraseInAllProvidersInstance();
    HashMap<String, String[]> dataForAssetType;

    private static AnimatedGifsDataForPhrase initSearchPhraseInAllProvidersInstance() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put(AnimatedGifsProviders.GIPHY.getStringRepresentaion(), null);
        AnimatedGifsDataForPhrase instance = new AnimatedGifsDataForPhrase(map);
        return instance;
    }

    public AnimatedGifsDataForPhrase(HashMap<String, String[]> dataForAssetType) {
        this.dataForAssetType = dataForAssetType;
    }

    @Override
    public Phrase getReferencePhrase(JsonParser parser, Phrase phrase) {
        return this.extractPrimaryPharse(phrase);
    }

    @Override
    public boolean isEmpty() {
        return this.dataForAssetType.isEmpty();
    }

    @Override
    public int buildAssetInfos(AniwaysAction<List<IAniwaysAssetInfo>> callback, Phrase phrase) {
        IPhraseAnimatedAssetInfoBuilder builder;
        if (this.isEmpty()) {
            callback.call(null);
            return -1;
        }
        AniwaysPhraseAnimatedGifsUrlsBuilderProvider builders = AniwaysPhraseAnimatedGifsUrlsBuilderProvider.getInstance();
        HashMap<IPhraseAnimatedAssetInfoBuilder, String[]> matchedBuilders = new HashMap<IPhraseAnimatedAssetInfoBuilder, String[]>();
        for (Map.Entry<String, String[]> entry : this.dataForAssetType.entrySet()) {
            String providerName = entry.getKey();
            String[] providerData = entry.getValue();
            if (this == SEARCH_PHRASE_IN_ALL_PROVIDERS) {
                providerData = new String[]{"search:" + phrase.getName()};
            }
            if ((builder = builders.provide(providerName)) == null) continue;
            matchedBuilders.put(builder, providerData);
        }
        if (matchedBuilders.isEmpty()) {
            callback.call(null);
            return -1;
        }
        DataForPhraseRequestContext ctx = new DataForPhraseRequestContext(matchedBuilders.keySet(), callback);
        int requestId = AnimatedGifsDataForPhrase.getNewRequestId();
        requests.put(requestId, ctx);
        for (Map.Entry entry : matchedBuilders.entrySet()) {
            builder = (IPhraseAnimatedAssetInfoBuilder)entry.getKey();
            String[] data = (String[])entry.getValue();
            builder.build(data, this.getBuildersCallback(requestId, ctx));
        }
        return requestId;
    }

    private Phrase extractPrimaryPharse(Phrase phrase) {
        if (phrase == null) {
            return null;
        }
        if (phrase.icons == null || phrase.icons.icons.length <= 0) {
            return null;
        }
        for (IconData icon : phrase.icons.icons) {
            Phrase primaryPhrase = icon.primaryPhrase;
            if (primaryPhrase == null) continue;
            if (primaryPhrase.animatedGifs == null) {
                primaryPhrase.animatedGifs = SEARCH_PHRASE_IN_ALL_PROVIDERS;
            }
            return primaryPhrase;
        }
        return phrase;
    }
}

