/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag.android;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.DisplayMetrics;
import com.aniways.bugsnag.Configuration;
import com.aniways.bugsnag.android.ActivityStack;
import com.aniways.bugsnag.android.Client;
import com.aniways.bugsnag.android.utils.Async;
import com.aniways.bugsnag.utils.JSONUtils;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.json.JSONObject;

class Diagnostics
extends com.aniways.bugsnag.Diagnostics {
    private static final String PREFS_NAME = "Bugsnag";
    private static Long startTime;
    private static String uuid;
    private Context applicationContext;
    private String packageName;

    public Diagnostics(Configuration config, Context context, Client client) {
        super(config);
        this.applicationContext = context;
        Diagnostics.startSessionTimer();
        this.packageName = this.applicationContext.getPackageName();
        if (this.packageName == null) {
            this.packageName = "N/A";
        }
        config.setProjectPackages(this.packageName);
        config.getOsVersion().set(Build.VERSION.RELEASE);
        config.getAppVersion().set(this.getPackageVersionName(this.packageName));
        config.getReleaseStage().set(this.guessReleaseStage(this.packageName));
        this.initialiseDeviceData();
        this.initialiseAppData();
    }

    @Override
    public JSONObject getAppState() {
        JSONObject appState = super.getAppState();
        JSONUtils.safePutOpt(appState, "duration", SystemClock.elapsedRealtime() - startTime);
        JSONUtils.safePutOpt(appState, "durationInForeground", ActivityStack.sessionLength());
        JSONUtils.safePutOpt(appState, "lowMemory", this.lowMemoryState());
        JSONUtils.safePutOpt(appState, "inForeground", ActivityStack.inForeground());
        List<String> activityStackNames = ActivityStack.getNames();
        if (activityStackNames.size() > 0) {
            JSONUtils.safePutOpt(appState, "screenStack", activityStackNames);
        }
        JSONUtils.safePutOpt(appState, "activeScreen", ActivityStack.getTopActivityName());
        JSONUtils.safePutOpt(appState, "memoryUsage", this.memoryUsedByApp());
        return appState;
    }

    @Override
    public JSONObject getDeviceState() {
        JSONObject deviceState = super.getDeviceState();
        JSONUtils.safePutOpt(deviceState, "freeMemory", this.totalFreeMemory());
        JSONUtils.safePutOpt(deviceState, "orientation", this.getOrientation());
        JSONUtils.safePutOpt(deviceState, "batteryLevel", this.getChargeLevel());
        JSONUtils.safePutOpt(deviceState, "freeDisk", this.getFreeDiskSpace());
        JSONUtils.safePutOpt(deviceState, "charging", this.getCharging());
        JSONUtils.safePutOpt(deviceState, "locationStatus", this.getGpsAllowed());
        JSONUtils.safePutOpt(deviceState, "networkAccess", this.getNetworkStatus());
        return deviceState;
    }

    @Override
    public JSONObject getDeviceData() {
        super.getDeviceData();
        JSONUtils.safePutOpt(this.deviceData, "id", this.getUUID());
        return this.deviceData;
    }

    @Override
    public String getContext() {
        return this.config.getContext().get(ActivityStack.getTopActivityName());
    }

    @Override
    public JSONObject getUser() {
        JSONObject user = super.getUser();
        if (user.optString("id").equals("")) {
            JSONUtils.safePut(user, "id", this.getUUID());
        }
        return user;
    }

    protected void initialiseDeviceData() {
        JSONUtils.safePutOpt(this.deviceData, "manufacturer", Build.MANUFACTURER);
        JSONUtils.safePutOpt(this.deviceData, "model", Build.MODEL);
        JSONUtils.safePutOpt(this.deviceData, "screenDensity", Float.valueOf(this.applicationContext.getResources().getDisplayMetrics().density));
        JSONUtils.safePutOpt(this.deviceData, "screenResolution", this.getResolution());
        JSONUtils.safePutOpt(this.deviceData, "totalMemory", this.totalMemoryAvailable());
        JSONUtils.safePutOpt(this.deviceData, "osName", "android");
        JSONUtils.safePutOpt(this.deviceData, "apiLevel", Build.VERSION.SDK_INT);
        JSONUtils.safePutOpt(this.deviceData, "jailbroken", this.checkIsRooted());
        JSONUtils.safePutOpt(this.deviceData, "locale", Locale.getDefault().toString());
    }

    protected void initialiseAppData() {
        JSONUtils.safePutOpt(this.appData, "id", this.packageName);
        JSONUtils.safePutOpt(this.appData, "packageName", this.packageName);
        JSONUtils.safePutOpt(this.appData, "name", this.getAppName());
        JSONUtils.safePutOpt(this.appData, "versionName", this.getPackageVersionName(this.packageName));
        JSONUtils.safePutOpt(this.appData, "versionCode", this.getPackageVersionCode(this.packageName));
    }

    protected static void startSessionTimer() {
        if (startTime == null) {
            startTime = SystemClock.elapsedRealtime();
        }
    }

    protected Long getFreeDiskSpace() {
        Long diskSpace = null;
        try {
            StatFs externalStat = new StatFs(Environment.getExternalStorageDirectory().getPath());
            long externalBytesAvailable = (long)externalStat.getBlockSize() * (long)externalStat.getBlockCount();
            StatFs internalStat = new StatFs(Environment.getDataDirectory().getPath());
            long internalBytesAvailable = (long)internalStat.getBlockSize() * (long)internalStat.getBlockCount();
            diskSpace = Math.min(internalBytesAvailable, externalBytesAvailable);
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return diskSpace;
    }

    protected Boolean getCharging() {
        Boolean isCharging = null;
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = this.applicationContext.registerReceiver(null, ifilter);
            int status = batteryStatus.getIntExtra("status", -1);
            isCharging = status == 2 || status == 5;
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return isCharging;
    }

    protected Float getChargeLevel() {
        Float chargeLevel = null;
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = this.applicationContext.registerReceiver(null, ifilter);
            int level = batteryStatus.getIntExtra("level", -1);
            int scale = batteryStatus.getIntExtra("scale", -1);
            chargeLevel = Float.valueOf((float)level / (float)scale);
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return chargeLevel;
    }

    protected String getOrientation() {
        String orientation = null;
        try {
            switch (this.applicationContext.getResources().getConfiguration().orientation) {
                case 2: {
                    orientation = "landscape";
                    break;
                }
                case 1: {
                    orientation = "portrait";
                }
            }
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return orientation;
    }

    protected String getAppName() {
        String appName = null;
        try {
            appName = this.applicationContext.getPackageManager().getApplicationInfo((String)this.packageName, (int)0).name;
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return appName;
    }

    protected String getResolution() {
        String resolution = null;
        try {
            DisplayMetrics metrics = this.applicationContext.getResources().getDisplayMetrics();
            resolution = String.format("%dx%d", Math.max(metrics.widthPixels, metrics.heightPixels), Math.min(metrics.widthPixels, metrics.heightPixels));
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return resolution;
    }

    protected int getPackageVersionCode(String packageName) {
        int versionCode = 0;
        try {
            PackageInfo pi = this.applicationContext.getPackageManager().getPackageInfo(packageName, 0);
            versionCode = pi.versionCode;
        }
        catch (Throwable t) {
            this.config.logger.warn("Could not get package versionCode", t);
        }
        return versionCode;
    }

    protected String getPackageVersionName(String packageName) {
        String packageVersion = null;
        try {
            PackageInfo pi = this.applicationContext.getPackageManager().getPackageInfo(packageName, 0);
            packageVersion = pi.versionName;
        }
        catch (Throwable t) {
            this.config.logger.warn("Could not get package versionName", t);
        }
        return packageVersion;
    }

    protected String guessReleaseStage(String packageName) {
        String releaseStage = "production";
        try {
            boolean debuggable;
            ApplicationInfo ai = this.applicationContext.getPackageManager().getApplicationInfo(packageName, 0);
            boolean bl = debuggable = (ai.flags & 2) != 0;
            if (debuggable) {
                releaseStage = "development";
            }
        }
        catch (Throwable t) {
            this.config.logger.warn("Could not guess release stage", t);
        }
        return releaseStage;
    }

    protected synchronized String getUUID() {
        if (uuid != null) {
            return uuid;
        }
        final SharedPreferences settings = this.applicationContext.getSharedPreferences(PREFS_NAME, 0);
        uuid = settings.getString("userId", null);
        if (uuid == null) {
            final String finalUuid = uuid = UUID.randomUUID().toString();
            Async.safeAsync(new Runnable(){

                @Override
                public void run() {
                    SharedPreferences.Editor editor = settings.edit();
                    editor.putString("userId", finalUuid);
                    editor.commit();
                }
            });
        }
        return uuid;
    }

    protected Long totalMemoryAvailable() {
        Long totalMemory = null;
        try {
            totalMemory = Runtime.getRuntime().maxMemory() != Long.MAX_VALUE ? Long.valueOf(Runtime.getRuntime().maxMemory()) : Long.valueOf(Runtime.getRuntime().totalMemory());
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return totalMemory;
    }

    protected Long totalFreeMemory() {
        Long freeMemory = null;
        try {
            freeMemory = this.totalMemoryAvailable() - this.memoryUsedByApp();
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return freeMemory;
    }

    protected Long memoryUsedByApp() {
        Long memoryUsedByApp = null;
        try {
            memoryUsedByApp = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return memoryUsedByApp;
    }

    protected Boolean lowMemoryState() {
        Boolean lowMemory = null;
        try {
            ActivityManager activityManager = (ActivityManager)this.applicationContext.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memInfo);
            lowMemory = memInfo.lowMemory;
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return lowMemory;
    }

    protected boolean checkIsRooted() {
        return this.checkTestKeysBuild() || this.checkSuperUserAPK();
    }

    protected boolean checkTestKeysBuild() {
        String buildTags = Build.TAGS;
        return buildTags != null && buildTags.contains("test-keys");
    }

    protected boolean checkSuperUserAPK() {
        try {
            File file = new File("/system/app/Superuser.apk");
            return file.exists();
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected String getNetworkStatus() {
        String networkStatus = null;
        try {
            ConnectivityManager cm = (ConnectivityManager)this.applicationContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            networkStatus = activeNetwork != null && activeNetwork.isConnectedOrConnecting() ? (activeNetwork.getType() == 1 ? "wifi" : (activeNetwork.getType() == 9 ? "ethernet" : "cellular")) : "none";
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return networkStatus;
    }

    protected String getGpsAllowed() {
        String gpsAllowed = null;
        try {
            ContentResolver cr = this.applicationContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            gpsAllowed = providersAllowed != null && providersAllowed.length() > 0 ? "allowed" : "disallowed";
        }
        catch (Throwable t) {
            this.config.logger.warn(t);
        }
        return gpsAllowed;
    }
}

