/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag.android;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.aniways.bugsnag.MetaData;
import com.aniways.bugsnag.android.ActivityStack;
import com.aniways.bugsnag.android.Client;

public class Bugsnag {
    private static Client client;
    private static final String TAG = "Bugsnag";

    public static void register(Context androidContext, String apiKey) {
        Bugsnag.register(androidContext, apiKey, true);
    }

    public static void register(Context androidContext, String apiKey, boolean enableMetrics) {
        try {
            client = new Client(androidContext, apiKey, enableMetrics);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Unable to register with bugsnag. ", (Throwable)ex);
        }
    }

    public static Client getClient() {
        return client;
    }

    public static void setContext(final String context) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setContext(context);
            }
        });
    }

    public static void setContext(final Activity context) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setContext(context);
            }
        });
    }

    public static void setUserId(final String userId) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setUserId(userId);
            }
        });
    }

    public static void setUser(final String id2, final String email, final String name) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setUser(id2, email, name);
            }
        });
    }

    public static void setReleaseStage(final String releaseStage) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setReleaseStage(releaseStage);
            }
        });
    }

    public static void setNotifyReleaseStages(final String ... notifyReleaseStages) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setNotifyReleaseStages(notifyReleaseStages);
            }
        });
    }

    public static void setAutoNotify(final boolean autoNotify) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setAutoNotify(autoNotify);
            }
        });
    }

    public static void setUseSSL(final boolean useSSL) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setUseSSL(useSSL);
            }
        });
    }

    public static void setEndpoint(final String endpoint) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setEndpoint(endpoint);
            }
        });
    }

    public static void setIgnoreClasses(final String ... ignoreClasses) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setIgnoreClasses(ignoreClasses);
            }
        });
    }

    public static void setProjectPackages(final String ... projectPackages) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setProjectPackages(projectPackages);
            }
        });
    }

    public static void setFilters(final String ... filters) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setFilters(filters);
            }
        });
    }

    public static void setAppVersion(final String appVersion) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.setAppVersion(appVersion);
            }
        });
    }

    public static void addToTab(final String tab, final String key, final Object value) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.addToTab(tab, key, value);
            }
        });
    }

    public static void notify(Throwable e) {
        Bugsnag.notify(e, null, null);
    }

    public static void notify(Throwable e, String severity) {
        Bugsnag.notify(e, severity, null);
    }

    public static void notify(Throwable e, MetaData overrides) {
        Bugsnag.notify(e, null, overrides);
    }

    public static void notify(final Throwable e, final String severity, final MetaData overrides) {
        Bugsnag.runOnClient(new Runnable(){

            @Override
            public void run() {
                client.notify(e, severity, overrides);
            }
        });
    }

    public static void onActivityCreate(Activity activity) {
        ActivityStack.add(activity);
    }

    public static void onActivityResume(Activity activity) {
        ActivityStack.setTopActivity(activity);
    }

    public static void onActivityPause(Activity activity) {
        ActivityStack.clearTopActivity();
    }

    public static void onActivityDestroy(Activity activity) {
        ActivityStack.remove(activity);
    }

    private static void runOnClient(Runnable delegate) {
        if (client != null) {
            try {
                delegate.run();
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Error in bugsnag.", (Throwable)t);
            }
        } else {
            Log.e((String)TAG, (String)"You must call Bugsnag.register before any other Bugsnag methods.");
        }
    }
}

