/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag.android;

import android.app.Activity;
import android.content.Context;
import android.os.SystemClock;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;

public class ActivityStack {
    private static List<WeakReference<Context>> storedContexts = new LinkedList<WeakReference<Context>>();
    private static WeakReference<Context> topContext;
    private static long sessionStartTime;
    private static long lastScreenClosed;
    private static boolean inForeground;
    private static final long TIME_FOR_SESSION_TO_HALT = 10000L;

    public static void add(Activity activity) {
        ActivityStack.prune();
        storedContexts.add(new WeakReference<Activity>(activity));
    }

    public static void remove(Activity activity) {
        ActivityStack.prune();
        for (WeakReference<Context> ref : storedContexts) {
            if (ref.get() != activity) continue;
            storedContexts.remove(ref);
            break;
        }
    }

    public static List<String> getNames() {
        ActivityStack.prune();
        LinkedList<String> goodContexts = new LinkedList<String>();
        for (WeakReference<Context> ref : storedContexts) {
            if (ref.get() == null) continue;
            goodContexts.add(ActivityStack.getContextName((Context)ref.get()));
        }
        return goodContexts;
    }

    public static void setTopActivity(Activity activity) {
        topContext = new WeakReference<Activity>(activity);
        inForeground = true;
        if (lastScreenClosed + 10000L < SystemClock.elapsedRealtime()) {
            sessionStartTime = SystemClock.elapsedRealtime();
        }
    }

    public static void clearTopActivity() {
        topContext = null;
        inForeground = false;
        lastScreenClosed = SystemClock.elapsedRealtime();
    }

    public static String getTopActivityName() {
        String name = null;
        Context context = ActivityStack.getTopActivity();
        if (context != null) {
            name = ActivityStack.getContextName(context);
        }
        return name;
    }

    public static String getContextName(Context context) {
        String name = context.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static boolean inForeground() {
        return inForeground;
    }

    public static Long sessionLength() {
        if (inForeground) {
            return SystemClock.elapsedRealtime() - sessionStartTime;
        }
        return null;
    }

    private static Boolean contains(Context context) {
        for (WeakReference<Context> ref : storedContexts) {
            if (ref.get() != context) continue;
            return true;
        }
        return false;
    }

    private static Context getTopActivity() {
        if (topContext != null) {
            return (Context)topContext.get();
        }
        return null;
    }

    private static void prune() {
        LinkedList<WeakReference<Context>> toRemove = new LinkedList<WeakReference<Context>>();
        for (WeakReference<Object> ref : storedContexts) {
            if (ref.get() != null) continue;
            toRemove.add(ref);
        }
        for (WeakReference<Object> ref : toRemove) {
            storedContexts.remove(ref);
        }
    }

    static {
        sessionStartTime = 0L;
        lastScreenClosed = 0L;
        inForeground = false;
    }
}

