/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.bugsnag;

import com.aniways.bugsnag.utils.JSONUtils;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class MetaData
extends JSONObject {
    public MetaData() {
    }

    public MetaData(MetaData source) {
        Iterator keys = source.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = source.opt(key);
            if (value == null) continue;
            if (value instanceof JSONObject) {
                value = JSONUtils.deepClone((JSONObject)value);
            }
            JSONUtils.safePut(this, key, value);
        }
    }

    public void addToTab(String tabName, String key, Object value) {
        if (value != null) {
            JSONUtils.safePut(this.getTab(tabName), key, value);
        } else {
            this.getTab(tabName).remove(key);
        }
    }

    public void addToTab(String tabName, Object value) {
        if (value instanceof Map) {
            JSONObject tab = this.getTab(tabName);
            Map mapValue = (Map)value;
            for (Map.Entry entry : mapValue.entrySet()) {
                JSONUtils.safePut(tab, (String)entry.getKey(), entry.getValue());
            }
        } else {
            this.addToTab("Custom Data", tabName, value);
        }
    }

    public void clearTab(String tabName) {
        this.remove(tabName);
    }

    public MetaData duplicate() {
        return new MetaData(this);
    }

    public MetaData filter(String[] filters) {
        JSONUtils.filter(this, filters);
        return this;
    }

    public MetaData merge(JSONObject source) {
        JSONUtils.merge(this, source);
        return this;
    }

    private JSONObject getTab(String tabName) {
        Object tab = this.opt(tabName);
        if (tab == null || !(tab instanceof JSONObject)) {
            tab = new JSONObject();
            JSONUtils.safePut(this, tabName, tab);
        }
        return (JSONObject)tab;
    }
}

