/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.blur;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.PathShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.View;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.ViewUtils;
import com.aniways.blur.BlurLinearLayout;
import java.util.Locale;

public class ContextualBubbleView
extends BlurLinearLayout {
    private static final int DEFAULT_POINTER_HEIGHT = 15;
    private static final int DEFAULT_POINTER_WIDTH = 15;
    private static final int DEFAULT_CORNER_RADIUS = 12;
    private static final int DEFAULT_BUBBLE_COLOR = 0x66000000;
    private static final int DEFAULT_BUBBLE_OUTLINE_COLOR = -16777216;
    private static final int DEFAULT_SHADOW_COLOR = -7829368;
    private static final int DEFAULT_SHADOW_RADIUS = 0;
    private static final int DEFAULT_SHADOW_OFFSET_X = 0;
    private static final int DEFAULT_SHADOW_OFFSET_Y = 0;
    private static final int DEFAULT_BUBBLE_GRADIENT_TOP_COLOR = 0x66000000;
    private static final int DEFAULT_BUBBLE_GRADIENT_BOTTOM_COLOR = 0x66000000;
    private static final int DEFAULT_BUBBLE_OUTLINE_WIDTH = 1;
    private static final String TAG = "AniwaysContextualBubbleView";
    private Path bubblePath;
    int pointerHeight = 15;
    private int pointerWidth = 15;
    private int cornerRadius = 12;
    private int bubbleColor = 0x66000000;
    private int bubbleOutlineColor = -16777216;
    private int shadowColor = -7829368;
    private int bubbleGradientTopColor = 0x66000000;
    private int bubbleGradientBottomColor = 0x66000000;
    private int shadowRadius = 0;
    private int shadowOffsetX = 0;
    private int shadowOffsetY = 0;
    private int bubbleOutlineWidth = 1;
    private PathShape pathShape;
    private ShapeDrawable fillLayer;
    private ShapeDrawable outlineLayer;
    private float pointerCenter;
    private boolean forceLayout = false;
    private boolean arrowDown = true;

    public ContextualBubbleView(Context context) {
        super(context);
    }

    public ContextualBubbleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttributes(context, attrs);
    }

    public void setArrowDown(float center) {
        if (!this.arrowDown) {
            this.setPadding(this.getPaddingLeft(), this.getPaddingTop() - this.pointerHeight, this.getPaddingRight(), this.getPaddingBottom() + this.pointerHeight);
        }
        this.arrowDown = true;
        this.setArrowLocation(center);
    }

    public void setArrowUp(float center) {
        if (this.arrowDown) {
            this.setPadding(this.getPaddingLeft(), this.getPaddingTop() + this.pointerHeight, this.getPaddingRight(), this.getPaddingBottom() - this.pointerHeight);
        }
        this.arrowDown = false;
        this.setArrowLocation(center);
    }

    private void setArrowLocation(float center) {
        this.pointerCenter = center;
        this.forceLayout = true;
        this.requestLayout();
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (!changed && !this.forceLayout) {
            return;
        }
        float inset = (float)this.bubbleOutlineWidth * 0.5f;
        this.calculateBubblePath(0.0f + inset, 0.0f + inset, (float)(r - l) - inset, (float)(b - t) - inset);
        int w = r - l;
        int h = b - t;
        this.fillLayer.setIntrinsicWidth(w);
        this.fillLayer.setIntrinsicHeight(h);
        this.fillLayer.setBounds(l, t, r, b);
        this.outlineLayer.setIntrinsicWidth(w);
        this.outlineLayer.setIntrinsicHeight(h);
        this.outlineLayer.setBounds(l, t, r, b);
        ((LayerDrawable)this.getBackground()).setBounds(l, t, r, b);
        this.pathShape = new PathShape(this.bubblePath, (float)w, (float)h);
        this.fillLayer.setShape((Shape)this.pathShape);
        this.outlineLayer.setShape((Shape)this.pathShape);
        this.forceLayout = false;
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AniwaysContextualBubbleView);
        this.pointerHeight = a.getDimensionPixelSize(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_pointerHeight, 15);
        this.pointerWidth = a.getDimensionPixelSize(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_pointerWidth, 15);
        this.cornerRadius = a.getDimensionPixelSize(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_cornerRadius, 12);
        this.bubbleColor = a.getColor(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_color, 0x66000000);
        this.bubbleOutlineColor = a.getColor(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_outlineColor, -16777216);
        this.bubbleOutlineWidth = a.getDimensionPixelSize(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_outlineWidth, 1);
        this.shadowColor = a.getColor(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_shadowColor, -7829368);
        this.shadowRadius = a.getDimensionPixelSize(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_shadowRadius, 0);
        this.shadowOffsetX = a.getDimensionPixelOffset(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_shadowOffsetX, 0);
        this.shadowOffsetY = a.getDimensionPixelOffset(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_shadowOffsetY, 0);
        this.bubbleGradientTopColor = a.getColor(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_gradientTopColor, 0x66000000);
        this.bubbleGradientBottomColor = a.getColor(R.styleable.AniwaysContextualBubbleView_aniways_contextual_bubble_gradientBottomColor, 0x66000000);
        a.recycle();
        int minWidth = this.cornerRadius * 2 + this.pointerWidth + this.bubbleOutlineWidth;
        int minHeight = 2 * this.cornerRadius + this.pointerHeight + this.bubbleOutlineWidth;
        this.setMinimumWidth(minWidth);
        this.setMinimumHeight(minHeight);
        this.pointerCenter = (float)minWidth / 2.0f;
        this.arrowDown = true;
        this.bubblePath = new Path();
        this.pathShape = new PathShape(this.bubblePath, (float)minWidth, (float)minHeight);
        this.fillLayer = new ShapeDrawable((Shape)this.pathShape);
        this.fillLayer.getPaint().setStyle(Paint.Style.FILL);
        this.fillLayer.getPaint().setColor(this.bubbleColor);
        this.fillLayer.getPaint().setAntiAlias(true);
        this.outlineLayer = new ShapeDrawable((Shape)this.pathShape);
        this.outlineLayer.getPaint().setStyle(Paint.Style.STROKE);
        this.outlineLayer.getPaint().setColor(this.bubbleOutlineColor);
        this.outlineLayer.getPaint().setStrokeWidth((float)this.bubbleOutlineWidth);
        this.outlineLayer.getPaint().setAntiAlias(true);
        LayerDrawable ld = new LayerDrawable(new Drawable[]{this.fillLayer, this.outlineLayer});
        int pLeft = this.getPaddingLeft();
        int pTop = this.getPaddingTop();
        int pRight = this.getPaddingRight();
        int pBottom = this.getPaddingBottom();
        this.setBackgroundDrawable((Drawable)ld);
        this.setPadding(pLeft, pTop + this.cornerRadius, pRight, pBottom + this.cornerRadius + this.pointerHeight);
    }

    private void calculateBubblePath(float l, float t, float r, float b) {
        this.bubblePath.reset();
        float viewBottom = b;
        float viewWidth = r - l;
        float viewHeight = b - t;
        float halfPointerWidth = (float)this.pointerWidth / 2.0f;
        float minPointerCenter = l + (float)this.cornerRadius + halfPointerWidth;
        float maxPointerCenter = r - (float)this.cornerRadius - halfPointerWidth;
        float cornerDiameter = 2 * this.cornerRadius;
        float pointerCenterTemp = this.pointerCenter - (float)ViewUtils.getRelativeLeftToViewRoot((View)this);
        if (viewWidth - cornerDiameter < (float)this.pointerWidth) {
            Log.w(true, TAG, String.format(Locale.US, "Not showing pointer cause there is not enough room for it. L:%s, T:%s, R:%s, B:%s, Pointer width:%s", Float.valueOf(l), Float.valueOf(t), Float.valueOf(r), Float.valueOf(b), this.pointerWidth));
            this.pointerWidth = -1;
            r = l + cornerDiameter;
        }
        if (viewHeight < cornerDiameter) {
            Log.w(true, TAG, String.format(Locale.US, "Setting path height to cornerDiameter as it is less then corner diameter. L:%s, T:%s, R:%s, B:%s, cornerDiameter:%s", Float.valueOf(l), Float.valueOf(t), Float.valueOf(r), Float.valueOf(b), Float.valueOf(cornerDiameter)));
            this.pointerWidth = -1;
            b = t + cornerDiameter;
        } else if (minPointerCenter > pointerCenterTemp) {
            pointerCenterTemp = minPointerCenter;
        } else if (maxPointerCenter < pointerCenterTemp) {
            pointerCenterTemp = maxPointerCenter;
        }
        RectF cornerRect = new RectF(0.0f, 0.0f, cornerDiameter, cornerDiameter);
        if ((float)this.pointerHeight > 0.0f && (float)this.pointerWidth > 0.0f) {
            if (this.arrowDown) {
                float bubbleBottom = viewBottom - (float)this.pointerHeight;
                this.bubblePath.moveTo(pointerCenterTemp, viewBottom);
                this.bubblePath.lineTo(pointerCenterTemp + halfPointerWidth, bubbleBottom);
                this.bubblePath.lineTo(r - (float)this.cornerRadius, bubbleBottom);
                cornerRect.offsetTo(r - cornerDiameter, bubbleBottom - cornerDiameter);
                this.bubblePath.arcTo(cornerRect, 90.0f, -90.0f);
                this.bubblePath.lineTo(r, t + (float)this.cornerRadius);
                cornerRect.offsetTo(r - cornerDiameter, t);
                this.bubblePath.arcTo(cornerRect, 0.0f, -90.0f);
                this.bubblePath.lineTo(l + (float)this.cornerRadius, t);
                cornerRect.offsetTo(l, t);
                this.bubblePath.arcTo(cornerRect, 270.0f, -90.0f);
                this.bubblePath.lineTo(l, bubbleBottom - (float)this.cornerRadius);
                cornerRect.offsetTo(l, bubbleBottom - cornerDiameter);
                this.bubblePath.arcTo(cornerRect, 180.0f, -90.0f);
                this.bubblePath.lineTo(pointerCenterTemp - halfPointerWidth, bubbleBottom);
                this.bubblePath.lineTo(pointerCenterTemp, viewBottom);
                this.bubblePath.close();
            } else {
                float bubbleTop = t + (float)this.pointerHeight;
                this.bubblePath.moveTo(pointerCenterTemp, t);
                this.bubblePath.lineTo(pointerCenterTemp - halfPointerWidth, bubbleTop);
                this.bubblePath.lineTo(l + (float)this.cornerRadius, bubbleTop);
                cornerRect.offsetTo(l, bubbleTop);
                this.bubblePath.arcTo(cornerRect, 270.0f, -90.0f);
                this.bubblePath.lineTo(l, b - (float)this.cornerRadius);
                cornerRect.offsetTo(l, b - cornerDiameter);
                this.bubblePath.arcTo(cornerRect, 180.0f, -90.0f);
                this.bubblePath.lineTo(r - (float)this.cornerRadius, b);
                cornerRect.offsetTo(r - cornerDiameter, b - cornerDiameter);
                this.bubblePath.arcTo(cornerRect, 90.0f, -90.0f);
                this.bubblePath.lineTo(r, bubbleTop + (float)this.cornerRadius);
                cornerRect.offsetTo(r - cornerDiameter, bubbleTop);
                this.bubblePath.arcTo(cornerRect, 0.0f, -90.0f);
                this.bubblePath.lineTo(pointerCenterTemp + halfPointerWidth, bubbleTop);
                this.bubblePath.lineTo(pointerCenterTemp, t);
                this.bubblePath.close();
            }
        } else {
            this.bubblePath.addRoundRect(new RectF(l, t, r, b), (float)this.cornerRadius, (float)this.cornerRadius, Path.Direction.CW);
        }
    }

    private LinearGradient calculateGradient(int l, int t, int r, int b) {
        return new LinearGradient(0.0f, 0.0f, 0.0f, (float)(b - t), this.bubbleGradientTopColor, this.bubbleGradientBottomColor, Shader.TileMode.CLAMP);
    }
}

