/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.blur;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.aniways.Log;
import com.aniways.ViewUtils;
import com.aniways.blur.IBlurLayout;
import com.aniways.data.AniwaysPrivateConfig;

public class BlurRenderer {
    private static final float BITMAP_SCALE_FACTOR = AniwaysPrivateConfig.getInstance().blurBitmapScaleFactor;
    private static final String TAG = "AniwaysBlurRenderer";
    private static boolean sDoNotInitRS = false;
    private static ScriptIntrinsicBlur sScript;
    private static Context sContext;
    private static RenderScript sRS;
    private final View mView;
    private final Canvas mCanvas;
    private final Matrix mMatrixScale;
    private Bitmap mBitmap;
    private Allocation mAllocationBitmap;
    private boolean mPerformBlur = false;
    private float mRadius = 1.0f;
    private Bitmap mask;
    private final ViewTreeObserver.OnPreDrawListener onPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            try {
                if (BlurRenderer.this.mView.getVisibility() == 0) {
                    BlurRenderer.this.drawOffscreenBitmap();
                }
            }
            catch (Throwable e) {
                Log.e(true, BlurRenderer.TAG, "Caught Exception in onPreDraw", e);
            }
            return true;
        }
    };

    public static void initRenderScript(Context context) {
        if (!AniwaysPrivateConfig.getInstance().getUseBlurEffect()) {
            return;
        }
        try {
            sContext = context.getApplicationContext();
            sRS = RenderScript.create((Context)context.getApplicationContext());
            sScript = ScriptIntrinsicBlur.create((RenderScript)sRS, (Element)Element.U8_4((RenderScript)sRS));
        }
        catch (Throwable ex) {
            sDoNotInitRS = true;
            Log.e(true, TAG, "Could not init renderscript", ex);
        }
    }

    public static RenderScript getRS() {
        if (sRS == null && !sDoNotInitRS) {
            BlurRenderer.initRenderScript(sContext);
        }
        if (sRS == null) {
            Log.w(false, TAG, "Returning null RS");
        }
        return sRS;
    }

    public BlurRenderer(View view) {
        this.mView = view;
        sContext = view.getContext().getApplicationContext();
        this.mCanvas = new Canvas();
        this.mMatrixScale = new Matrix();
        this.mPerformBlur = AniwaysPrivateConfig.getInstance().getUseBlurEffect();
        if (this.mView.isInEditMode()) {
            this.mPerformBlur = false;
        }
        if (sRS == null) {
            this.mPerformBlur = false;
            Log.w(false, TAG, "RS null in cTor");
        }
    }

    public void onAttachedToWindow() {
        this.mView.getViewTreeObserver().addOnPreDrawListener(this.onPreDrawListener);
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void onDetachedFromWindow() {
        this.mView.getViewTreeObserver().removeOnPreDrawListener(this.onPreDrawListener);
    }

    public boolean isOffscreenCanvas(Canvas canvas) {
        return canvas == this.mCanvas;
    }

    public void applyBlur() {
        if (!this.mPerformBlur) {
            return;
        }
        RenderScript rs = BlurRenderer.getRS();
        if (rs == null) {
            this.mPerformBlur = false;
            Log.w(false, TAG, "Not applyig blur cause couldnt create renderscript");
            return;
        }
        this.mAllocationBitmap.copyFrom(this.mBitmap);
        sScript.setRadius(this.mRadius);
        sScript.setInput(this.mAllocationBitmap);
        sScript.forEach(this.mAllocationBitmap);
        this.mAllocationBitmap.copyTo(this.mBitmap);
    }

    public void drawToCanvas(Canvas canvas) {
        if (BlurRenderer.getRS() == null) {
            this.mPerformBlur = false;
            Log.w(false, TAG, "RS null in drawToCanvas");
        }
        if (!this.mPerformBlur || this.mBitmap == null) {
            Drawable background = this.mView.getBackground();
            if (background != null) {
                background.setBounds(0, 0, this.mView.getWidth(), this.mView.getHeight());
                background.draw(canvas);
            }
            return;
        }
        if (this.mask != null && !AniwaysPrivateConfig.getInstance().performLiveBlur) {
            canvas.drawBitmap(this.mask, new Matrix(), null);
            return;
        }
        this.mask = this.drawableToBitmap(this.mView.getBackground(), this.mView.getWidth(), this.mView.getHeight());
        if (this.mask == null) {
            canvas.drawBitmap(this.mBitmap, new Matrix(), null);
            return;
        }
        Paint xferPaint = new Paint(1);
        xferPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        Canvas resultCanvas = new Canvas(this.mask);
        resultCanvas.save();
        resultCanvas.scale(1.0f / BITMAP_SCALE_FACTOR, 1.0f / BITMAP_SCALE_FACTOR);
        resultCanvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, xferPaint);
        Drawable background = this.mView.getBackground();
        if (background != null) {
            background.setBounds(0, 0, this.mask.getWidth(), this.mask.getHeight());
            resultCanvas.restore();
            background.draw(resultCanvas);
        }
        canvas.drawBitmap(this.mask, new Matrix(), null);
    }

    private Bitmap drawableToBitmap(Drawable drawable2, int width, int height) {
        Bitmap bitmap;
        if (drawable2 == null) {
            return null;
        }
        boolean isColorDrawable = false;
        if (drawable2 instanceof ColorDrawable) {
            isColorDrawable = true;
        }
        if (!isColorDrawable) {
            drawable2.setColorFilter(-16777216, PorterDuff.Mode.DST_OVER);
        }
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            if (isColorDrawable) {
                canvas.drawColor(-16777216);
            } else {
                drawable2.draw(canvas);
            }
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Caught Exception in drawableToBitmap", e);
            bitmap = null;
        }
        if (!isColorDrawable) {
            drawable2.clearColorFilter();
        }
        return bitmap;
    }

    @SuppressLint(value={"NewApi"})
    private void drawOffscreenBitmap() {
        if (!this.mPerformBlur) {
            return;
        }
        if (BlurRenderer.getRS() == null) {
            this.mPerformBlur = false;
            Log.w(false, TAG, "RS null in drawOffscreenBitmap");
            return;
        }
        if (this.mBitmap != null && !AniwaysPrivateConfig.getInstance().performLiveBlur) {
            return;
        }
        int width = (int)Math.ceil((float)this.mView.getWidth() * BITMAP_SCALE_FACTOR);
        int height = (int)Math.ceil((float)this.mView.getHeight() * BITMAP_SCALE_FACTOR);
        width = width + 4 & 0xFFFFFFFC;
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        this.mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mAllocationBitmap = Allocation.createFromBitmap((RenderScript)sRS, (Bitmap)this.mBitmap);
        Allocation.createSized((RenderScript)sRS, (Element)Element.U8_3((RenderScript)sRS), (int)(width * height));
        this.mMatrixScale.setScale(BITMAP_SCALE_FACTOR, BITMAP_SCALE_FACTOR);
        this.mCanvas.restoreToCount(1);
        this.mCanvas.setBitmap(this.mBitmap);
        this.mCanvas.setMatrix(this.mMatrixScale);
        int b4 = this.mCanvas.save();
        int x = ViewUtils.getRelativeLeftToViewRoot(this.mView);
        int y = ViewUtils.getRelativeTopToViewRoot(this.mView);
        this.mCanvas.translate((float)(-x), (float)(-y));
        View viewBehindPopup = ((IBlurLayout)this.mView).getViewBehindPopup();
        if (viewBehindPopup != null) {
            int saveBeforeRootBehindPopupDraw = this.mCanvas.save();
            View rootView = this.mView.getRootView();
            WindowManager.LayoutParams params = (WindowManager.LayoutParams)rootView.getLayoutParams();
            View behindPopupRootView = viewBehindPopup.getRootView();
            int keyboardHeight = this.viewInLandscape(rootView) ? this.getKeyboardHeight(behindPopupRootView) : 0;
            this.mCanvas.translate((float)(-params.x), (float)(-(params.y + keyboardHeight)));
            behindPopupRootView.draw(this.mCanvas);
            this.mCanvas.restoreToCount(saveBeforeRootBehindPopupDraw);
        }
        this.mView.getRootView().draw(this.mCanvas);
        this.mCanvas.restoreToCount(b4);
        this.applyBlur();
    }

    private boolean viewInLandscape(View view) {
        int orientation = view.getResources().getConfiguration().orientation;
        return orientation == 2;
    }

    private int getKeyboardHeight(View rootView) {
        Rect r = new Rect();
        rootView.getWindowVisibleDisplayFrame(r);
        int screenHeight = rootView.getRootView().getHeight();
        int keyboardHeight = screenHeight - r.bottom;
        return keyboardHeight > 100 ? keyboardHeight : 0;
    }

    public void setBlurRadius(float radius) {
        if (this.mView.isInEditMode()) {
            this.mPerformBlur = false;
            return;
        }
        if (BlurRenderer.getRS() == null) {
            this.mPerformBlur = false;
            Log.w(false, TAG, "RS null in setBlurRadius");
            return;
        }
        if (radius <= 0.0f) {
            this.mPerformBlur = false;
            return;
        }
        this.mRadius = radius * BITMAP_SCALE_FACTOR;
        if (this.mRadius > 25.0f) {
            this.mRadius = 25.0f;
        } else if (this.mRadius < 1.0f) {
            this.mRadius = 1.0f;
        }
        this.mBitmap = null;
        this.mask = null;
        this.mPerformBlur = AniwaysPrivateConfig.getInstance().getUseBlurEffect();
    }
}

