/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.blur;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.blur.BlurRenderer;
import com.aniways.blur.IBlurLayout;

public class BlurLinearLayout
extends LinearLayout
implements IBlurLayout {
    private static final String TAG = "AniwaysBlurLinearLayout";
    private BlurRenderer mBlurRenderer;
    private View mViewBehindLayout;

    public BlurLinearLayout(Context context) {
        super(context);
        this.init(null);
    }

    public BlurLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    @SuppressLint(value={"NewApi"})
    public BlurLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        try {
            this.mBlurRenderer = new BlurRenderer((View)this);
            if (attrs == null) {
                return;
            }
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.AniwaysBlurView);
            for (int i = 0; i < a.getIndexCount(); ++i) {
                int attr = a.getIndex(i);
                if (attr != R.styleable.AniwaysBlurView_aniways_blur_radius) continue;
                float radius = a.getFloat(attr, 1.0f);
                this.mBlurRenderer.setBlurRadius(radius);
            }
            a.recycle();
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Caught Exception in Ctor", e);
        }
    }

    protected void onAttachedToWindow() {
        if (this.isInEditMode()) {
            return;
        }
        try {
            super.onAttachedToWindow();
            this.mBlurRenderer.onAttachedToWindow();
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Caught Exception in onAttachToWindow", e);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.isInEditMode()) {
            return;
        }
        try {
            super.onDetachedFromWindow();
            this.mBlurRenderer.onDetachedFromWindow();
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Caught Exception in onDetachFromWindow", e);
        }
    }

    public void draw(Canvas canvas) {
        if (this.isInEditMode()) {
            super.draw(canvas);
            return;
        }
        try {
            if (!this.mBlurRenderer.isOffscreenCanvas(canvas)) {
                this.mBlurRenderer.drawToCanvas(canvas);
                super.dispatchDraw(canvas);
            }
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Caught Exception in draw", e);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.isInEditMode()) {
            return;
        }
        try {
            if (this.mBlurRenderer.isOffscreenCanvas(canvas)) {
                return;
            }
            super.dispatchDraw(canvas);
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Caught Exception in dispatchDraw", e);
        }
    }

    public void setBlurRadius(float radius) {
        try {
            this.mBlurRenderer.setBlurRadius(radius);
            this.invalidate();
        }
        catch (Throwable e) {
            Log.e(true, TAG, "Caught Exception in dispatchDraw", e);
        }
    }

    @Override
    public void setViewBehindPopup(View v) {
        this.mViewBehindLayout = v;
    }

    @Override
    public View getViewBehindPopup() {
        return this.mViewBehindLayout;
    }
}

