/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.billing;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;
import com.aniways.Aniways;
import com.aniways.Log;
import com.aniways.R;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.billing.IAniwaysPaymentCallback;
import com.aniways.billing.PaymentStatus;
import com.aniways.billing.utils.IabHelper;
import com.aniways.billing.utils.IabResult;
import com.aniways.billing.utils.Inventory;
import com.aniways.billing.utils.Purchase;
import com.aniways.billing.utils.SkuDetails;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStoreManager;
import java.util.ArrayList;

public class AniwaysCreditsStoreActivity
extends Activity {
    static final String TAG = "AniwaysInAppPurchaseActivity";
    static final int RC_REQUEST = 10001;
    public static final String CREDITS_PURCHASE_CATEGORY = "Store";
    public static boolean sIsRunning;
    private static String sLastPurchaseFlowSku;
    public static final String KEY_GENERATE_BY_TRYIMG_TO_UNLOCK_ICON = "com.aniways.GENERATED_BY_TRYING_TO_UNLOCK_ICON";
    public static final String KEY_ICON_TRYING_TO_UNLOCK = "com.aniways.ICON_TRYING_TO_UNLOCK";
    public static final String KEY_SOURCE_SCREEN = "com.aniways.SOURCE_SCREEN";
    public static final String KEY_ID = "com.aniways.ID";
    protected static final String NOT_AVAILABLE = "N/A";
    private Price mCreditsPrice100 = Price.NOT_AVAILABLE;
    private Price mCreditsPrice250 = Price.NOT_AVAILABLE;
    private Price mCreditsPrice500 = Price.NOT_AVAILABLE;
    private Price mCreditsPrice1000 = Price.NOT_AVAILABLE;
    private Price mCreditsPrice2000 = Price.NOT_AVAILABLE;
    private Price mCreditsPrice3000 = Price.NOT_AVAILABLE;
    private ProgressDialog mProgressDialog;
    IabHelper mHelper;
    private boolean mStartedFollowingIconUnlock;
    private String mIconTryingToUnlock;
    private String mSource;
    private String mStoreSessionId;
    IabHelper.QueryInventoryFinishedListener mGotInventoryListener = new IabHelper.QueryInventoryFinishedListener(){

        @Override
        public void onQueryInventoryFinished(final IabResult result, final Inventory inventory, boolean noNeedToComplainIfThereIsNoConnection) {
            try {
                Log.d(AniwaysCreditsStoreActivity.TAG, "Query inventory finished.");
                if (result.isFailure() && result.getResponse() != 6) {
                    AniwaysCreditsStoreActivity.this.complain("Failed to get prices from Google Play: " + result, "Failed to query inventory: " + result + " Code: " + result.getResponse() + " . Message: " + result.getMessage());
                    AniwaysCreditsStoreActivity.this.updateUi(false, false);
                } else if (result.isFailure() && result.getResponse() == 6) {
                    if (!noNeedToComplainIfThereIsNoConnection) {
                        AniwaysCreditsStoreActivity.this.complain("Failed to get prices from Google Play\n\nPlease make sure there is an internet connection and try again", null);
                    }
                    Log.w(false, AniwaysCreditsStoreActivity.TAG, "Failed to query inventory: " + result + " Code: " + result.getResponse() + " . Message: " + result.getMessage() + ". Trying again in 2 seconds");
                    Handler handler = new Handler();
                    handler.postDelayed((Runnable)new NonThrowingRunnable(AniwaysCreditsStoreActivity.TAG, "while starting to query inventory after previous failure", ""){

                        @Override
                        public void innerRun() {
                            try {
                                if (AniwaysCreditsStoreActivity.this.isFinishing() || AniwaysCreditsStoreActivity.this.mHelper == null) {
                                    return;
                                }
                                AniwaysCreditsStoreActivity.this.startQueryInventory(true);
                            }
                            catch (IllegalStateException ex) {
                                Log.w(false, AniwaysCreditsStoreActivity.TAG, "Cannot start the async operation since there is another one taking place, so start again in 2 secs");
                                this.onQueryInventoryFinished(result, inventory, true);
                            }
                        }
                    }, 2000L);
                    AniwaysCreditsStoreActivity.this.updateUi(false, false);
                } else {
                    AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
                    AniwaysCreditsStoreActivity.this.mCreditsPrice100 = this.getSkuPrice(inventory, config.creditsSku100);
                    AniwaysCreditsStoreActivity.this.mCreditsPrice250 = this.getSkuPrice(inventory, config.creditsSku250);
                    AniwaysCreditsStoreActivity.this.mCreditsPrice500 = this.getSkuPrice(inventory, config.creditsSku500);
                    AniwaysCreditsStoreActivity.this.mCreditsPrice1000 = this.getSkuPrice(inventory, config.creditsSku1000);
                    AniwaysCreditsStoreActivity.this.mCreditsPrice2000 = this.getSkuPrice(inventory, config.creditsSku2000);
                    AniwaysCreditsStoreActivity.this.mCreditsPrice3000 = this.getSkuPrice(inventory, config.creditsSku3000);
                    boolean startedConsumptionFlow = false;
                    startedConsumptionFlow |= this.startConsumptionFlowIfNecessary(inventory, config.creditsSku100, 100);
                    startedConsumptionFlow |= this.startConsumptionFlowIfNecessary(inventory, config.creditsSku250, 250);
                    startedConsumptionFlow |= this.startConsumptionFlowIfNecessary(inventory, config.creditsSku500, 500);
                    startedConsumptionFlow |= this.startConsumptionFlowIfNecessary(inventory, config.creditsSku1000, 1000);
                    startedConsumptionFlow |= this.startConsumptionFlowIfNecessary(inventory, config.creditsSku2000, 2000);
                    if (startedConsumptionFlow |= this.startConsumptionFlowIfNecessary(inventory, config.creditsSku3000, 3000)) {
                        Log.i(AniwaysCreditsStoreActivity.TAG, "Started consumption flow(s), so waiting for them to finish before allowing the UI to respond");
                        return;
                    }
                    AniwaysCreditsStoreActivity.this.updateUi(false, true);
                    Log.d(AniwaysCreditsStoreActivity.TAG, "Query inventory was successful.");
                }
                AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                Log.d(AniwaysCreditsStoreActivity.TAG, "Initial inventory query finished; enabling main UI.");
            }
            catch (Throwable ex) {
                Log.e(true, AniwaysCreditsStoreActivity.TAG, "Caught an Exception in onQueryInventoryFinished", ex);
                AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                AniwaysCreditsStoreActivity.this.updateUi(false, false);
            }
        }

        private Price getSkuPrice(Inventory inventory, String sku) {
            SkuDetails details = inventory.getSkuDetails(sku);
            if (details == null) {
                Log.e(true, AniwaysCreditsStoreActivity.TAG, "Received null for details of SKU: " + sku);
                return Price.NOT_AVAILABLE;
            }
            return new Price(details.getPrice(), details.getPriceMicros(), details.getPriceCurrency(), sku);
        }

        private boolean startConsumptionFlowIfNecessary(Inventory inventory, String sku, int amount) {
            Purchase creditsPurchase = inventory.getPurchase(sku);
            if (creditsPurchase != null && AniwaysCreditsStoreActivity.this.verifyDeveloperPayload(creditsPurchase)) {
                Log.d(AniwaysCreditsStoreActivity.TAG, "We have credits. Consuming them.");
                GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, AniwaysCreditsStoreActivity.CREDITS_PURCHASE_CATEGORY, "Start Consumption Flow From Inventory Query-" + AniwaysCreditsStoreActivity.this.getPaymentMethodName(), sku, amount);
                int creditsLeft = AniwaysStoreManager.getUserCreditsLeft();
                AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.startConsumptionFlowFromInventoryQuery, AniwaysCreditsStoreActivity.this.mStoreSessionId, creditsLeft, creditsLeft, amount, AniwaysCreditsStoreActivity.this.mStartedFollowingIconUnlock, AniwaysCreditsStoreActivity.this.mIconTryingToUnlock, AniwaysCreditsStoreActivity.this.mSource, sku, null, AniwaysCreditsStoreActivity.this.getPaymentMethodName());
                AniwaysCreditsStoreActivity.this.mHelper.consumeAsync(inventory.getPurchase(sku), AniwaysCreditsStoreActivity.this.mConsumeFinishedListener);
                return true;
            }
            return false;
        }
    };
    IabHelper.OnIabPurchaseFinishedListener mPurchaseFinishedListener = new IabHelper.OnIabPurchaseFinishedListener(){

        @Override
        public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
            try {
                String sku;
                Log.d(AniwaysCreditsStoreActivity.TAG, "Purchase finished: " + result + ", purchase: " + purchase);
                String string = sku = purchase == null ? sLastPurchaseFlowSku : purchase.getSku();
                if (result == null) {
                    AniwaysCreditsStoreActivity.this.complain("Failed to purchase credits.\n\nPlease try again later.", "Error purchasing credits. Result is null. SKU was: " + sku);
                    AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                    AniwaysCreditsStoreActivity.this.updateUi(false, false);
                    return;
                }
                if (result.isFailure()) {
                    int response = result.getResponse();
                    if (response == -1005) {
                        Log.w(false, AniwaysCreditsStoreActivity.TAG, "Credits purchase completed with Failure due to user cancelling. SKU was: " + sku + ". result code: " + result.getResponse() + " . Result message: " + result.getMessage());
                        Price price = AniwaysCreditsStoreActivity.this.getCreditsSkuToPrice(sku);
                        int amountOfCredits = AniwaysCreditsStoreActivity.this.getCreditsSkuToAmount(sku);
                        int creditsLeft = AniwaysStoreManager.getUserCreditsLeft();
                        AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.userCancelled, AniwaysCreditsStoreActivity.this.mStoreSessionId, creditsLeft, creditsLeft, amountOfCredits, AniwaysCreditsStoreActivity.this.mStartedFollowingIconUnlock, AniwaysCreditsStoreActivity.this.mIconTryingToUnlock, AniwaysCreditsStoreActivity.this.mSource, sku, price, AniwaysCreditsStoreActivity.this.getPaymentMethodName());
                    } else {
                        Log.e(true, AniwaysCreditsStoreActivity.TAG, "Credits purchase completed with Failure. SKU was: " + sku + ". result code: " + result.getResponse() + " . Result message: " + result.getMessage());
                        AniwaysCreditsStoreActivity.this.complain("Failed to purchase credits. Reason is: " + result.getMessage() + "\n\nPlease try again later.", null);
                    }
                    AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                    AniwaysCreditsStoreActivity.this.updateUi(false, false);
                    return;
                }
                if (!AniwaysCreditsStoreActivity.this.verifyDeveloperPayload(purchase)) {
                    AniwaysCreditsStoreActivity.this.complain("Error purchasing credits. Authenticity verification failed.\n\nPlease try again later.", "Credits purchase completed with Failure to verify developer payload. SKU was: " + sku + ". result code: " + result.getResponse() + " . Result message: " + result.getMessage() + ". Payload was: " + purchase == null ? "null" : purchase.getDeveloperPayload());
                    AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                    AniwaysCreditsStoreActivity.this.updateUi(false, false);
                    return;
                }
                if (purchase == null) {
                    AniwaysCreditsStoreActivity.this.complain("Error purchasing credits. Reason is: " + result.getMessage() + "\n\nPlease try again later.", "Purchase is null although credits purchase did not completed with Failure. SKU was: " + sku + ". result code: " + result.getResponse() + " . Result message: " + result.getMessage());
                    AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                    AniwaysCreditsStoreActivity.this.updateUi(false, false);
                    return;
                }
                Log.d(AniwaysCreditsStoreActivity.TAG, "Purchase successful.");
                AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
                if (sku.equalsIgnoreCase(config.creditsSku100) || sku.equalsIgnoreCase(config.creditsSku250) || sku.equalsIgnoreCase(config.creditsSku500) || sku.equalsIgnoreCase(config.creditsSku1000) || sku.equalsIgnoreCase(config.creditsSku2000) || sku.equalsIgnoreCase(config.creditsSku3000)) {
                    Log.d(AniwaysCreditsStoreActivity.TAG, "Purchase is credits. Starting credits consumption.");
                    Price price = AniwaysCreditsStoreActivity.this.getCreditsSkuToPrice(sku);
                    int amountOfCredits = AniwaysCreditsStoreActivity.this.getCreditsSkuToAmount(sku);
                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Billing, AniwaysCreditsStoreActivity.CREDITS_PURCHASE_CATEGORY, "Credits Purchased-" + AniwaysCreditsStoreActivity.this.getPaymentMethodName(), price.toString(), amountOfCredits);
                    int creditsLeft = AniwaysStoreManager.getUserCreditsLeft();
                    AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.creditsPurchased, AniwaysCreditsStoreActivity.this.mStoreSessionId, creditsLeft, creditsLeft, amountOfCredits, AniwaysCreditsStoreActivity.this.mStartedFollowingIconUnlock, AniwaysCreditsStoreActivity.this.mIconTryingToUnlock, AniwaysCreditsStoreActivity.this.mSource, sku, price, AniwaysCreditsStoreActivity.this.getPaymentMethodName());
                    GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, AniwaysCreditsStoreActivity.CREDITS_PURCHASE_CATEGORY, "Start Consumption Flow After Purchase-" + AniwaysCreditsStoreActivity.this.getPaymentMethodName(), sku, amountOfCredits);
                    AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.startConsumptionFlowAfterPurchase, AniwaysCreditsStoreActivity.this.mStoreSessionId, creditsLeft, creditsLeft, amountOfCredits, AniwaysCreditsStoreActivity.this.mStartedFollowingIconUnlock, AniwaysCreditsStoreActivity.this.mIconTryingToUnlock, AniwaysCreditsStoreActivity.this.mSource, sku, price, AniwaysCreditsStoreActivity.this.getPaymentMethodName());
                    AniwaysCreditsStoreActivity.this.mHelper.consumeAsync(purchase, AniwaysCreditsStoreActivity.this.mConsumeFinishedListener);
                } else {
                    Log.e(true, AniwaysCreditsStoreActivity.TAG, "Finished purchase of an unknown SKU: " + sku);
                    AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                    AniwaysCreditsStoreActivity.this.updateUi(false, false);
                }
            }
            catch (Throwable ex) {
                Log.e(true, AniwaysCreditsStoreActivity.TAG, "Caught an Exception in onIabPurchaseFinished", ex);
                AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                AniwaysCreditsStoreActivity.this.updateUi(false, false);
            }
        }
    };
    IabHelper.OnConsumeFinishedListener mConsumeFinishedListener = new IabHelper.OnConsumeFinishedListener(){

        @Override
        public void onConsumeFinished(Purchase purchase, IabResult result) {
            try {
                Log.d(AniwaysCreditsStoreActivity.TAG, "Consumption finished. Purchase: " + purchase + ", result: " + result);
                if (result.isSuccess()) {
                    AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
                    String sku = purchase.getSku();
                    if (sku.equalsIgnoreCase(config.creditsSku100)) {
                        this.onFinishConsumingCredits(100);
                    } else if (sku.equalsIgnoreCase(config.creditsSku250)) {
                        this.onFinishConsumingCredits(250);
                    } else if (sku.equalsIgnoreCase(config.creditsSku500)) {
                        this.onFinishConsumingCredits(500);
                    } else if (sku.equalsIgnoreCase(config.creditsSku1000)) {
                        this.onFinishConsumingCredits(1000);
                    } else if (sku.equalsIgnoreCase(config.creditsSku2000)) {
                        this.onFinishConsumingCredits(2000);
                    } else if (sku.equalsIgnoreCase(config.creditsSku3000)) {
                        this.onFinishConsumingCredits(3000);
                    } else {
                        Log.e(true, AniwaysCreditsStoreActivity.TAG, "Finished consumption of an unknown SKU: " + sku);
                    }
                } else {
                    AniwaysCreditsStoreActivity.this.complain("Could not complete the purchase successfully.\n\nPlease close and reopen the store to try again\n\n" + result, "Error while consuming SKU: " + purchase.getSku() + ". Result code: " + result.getResponse() + " . Result message: " + result.getMessage());
                }
                AniwaysCreditsStoreActivity.this.updateUi(true, false);
                AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                Log.d(AniwaysCreditsStoreActivity.TAG, "End consumption flow.");
            }
            catch (Throwable ex) {
                Log.e(true, AniwaysCreditsStoreActivity.TAG, "Caught an Exception in onConsumeFinished", ex);
                AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                AniwaysCreditsStoreActivity.this.updateUi(false, false);
            }
        }

        private void onFinishConsumingCredits(int amount) {
            int creditsLeft = AniwaysStoreManager.getUserCreditsLeft();
            AniwaysStoreManager.addUserCreditsAvailable(amount);
            GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, AniwaysCreditsStoreActivity.CREDITS_PURCHASE_CATEGORY, "Finish Consumption Flow-" + AniwaysCreditsStoreActivity.this.getPaymentMethodName(), "Credits before raise: " + Integer.toString(creditsLeft), amount);
            AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.finishedConsumptionFlow, AniwaysCreditsStoreActivity.this.mStoreSessionId, creditsLeft, creditsLeft + amount, amount, AniwaysCreditsStoreActivity.this.mStartedFollowingIconUnlock, AniwaysCreditsStoreActivity.this.mIconTryingToUnlock, AniwaysCreditsStoreActivity.this.mSource, null, null, AniwaysCreditsStoreActivity.this.getPaymentMethodName());
            Log.i(AniwaysCreditsStoreActivity.TAG, "Finished consumption flow of " + amount + " credits");
            try {
                MediaPlayer mp = MediaPlayer.create((Context)AniwaysCreditsStoreActivity.this, (int)R.raw.aniways_bought_credits_sound);
                if (mp == null) {
                    Log.e(true, AniwaysCreditsStoreActivity.TAG, "Failed to create media player for the bought credits sound");
                } else {
                    mp.start();
                    mp.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                        public void onCompletion(MediaPlayer mp) {
                            try {
                                mp.release();
                            }
                            catch (Throwable ex) {
                                Log.e(true, AniwaysCreditsStoreActivity.TAG, "Caught Exception while completing playing a sound");
                            }
                        }
                    });
                }
            }
            catch (Throwable ex) {
                Log.e(true, AniwaysCreditsStoreActivity.TAG, "Caught exception while creating media player for the bought credits sound");
            }
        }
    };

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        try {
            super.onCreate(savedInstanceState);
            if (!Utils.isAndroidVersionAtLeast(11)) {
                this.getWindow().clearFlags(32);
            }
            this.setContentView(R.layout.aniways_credits_store_activity);
            if (Utils.isAndroidVersionAtLeast(11)) {
                this.setFinishOnTouchOutside(false);
            }
            if (this.getIntent() == null || this.getIntent().getExtras() == null || !this.getIntent().getExtras().containsKey(KEY_GENERATE_BY_TRYIMG_TO_UNLOCK_ICON)) {
                Log.e(true, TAG, "AniwaysCreditsStoreActivity started without indication if it was a result of trying to unlock an icon or not..");
            }
            this.mStartedFollowingIconUnlock = this.getIntent().getExtras().getBoolean(KEY_GENERATE_BY_TRYIMG_TO_UNLOCK_ICON);
            this.mIconTryingToUnlock = this.getIntent().getExtras().getString(KEY_ICON_TRYING_TO_UNLOCK);
            this.mSource = this.getIntent().getExtras().getString(KEY_SOURCE_SCREEN);
            this.mStoreSessionId = this.getIntent().getExtras().getString(KEY_ID);
            Log.i(TAG, "Creating AniwaysCreditsStoreActivity " + (this.mStartedFollowingIconUnlock ? "" : "not ") + "following trying to unlock an icon");
            int creditsLeft = AniwaysStoreManager.getUserCreditsLeft();
            AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.openedStore, this.mStoreSessionId, creditsLeft, creditsLeft, 0, this.mStartedFollowingIconUnlock, this.mIconTryingToUnlock, this.mSource, null, null, this.getPaymentMethodName());
            ((ImageButton)this.findViewById(R.id.aniways_credits_store_close_store_button)).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AniwaysCreditsStoreActivity.this.onCloseButtonClicked(v);
                }
            });
            ((Button)this.findViewById(R.id.aniways_credits_store_100_coins_button)).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AniwaysCreditsStoreActivity.this.onBuyCreditsButtonClicked(v, AniwaysPrivateConfig.getInstance().creditsSku100, 100);
                }
            });
            ((Button)this.findViewById(R.id.aniways_credits_store_250_coins_button)).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AniwaysCreditsStoreActivity.this.onBuyCreditsButtonClicked(v, AniwaysPrivateConfig.getInstance().creditsSku250, 250);
                }
            });
            ((Button)this.findViewById(R.id.aniways_credits_store_500_coins_button)).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AniwaysCreditsStoreActivity.this.onBuyCreditsButtonClicked(v, AniwaysPrivateConfig.getInstance().creditsSku500, 500);
                }
            });
            ((Button)this.findViewById(R.id.aniways_credits_store_1000_coins_button)).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AniwaysCreditsStoreActivity.this.onBuyCreditsButtonClicked(v, AniwaysPrivateConfig.getInstance().creditsSku1000, 1000);
                }
            });
            ((Button)this.findViewById(R.id.aniways_credits_store_2000_coins_button)).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AniwaysCreditsStoreActivity.this.onBuyCreditsButtonClicked(v, AniwaysPrivateConfig.getInstance().creditsSku2000, 2000);
                }
            });
            ((Button)this.findViewById(R.id.aniways_credits_store_3000_coins_button)).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AniwaysCreditsStoreActivity.this.onBuyCreditsButtonClicked(v, AniwaysPrivateConfig.getInstance().creditsSku3000, 3000);
                }
            });
            this.updateUi(false, false);
            IAniwaysPaymentCallback paymentCallback = Aniways.getPaymentCallback();
            if (paymentCallback == null) {
                this.setWaitScreen(true);
                this.setupIabHelper();
            } else {
                AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
                this.mCreditsPrice100 = paymentCallback.getPriceForSKU(config.creditsSku100);
                this.mCreditsPrice250 = paymentCallback.getPriceForSKU(config.creditsSku250);
                this.mCreditsPrice500 = paymentCallback.getPriceForSKU(config.creditsSku500);
                this.mCreditsPrice1000 = paymentCallback.getPriceForSKU(config.creditsSku1000);
                this.mCreditsPrice2000 = paymentCallback.getPriceForSKU(config.creditsSku2000);
                this.mCreditsPrice3000 = paymentCallback.getPriceForSKU(config.creditsSku3000);
                this.updateUi(false, false);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in onCreate of Credit Store Activity", ex);
            this.setWaitScreen(false);
            this.updateUi(false, false);
        }
    }

    private String getPaymentMethodName() {
        IAniwaysPaymentCallback cb = Aniways.getPaymentCallback();
        if (cb != null) {
            return cb.GetPaymentMethodName();
        }
        return "Google IAP";
    }

    private void setupIabHelper() {
        String base64EncodedPublicKey = AniwaysPrivateConfig.getInstance().appPublicKeyForCreditsStore;
        Log.d(TAG, "Creating IAB helper.");
        this.mHelper = new IabHelper((Context)this, base64EncodedPublicKey);
        this.mHelper.enableDebugLogging(true);
        Log.d(TAG, "Starting setup.");
        this.mHelper.startSetup(new IabHelper.OnIabSetupFinishedListener(){

            @Override
            public void onIabSetupFinished(IabResult result) {
                try {
                    Log.d(AniwaysCreditsStoreActivity.TAG, "Setup finished.");
                    if (result == null) {
                        AniwaysCreditsStoreActivity.this.complain("Problem setting up the store.\n\nPlease try again later.", "Problem setting in app billing. Null result");
                        AniwaysCreditsStoreActivity.this.updateUi(false, false);
                        AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                        return;
                    }
                    if (!result.isSuccess()) {
                        if (result.getResponse() == 3) {
                            AniwaysCreditsStoreActivity.this.complain("In-App Purchase is not setup on your device. \n\nPlease install the latest Google Play version.", "Problem setting up in-app billing: " + result + " Code: " + result.getResponse() + " . Message: " + result.getMessage());
                        } else {
                            AniwaysCreditsStoreActivity.this.complain("Problem setting up In-App Purchase: " + result + "\n\nPlease try again later.", "Problem setting up in-app billing: " + result + " Code: " + result.getResponse() + " . Message: " + result.getMessage());
                        }
                        AniwaysCreditsStoreActivity.this.updateUi(false, false);
                        AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                        return;
                    }
                    Log.d(AniwaysCreditsStoreActivity.TAG, "Setup successful. Querying inventory.");
                    AniwaysCreditsStoreActivity.this.startQueryInventory(false);
                }
                catch (Throwable ex) {
                    Log.e(true, AniwaysCreditsStoreActivity.TAG, "Caught an Exception on IabSetupFinished", ex);
                    AniwaysCreditsStoreActivity.this.setWaitScreen(false);
                    AniwaysCreditsStoreActivity.this.updateUi(false, false);
                }
            }
        });
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            if (4 == event.getAction()) {
                return true;
            }
            return super.onTouchEvent(event);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in onTouchEvent", ex);
            return true;
        }
    }

    private void onBuyCreditsButtonClicked(View button, String sku, int amount) {
        block5: {
            try {
                Log.d(TAG, "Buy credits button clicked. SKU: " + sku + ". amount: " + amount);
                GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, CREDITS_PURCHASE_CATEGORY, "Start Purchase Credits-" + this.getPaymentMethodName(), sku, amount);
                int creditsLeft = AniwaysStoreManager.getUserCreditsLeft();
                AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.startPurchseCredits, this.mStoreSessionId, creditsLeft, creditsLeft, amount, this.mStartedFollowingIconUnlock, this.mIconTryingToUnlock, this.mSource, sku, null, this.getPaymentMethodName());
                this.setWaitScreen(true);
                Log.d(TAG, "Launching purchase flow for credits.");
                String payload = "";
                try {
                    sLastPurchaseFlowSku = sku;
                    IAniwaysPaymentCallback paymentCallback = Aniways.getPaymentCallback();
                    if (paymentCallback != null) {
                        this.payWithCallback(sku, paymentCallback);
                        break block5;
                    }
                    this.mHelper.launchPurchaseFlow(this, sku, 10001, this.mPurchaseFinishedListener, payload);
                }
                catch (IllegalStateException ex) {
                    this.complain("In App Purchase is not setup on your device. \n\nPlease install the latest Google Play version.", null);
                    this.setWaitScreen(false);
                    this.updateUi(false, false);
                }
            }
            catch (Throwable ex) {
                Log.e(true, TAG, "Caught an Exception in onBuyCreditsButton. SKU: " + sku + " . Amount: " + amount, ex);
                this.setWaitScreen(false);
                this.updateUi(false, false);
            }
        }
    }

    private void payWithCallback(String sku, IAniwaysPaymentCallback paymentCallback) {
        PaymentStatus paymentStatus = paymentCallback.pay(sku);
        switch (paymentStatus) {
            case Error: {
                Log.e(true, TAG, "Error paying for: " + sku);
                this.mConsumeFinishedListener.onConsumeFinished(new Purchase(sku), new IabResult(6, "Error."));
                break;
            }
            case OK: {
                AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
                if (!sku.equalsIgnoreCase(config.creditsSku100) && !sku.equalsIgnoreCase(config.creditsSku250) && !sku.equalsIgnoreCase(config.creditsSku500) && !sku.equalsIgnoreCase(config.creditsSku1000) && !sku.equalsIgnoreCase(config.creditsSku2000) && !sku.equalsIgnoreCase(config.creditsSku3000)) break;
                Log.d(TAG, "Purchase is credits. Starting credits consumption.");
                Price price = this.getCreditsSkuToPrice(sku);
                int amountOfCredits = this.getCreditsSkuToAmount(sku);
                int creditsLeft = AniwaysStoreManager.getUserCreditsLeft();
                GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Billing, CREDITS_PURCHASE_CATEGORY, "Credits Purchased-" + this.getPaymentMethodName(), price.toString(), amountOfCredits);
                AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.creditsPurchased, this.mStoreSessionId, creditsLeft, creditsLeft, amountOfCredits, this.mStartedFollowingIconUnlock, this.mIconTryingToUnlock, this.mSource, sku, price, this.getPaymentMethodName());
                GoogleAnalyticsReporter.reportEvent(AniwaysConfiguration.Verbosity.Info, CREDITS_PURCHASE_CATEGORY, "Start Consumption Flow After Purchase-" + this.getPaymentMethodName(), sku, amountOfCredits);
                AnalyticsReporter.reportStoreEvent(AnalyticsReporter.StoreEventAction.startConsumptionFlowAfterPurchase, this.mStoreSessionId, creditsLeft, creditsLeft, amountOfCredits, this.mStartedFollowingIconUnlock, this.mIconTryingToUnlock, this.mSource, sku, price, this.getPaymentMethodName());
                this.mConsumeFinishedListener.onConsumeFinished(new Purchase(sku), new IabResult(0, "Inventory refresh successful."));
                break;
            }
            case Rejected: {
                Log.e(true, TAG, "Payment rejected for: " + sku);
                this.mConsumeFinishedListener.onConsumeFinished(new Purchase(sku), new IabResult(3, "Rejected."));
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        try {
            Log.d(TAG, "onActivityResult(" + requestCode + "," + resultCode + "," + data);
            if (!this.mHelper.handleActivityResult(requestCode, resultCode, data)) {
                super.onActivityResult(requestCode, resultCode, data);
            } else {
                Log.d(TAG, "onActivityResult handled by IABUtil.");
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in onActivityResult", ex);
            this.setWaitScreen(false);
            this.updateUi(false, false);
        }
    }

    private boolean verifyDeveloperPayload(Purchase p) {
        return true;
    }

    protected void onStop() {
        super.onStop();
        sIsRunning = false;
    }

    protected void onResume() {
        super.onResume();
        sIsRunning = true;
    }

    private void onCloseButtonClicked(View arg0) {
        try {
            this.finish();
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception while closing Credit Store Activity", ex);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        try {
            Log.d(TAG, "Destroying helper.");
            if (this.mHelper != null) {
                this.mHelper.dispose();
            }
            this.mHelper = null;
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught an Exception in onDestroy", ex);
        }
    }

    private void updateUi(boolean animateCredits, boolean animatePrices) {
        if (animateCredits) {
            AnimationSet s = new AnimationSet(false);
            AlphaAnimation creditsBalancefadeInAnimation = new AlphaAnimation(0.0f, 1.0f);
            creditsBalancefadeInAnimation.setDuration(600L);
            creditsBalancefadeInAnimation.setStartOffset(0L);
            creditsBalancefadeInAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
            AlphaAnimation creditsBalanceFadeOutAnimation = new AlphaAnimation(1.0f, 0.0f);
            creditsBalanceFadeOutAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    try {
                        ((TextView)AniwaysCreditsStoreActivity.this.findViewById(R.id.aniways_credits_store_credits_balance)).setText((CharSequence)Integer.toString(AniwaysStoreManager.getUserCreditsLeft()));
                    }
                    catch (Throwable ex) {
                        Log.e(true, AniwaysCreditsStoreActivity.TAG, "Caught an Exception in onAnimationEnd", ex);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            creditsBalanceFadeOutAnimation.setDuration(600L);
            creditsBalanceFadeOutAnimation.setStartOffset(0L);
            creditsBalanceFadeOutAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
            s.addAnimation((Animation)creditsBalanceFadeOutAnimation);
            s.addAnimation((Animation)creditsBalancefadeInAnimation);
            s.setRepeatCount(0);
            ((TextView)this.findViewById(R.id.aniways_credits_store_credits_balance)).startAnimation((Animation)s);
        } else {
            ((TextView)this.findViewById(R.id.aniways_credits_store_credits_balance)).setText((CharSequence)Integer.toString(AniwaysStoreManager.getUserCreditsLeft()));
        }
        ((Button)this.findViewById(R.id.aniways_credits_store_100_coins_button)).setText((CharSequence)this.mCreditsPrice100.readablePrice);
        ((Button)this.findViewById(R.id.aniways_credits_store_250_coins_button)).setText((CharSequence)this.mCreditsPrice250.readablePrice);
        ((Button)this.findViewById(R.id.aniways_credits_store_500_coins_button)).setText((CharSequence)this.mCreditsPrice500.readablePrice);
        ((Button)this.findViewById(R.id.aniways_credits_store_1000_coins_button)).setText((CharSequence)this.mCreditsPrice1000.readablePrice);
        ((Button)this.findViewById(R.id.aniways_credits_store_2000_coins_button)).setText((CharSequence)this.mCreditsPrice2000.readablePrice);
        ((Button)this.findViewById(R.id.aniways_credits_store_3000_coins_button)).setText((CharSequence)this.mCreditsPrice3000.readablePrice);
        if (animatePrices) {
            AlphaAnimation fadeInAnimation = new AlphaAnimation(AniwaysPrivateConfig.getInstance().lockedIconAlpha, 1.0f);
            fadeInAnimation.setDuration(1200L);
            fadeInAnimation.setStartOffset(0L);
            fadeInAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
            ((Button)this.findViewById(R.id.aniways_credits_store_100_coins_button)).startAnimation((Animation)fadeInAnimation);
            ((Button)this.findViewById(R.id.aniways_credits_store_250_coins_button)).startAnimation((Animation)fadeInAnimation);
            ((Button)this.findViewById(R.id.aniways_credits_store_500_coins_button)).startAnimation((Animation)fadeInAnimation);
            ((Button)this.findViewById(R.id.aniways_credits_store_1000_coins_button)).startAnimation((Animation)fadeInAnimation);
            ((Button)this.findViewById(R.id.aniways_credits_store_2000_coins_button)).startAnimation((Animation)fadeInAnimation);
            ((Button)this.findViewById(R.id.aniways_credits_store_3000_coins_button)).startAnimation((Animation)fadeInAnimation);
        }
    }

    void setWaitScreen(boolean set) {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog((Context)this);
            this.mProgressDialog.setTitle((CharSequence)"Connecting to Google Play");
            this.mProgressDialog.setMessage((CharSequence)"Please wait..");
            this.mProgressDialog.setCanceledOnTouchOutside(false);
            this.mProgressDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface arg0, int keyCode, KeyEvent event) {
                    try {
                        if (keyCode == 4) {
                            AniwaysCreditsStoreActivity.this.finish();
                            AniwaysCreditsStoreActivity.this.mProgressDialog.dismiss();
                        }
                    }
                    catch (Throwable ex) {
                        Log.e(true, AniwaysCreditsStoreActivity.TAG, "Caught an Exception in onBack of the wait dialog", ex);
                    }
                    return true;
                }
            });
        }
        if (set) {
            Log.i(TAG, "Setting wait screen");
            this.mProgressDialog.show();
        } else if (this.mProgressDialog.isShowing()) {
            Log.i(TAG, "Removing wait screen");
            this.mProgressDialog.dismiss();
        }
    }

    void complain(String message, String messageForLogs) {
        if (messageForLogs != null) {
            Log.e(true, TAG, messageForLogs);
        }
        this.alert(message);
    }

    void alert(String message) {
        AlertDialog.Builder bld = new AlertDialog.Builder((Context)this);
        bld.setTitle((CharSequence)"Error");
        bld.setMessage((CharSequence)message);
        bld.setNeutralButton((CharSequence)"OK", null);
        Log.d(TAG, "Showing alert dialog: " + message);
        bld.create().show();
    }

    private int getCreditsSkuToAmount(String sku) {
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        if (sku.equalsIgnoreCase(config.creditsSku100)) {
            return 100;
        }
        if (sku.equalsIgnoreCase(config.creditsSku250)) {
            return 250;
        }
        if (sku.equalsIgnoreCase(config.creditsSku500)) {
            return 500;
        }
        if (sku.equalsIgnoreCase(config.creditsSku1000)) {
            return 1000;
        }
        if (sku.equalsIgnoreCase(config.creditsSku2000)) {
            return 2000;
        }
        if (sku.equalsIgnoreCase(config.creditsSku3000)) {
            return 3000;
        }
        Log.e(true, TAG, "Unknown SKU: " + sku);
        return 0;
    }

    private Price getCreditsSkuToPrice(String sku) {
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        if (sku.equalsIgnoreCase(config.creditsSku100)) {
            return this.mCreditsPrice100;
        }
        if (sku.equalsIgnoreCase(config.creditsSku250)) {
            return this.mCreditsPrice250;
        }
        if (sku.equalsIgnoreCase(config.creditsSku500)) {
            return this.mCreditsPrice500;
        }
        if (sku.equalsIgnoreCase(config.creditsSku1000)) {
            return this.mCreditsPrice1000;
        }
        if (sku.equalsIgnoreCase(config.creditsSku2000)) {
            return this.mCreditsPrice2000;
        }
        if (sku.equalsIgnoreCase(config.creditsSku3000)) {
            return this.mCreditsPrice3000;
        }
        Log.e(true, TAG, "Unknown SKU: " + sku);
        return Price.NOT_AVAILABLE;
    }

    private void startQueryInventory(boolean noNeedToComplainIfThereIsNoConnection) {
        ArrayList<String> allSkus = new ArrayList<String>();
        AniwaysPrivateConfig config = AniwaysPrivateConfig.getInstance();
        allSkus.add(config.creditsSku100);
        allSkus.add(config.creditsSku250);
        allSkus.add(config.creditsSku500);
        allSkus.add(config.creditsSku1000);
        allSkus.add(config.creditsSku2000);
        allSkus.add(config.creditsSku3000);
        Log.i(TAG, "Starting to query inventory");
        this.mHelper.queryInventoryAsync(true, allSkus, this.mGotInventoryListener, noNeedToComplainIfThereIsNoConnection);
    }

    static {
        sLastPurchaseFlowSku = null;
    }

    public static class Price {
        protected static final Price NOT_AVAILABLE = new Price("N/A", "N/A", "N/A", "N/A");
        public String readablePrice;
        public String priceAmount;
        public String priceCurrency;
        public String sku;

        public Price(String readablePrice, String priceMicros, String priceCurrency, String sku) {
            this.sku = sku;
            this.setReadablePrice(readablePrice);
            this.setPriceAmount(priceMicros);
            this.setPriceCurrency(priceCurrency);
        }

        private void setReadablePrice(String price) {
            if (TextUtils.isEmpty((CharSequence)price)) {
                Log.e(true, AniwaysCreditsStoreActivity.TAG, "Readable price empty for SKU: " + this.sku);
                price = AniwaysCreditsStoreActivity.NOT_AVAILABLE;
            }
            this.readablePrice = price;
        }

        private void setPriceAmount(String amount) {
            if (TextUtils.isEmpty((CharSequence)amount)) {
                Log.e(true, AniwaysCreditsStoreActivity.TAG, "Price amount empty for SKU: " + this.sku);
                this.priceAmount = AniwaysCreditsStoreActivity.NOT_AVAILABLE;
                return;
            }
            try {
                if (AniwaysCreditsStoreActivity.NOT_AVAILABLE.equals(amount)) {
                    this.priceAmount = amount;
                    return;
                }
                double micros = Double.parseDouble(amount);
                double regularUnits = micros / 1000000.0;
                this.priceAmount = Double.toString(regularUnits);
            }
            catch (Exception ex) {
                Log.e(true, AniwaysCreditsStoreActivity.TAG, "Error converting price micros: " + amount + ". for SKU: " + this.sku, ex);
                this.priceAmount = AniwaysCreditsStoreActivity.NOT_AVAILABLE;
            }
        }

        public void setPriceCurrency(String currency) {
            if (TextUtils.isEmpty((CharSequence)currency)) {
                Log.e(true, AniwaysCreditsStoreActivity.TAG, "Price currency empty for SKU: " + this.sku);
                currency = AniwaysCreditsStoreActivity.NOT_AVAILABLE;
            }
            this.priceCurrency = currency;
        }

        public String toString() {
            return "Readable price: " + this.readablePrice + ". PriceAmount: " + this.priceAmount + " PriceCurrency: " + this.priceCurrency;
        }
    }
}

