/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Process;
import com.aniways.Log;

public class LooperThreadWithHandler
extends HandlerThread {
    private static final String TAG = "AniwaysLooperThreadWithHandler";
    private Handler handler;

    public LooperThreadWithHandler(String name) {
        super(name);
    }

    public LooperThreadWithHandler(String name, int priority) {
        super(name, priority);
    }

    public void run() {
        try {
            super.run();
        }
        catch (Throwable ex) {
            Log.eToGaOnly(true, TAG, "Uncaught error in thread: " + this.getName(), ex);
            Process.killProcess((int)Process.myPid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLooperPrepared() {
        LooperThreadWithHandler looperThreadWithHandler = this;
        synchronized (looperThreadWithHandler) {
            this.handler = new Handler();
            try {
                ((Object)((Object)this)).notifyAll();
            }
            catch (Throwable ex) {
                Log.eToGaOnly(true, TAG, "Caught Exception while notifying all", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReady() {
        while (this.handler == null) {
            LooperThreadWithHandler looperThreadWithHandler = this;
            synchronized (looperThreadWithHandler) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    Log.eToGaOnly(true, TAG, "Failed while waiting for singleton thread ready. ", e);
                }
            }
        }
    }

    public Handler handler() {
        this.waitForReady();
        return this.handler;
    }
}

