/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.info;

import android.content.Context;
import android.telephony.TelephonyManager;
import com.aniways.Log;
import com.aniways.analytics.info.Info;
import com.aniways.analytics.models.EasyJSONObject;
import org.json.JSONObject;

public class Locale
implements Info<JSONObject> {
    private static final String TAG = "AniwaysAnalyticsContextLocale";

    @Override
    public String getKey() {
        return "locale";
    }

    @Override
    public JSONObject get(Context context) {
        EasyJSONObject locale = new EasyJSONObject();
        try {
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            locale.put("carrier", manager.getNetworkOperatorName());
            locale.put("country", java.util.Locale.getDefault().getDisplayCountry());
            locale.put("countryIso3", java.util.Locale.getDefault().getISO3Country());
            locale.put("language", java.util.Locale.getDefault().getLanguage());
            locale.put("languageIso3", java.util.Locale.getDefault().getISO3Language());
            locale.put("displayLanguage", java.util.Locale.getDefault().getDisplayLanguage());
            try {
                String networkCountry;
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                String simCountry = tm.getSimCountryIso();
                if (simCountry != null) {
                    String simCountryString = simCountry.toLowerCase(java.util.Locale.US);
                    locale.put("simCountry", simCountryString);
                }
                if (tm.getPhoneType() != 2 && (networkCountry = tm.getNetworkCountryIso()) != null) {
                    String networkCountryString = networkCountry.toLowerCase(java.util.Locale.US);
                    locale.put("networkCountry", networkCountryString);
                }
            }
            catch (Exception ex) {
                Log.eToGaOnly(true, TAG, "Caught Exception in Locale sim or nw country code", ex);
            }
            String localeCode = context.getResources().getConfiguration().locale.getCountry();
            locale.put("countryCode", localeCode);
        }
        catch (Exception ex) {
            Log.eToGaOnly(true, TAG, "Caught Exception in Locale info", ex);
        }
        return locale;
    }
}

