/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.info;

import android.content.Context;
import com.aniways.Log;
import com.aniways.analytics.info.Config;
import com.aniways.analytics.info.Location;
import com.aniways.analytics.info.User;
import com.aniways.analytics.models.EasyJSONObject;
import org.json.JSONObject;

public class EventMetaDataCreator {
    private static final String TAG = "EventMetaDataCreator";
    private static EventMetaDataCreator instance;

    private EventMetaDataCreator() {
    }

    public static EventMetaDataCreator getInstance() {
        if (instance == null) {
            instance = new EventMetaDataCreator();
        }
        return instance;
    }

    public JSONObject create(Context context) {
        EasyJSONObject metaData = new EasyJSONObject();
        EasyJSONObject location = new Location().get(context);
        EasyJSONObject user = (EasyJSONObject)new User().get(context);
        EasyJSONObject config = (EasyJSONObject)Config.get(context);
        if (location == null) {
            location = new EasyJSONObject();
            Log.eToGaOnly(true, TAG, "unable to fetch location info when creating event meta data", null);
        }
        if (user == null) {
            user = new EasyJSONObject();
            Log.eToGaOnly(true, TAG, "unable to fetch user info when creating event meta data", null);
        }
        metaData.put("geo_location", new EasyJSONObject(location.get("latitude"), location.get("longitude")));
        metaData.put("country", location.optString("country"));
        metaData.put("city", location.optString("city"));
        metaData.put("configuration_name", config.optString("code"));
        metaData.put("aniways_suggestions", config.optBoolean("contextualSuggestionsEnabled"));
        metaData.put("days_installed", user.optLong("TimeFromInstallDays"));
        return metaData;
    }
}

