/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.info;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.info.Info;
import com.aniways.analytics.models.EasyJSONObject;
import com.aniways.analytics.utils.AndroidUtils;
import com.aniways.data.Installation;
import org.json.JSONObject;

public class Device
implements Info<JSONObject> {
    private static final String TAG = "AniwaysAnalyticsContextDevice";

    @Override
    public String getKey() {
        return "device";
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public JSONObject get(Context context) {
        EasyJSONObject device = new EasyJSONObject();
        try {
            TelephonyManager telephone;
            String androidId;
            device.put("os", "Android");
            device.put("sdk", Build.VERSION.SDK_INT);
            device.put("release", Build.VERSION.RELEASE);
            device.put("brand", Build.BRAND);
            device.put("manufacturer", Build.MANUFACTURER);
            device.put("model", Build.MODEL);
            device.put("installationId", Installation.id(context));
            device.put("maxMemory", Runtime.getRuntime().maxMemory() / 0x100000L);
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            if (am != null) {
                device.put("memClass", am.getMemoryClass());
                if (Utils.isAndroidVersionAtLeast(11)) {
                    device.put("memClassLargeHeap", am.getLargeMemoryClass());
                }
            }
            if (!TextUtils.isEmpty((CharSequence)(androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"))) && !androidId.equals("9774d56d682e549c")) {
                androidId = "unknown";
            }
            device.put("androidId", androidId);
            String serialNumber = "unknown";
            try {
                serialNumber = (String)Build.class.getField("SERIAL").get(null);
                if (TextUtils.isEmpty((CharSequence)serialNumber)) {
                    serialNumber = "unknown";
                }
            }
            catch (Exception e) {
                serialNumber = "unknown";
            }
            device.put("serialNumber", serialNumber);
            String telephonyId = "unknown";
            if (AndroidUtils.permissionGranted(context, "android.permission.READ_PHONE_STATE") && context.getPackageManager().hasSystemFeature("android.hardware.telephony") && TextUtils.isEmpty((CharSequence)(telephonyId = (telephone = (TelephonyManager)context.getSystemService("phone")).getDeviceId()))) {
                telephonyId = "unknown";
            }
            device.put("telephonyId", serialNumber);
        }
        catch (Exception ex) {
            Log.eToGaOnly(true, TAG, "Caught Exception in Device info", ex);
        }
        return device;
    }
}

