/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics.flush;

import com.aniways.Log;
import com.aniways.analytics.AniwaysAnalyticsReporter;
import com.aniways.analytics.NonThrowingRunnable;
import com.aniways.analytics.db.IPayloadDatabaseLayer;
import com.aniways.analytics.db.PayloadDatabaseThread;
import com.aniways.analytics.models.BasePayload;
import com.aniways.analytics.models.Batch;
import com.aniways.analytics.request.BasicRequester;
import com.aniways.analytics.stats.AnalyticsStatistics;
import com.aniways.analytics.utils.LooperThreadWithHandler;
import com.aniways.data.AniwaysPrivateConfig;
import java.util.List;

public class FlushThread
extends LooperThreadWithHandler {
    private static final String TAG = "AniwaysAnalyticsFlushThread";
    private BasicRequester requester;
    private PayloadDatabaseThread databaseLayer;
    private BatchFactory batchFactory;

    public FlushThread(BasicRequester requester, BatchFactory batchFactory, PayloadDatabaseThread databaseLayer) {
        super(TAG);
        this.requester = requester;
        this.batchFactory = batchFactory;
        this.databaseLayer = databaseLayer;
    }

    public void flushAniwaysEvents(final FlushCallback callback) {
        this.databaseLayer.nextPayload(new IPayloadDatabaseLayer.PayloadCallback(){

            @Override
            public void onPayload(final long minId, final long maxId, List<BasePayload> payloads) {
                if (payloads.size() > 0) {
                    final long start = System.currentTimeMillis();
                    Batch batch = FlushThread.this.batchFactory.create(payloads);
                    FlushThread.this.performRequest(batch.toString(), false, new RequestCallback(){

                        @Override
                        public void onRequestCompleted(boolean success) {
                            if (!success) {
                                if (callback != null) {
                                    callback.onFlushCompleted(false);
                                }
                            } else {
                                long duration = System.currentTimeMillis() - start;
                                AniwaysAnalyticsReporter.getStatistics().updateRequestTime(duration);
                                FlushThread.this.databaseLayer.removePayloads(minId, maxId, new IPayloadDatabaseLayer.RemoveCallback(){

                                    @Override
                                    public void onRemoved(int removed) {
                                        AnalyticsStatistics statistics = AniwaysAnalyticsReporter.getStatistics();
                                        if (removed == -1) {
                                            for (int i = 0; i < removed; ++i) {
                                                statistics.updateFailed(1.0);
                                            }
                                            Log.eToGaOnly(true, FlushThread.TAG, "Failed to remove payload from the database. MinId-MaxId" + minId + "-" + maxId, null);
                                            if (callback != null) {
                                                callback.onFlushCompleted(false);
                                            }
                                        } else if (removed == 0) {
                                            for (int i = 0; i < removed; ++i) {
                                                statistics.updateFailed(1.0);
                                            }
                                            Log.eToGaOnly(true, FlushThread.TAG, "Didn't end up removing anything from the database. MinId-MaxId" + minId + "-" + maxId, null);
                                            if (callback != null) {
                                                callback.onFlushCompleted(false);
                                            }
                                        } else {
                                            for (int i = 0; i < removed; ++i) {
                                                statistics.updateSuccessful(1.0);
                                            }
                                            if (callback != null) {
                                                callback.onFlushCompleted(true);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    });
                } else if (callback != null) {
                    callback.onFlushCompleted(true);
                }
            }
        });
    }

    public void flushErrorEvents(final FlushCallback callback) {
        this.databaseLayer.nextErrorPayload(new IPayloadDatabaseLayer.ErrorPayloadCallback(){

            @Override
            public void onPayload(final long minId, final long maxId, String payload) {
                if (payload != null) {
                    final long start = System.currentTimeMillis();
                    FlushThread.this.performRequest(payload, true, new RequestCallback(){

                        @Override
                        public void onRequestCompleted(boolean success) {
                            if (!success) {
                                if (callback != null) {
                                    callback.onFlushCompleted(false);
                                }
                            } else {
                                long duration = System.currentTimeMillis() - start;
                                AniwaysAnalyticsReporter.getStatistics().updateRequestTime(duration);
                                FlushThread.this.databaseLayer.removeErrorPayloads(minId, maxId, new IPayloadDatabaseLayer.RemoveCallback(){

                                    @Override
                                    public void onRemoved(int removed) {
                                        AnalyticsStatistics statistics = AniwaysAnalyticsReporter.getStatistics();
                                        if (removed == -1) {
                                            for (int i = 0; i < removed; ++i) {
                                                statistics.updateFailed(1.0);
                                            }
                                            Log.eToGaOnly(true, FlushThread.TAG, "Failed to remove payload from the error database. MinId-MaxId" + minId + "-" + maxId, null);
                                            if (callback != null) {
                                                callback.onFlushCompleted(false);
                                            }
                                        } else if (removed == 0) {
                                            for (int i = 0; i < removed; ++i) {
                                                statistics.updateFailed(1.0);
                                            }
                                            Log.eToGaOnly(true, FlushThread.TAG, "Didn't end up removing anything from the error database. MinId-MaxId" + minId + "-" + maxId, null);
                                            if (callback != null) {
                                                callback.onFlushCompleted(false);
                                            }
                                        } else {
                                            for (int i = 0; i < removed; ++i) {
                                                statistics.updateSuccessful(1.0);
                                            }
                                            FlushThread.this.flushErrorEvents(callback);
                                        }
                                    }
                                });
                            }
                        }
                    });
                } else if (callback != null) {
                    callback.onFlushCompleted(true);
                }
            }
        });
    }

    private void performRequest(final String content, final boolean isErrorHandler, final RequestCallback callback) {
        this.handler().post((Runnable)new NonThrowingRunnable(TAG, "report result of request", "ErrorHandler: " + isErrorHandler, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void innerRun() {
                boolean success = false;
                AniwaysPrivateConfig.AnalyticsCloud analyticsCloud = null;
                try {
                    analyticsCloud = AniwaysPrivateConfig.getInstance().analyticsCloud;
                    success = isErrorHandler ? FlushThread.this.requester.sendToErrorHandler(content) : FlushThread.this.requester.sendAnalytics(content, analyticsCloud);
                    if (success) {
                        Log.v(FlushThread.TAG, "Successfully sent a batch to the server. ErrorHandler: " + isErrorHandler + ". Analytics cloud: " + (Object)((Object)analyticsCloud));
                    } else {
                        Log.w(false, FlushThread.TAG, "Could not send batch to the server. ErrorHandler: " + isErrorHandler + ". Analytics cloud: " + (Object)((Object)analyticsCloud));
                    }
                }
                catch (Throwable ex) {
                    Log.eToGaOnly(true, FlushThread.TAG, "Caught Exception in perform request on the flush thread. ErrorHandler: " + isErrorHandler + ". Analytics cloud:" + (Object)((Object)analyticsCloud), ex);
                }
                finally {
                    try {
                        if (callback != null) {
                            callback.onRequestCompleted(success);
                        }
                    }
                    catch (Throwable ex) {
                        Log.eToGaOnly(true, FlushThread.TAG, "Caught Exception while calling the request completed callback following call. ErrorHandler: " + isErrorHandler, ex);
                    }
                }
            }
        });
    }

    public static interface RequestCallback {
        public void onRequestCompleted(boolean var1);
    }

    public static interface FlushCallback {
        public void onFlushCompleted(boolean var1);
    }

    public static interface BatchFactory {
        public Batch create(List<BasePayload> var1);
    }
}

