/*
 * Decompiled with CFR 0.152.
 */
package com.aniways.analytics;

import com.aniways.Log;

public abstract class NonThrowingRunnable
implements Runnable {
    private String mTag;
    private String mMethodName;
    private String mErrorMessageSuffix;
    private boolean mReportToGaOnly;
    private OnCatchCallback mOnCatch;

    public NonThrowingRunnable(String tag, String methodName, String errorMessageSuffix) {
        this(tag, methodName, errorMessageSuffix, false);
    }

    public NonThrowingRunnable(String tag, String methodName, String errorMessageSuffix, boolean reportToGaOnly) {
        this.mTag = tag;
        this.mMethodName = methodName;
        this.mErrorMessageSuffix = errorMessageSuffix;
        this.mReportToGaOnly = reportToGaOnly;
    }

    public NonThrowingRunnable(String tag, String methodName, String errorMessageSuffix, OnCatchCallback onCatch) {
        this(tag, methodName, errorMessageSuffix, false);
        this.mOnCatch = onCatch;
    }

    @Override
    public void run() {
        try {
            this.innerRun();
        }
        catch (Throwable ex) {
            if (this.mOnCatch != null) {
                try {
                    this.mOnCatch.onCatch(ex);
                }
                catch (Throwable e) {
                    Log.eToGaOnly(true, this.mTag, "Caught Exception in onCatch", e);
                }
            }
            String message = "Caught Exception in runnable of " + this.mMethodName + (this.mErrorMessageSuffix == null ? "" : ". ") + this.mErrorMessageSuffix;
            if (this.mReportToGaOnly) {
                Log.eToGaOnly(true, this.mTag, message, ex);
            }
            Log.e(true, this.mTag, message, ex);
        }
    }

    public abstract void innerRun();

    public static interface OnCatchCallback {
        public void onCatch(Throwable var1);
    }
}

