/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import com.aniways.Log;
import com.aniways.VersionComparisonResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;

@SuppressLint(value={"InlinedApi"})
public class Utils {
    private static final String TAG = "AniwaysUtils";

    public static boolean isAndroidVersionAtLeast(int verCode) {
        if (Build.VERSION.RELEASE.startsWith("1.0")) {
            return verCode == 1;
        }
        if (Build.VERSION.RELEASE.startsWith("1.1")) {
            return verCode <= 2;
        }
        if (Build.VERSION.RELEASE.startsWith("1.5")) {
            return verCode <= 3;
        }
        return Build.VERSION.SDK_INT >= verCode;
    }

    public static int setMaxMinStartEnd(int[] startEnd) {
        if (startEnd.length != 2) {
            throw new IllegalArgumentException("startEnd doesn't contain 2 ints");
        }
        int start = startEnd[0];
        int end = startEnd[1];
        int min = Math.max(0, Math.min(start, end));
        int max = Math.max(0, Math.max(start, end));
        start = min;
        end = max;
        startEnd[0] = start;
        startEnd[1] = end;
        int length = end - start;
        return length;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean isStringEmpty(String string) {
        if (Utils.isAndroidVersionAtLeast(9)) {
            return string.isEmpty();
        }
        return string.length() == 0;
    }

    public static boolean isSpanAdjacentToRange(Spannable spannable, int start, int end, Object span) {
        int spanStart = spannable.getSpanStart(span);
        int spanEnd = spannable.getSpanEnd(span);
        boolean spanIsAdjacent = spanEnd == start || spanStart == end;
        return spanIsAdjacent;
    }

    public static byte[] serializeObject(Object o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(o);
            out.close();
            byte[] buf = bos.toByteArray();
            return buf;
        }
        catch (IOException ioe) {
            Log.e(true, TAG, "error", ioe);
            return null;
        }
    }

    public static Object deserializeObject(byte[] b) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(b));
            Object object = in.readObject();
            in.close();
            return object;
        }
        catch (ClassNotFoundException cnfe) {
            Log.e(true, TAG, "class not found error", cnfe);
            return null;
        }
        catch (IOException ioe) {
            Log.e(true, TAG, "io error", ioe);
            return null;
        }
    }

    public static int getScreenOrientation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display getOrient = windowManager.getDefaultDisplay();
        int orientation = 0;
        orientation = getOrient.getWidth() == getOrient.getHeight() ? 3 : (getOrient.getWidth() < getOrient.getHeight() ? 1 : 2);
        return orientation;
    }

    public static String isInternetAvailable(Context context) {
        if (0 != context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE")) {
            Log.e(false, TAG, "ACCESS_NETWORK_STATE permission not granted");
            return null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        if (activeNetworkInfo != null && activeNetworkInfo.isConnected()) {
            Log.i(TAG, "There is NW connectivity. Interface is: " + activeNetworkInfo.getTypeName());
            int responseCode = 0;
            try {
                HttpURLConnection urlc = (HttpURLConnection)new URL("http://www.google.com").openConnection();
                urlc.setRequestProperty("User-Agent", "Test");
                urlc.setRequestProperty("Connection", "close");
                urlc.setConnectTimeout(1500);
                urlc.connect();
                responseCode = urlc.getResponseCode();
                if (responseCode == 200) {
                    return activeNetworkInfo.getTypeName();
                }
                Log.i(TAG, "Error checking internet connection. Response from Google is: " + responseCode);
            }
            catch (IOException e) {
                Log.i(TAG, "Error checking internet connection: " + e.getMessage());
            }
        } else {
            Log.i(TAG, "There is no Network connectivity");
        }
        return null;
    }

    public static VersionComparisonResult compareVersionStrings(String verA, String verB) {
        if (verA == null || verB == null || Utils.isStringEmpty(verA) || Utils.isStringEmpty(verB)) {
            IllegalArgumentException e = new IllegalArgumentException("One on the version strings is null or empty. verA: " + verA + " VerB: " + verB);
            Log.e(true, TAG, "Throwing Exception in compareVersionStrings: ", e);
            throw e;
        }
        try {
            double a = Double.parseDouble(verA);
            double b = Double.parseDouble(verB);
            if (a > b) {
                return new VersionComparisonResult(1);
            }
            if (a < b) {
                return new VersionComparisonResult(-1);
            }
            return new VersionComparisonResult(0);
        }
        catch (NumberFormatException ex) {
            IllegalArgumentException newE = new IllegalArgumentException("One on the version strings cannot be converted to double. A: " + verA + ". B:" + verB);
            Log.e(true, TAG, "Throwing Exception in compareVersionStrings: ", newE);
            throw newE;
        }
    }

    public static int getSharedPreferencesFlags() {
        int flags = 0;
        if (Utils.isAndroidVersionAtLeast(11)) {
            flags |= 4;
        }
        return flags;
    }

    public static boolean isGetter(Method method) {
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    public static boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    public static String[] concatStringArrays(String[] A, String[] B) {
        int aLen = A.length;
        int bLen = B.length;
        String[] C = new String[aLen + bLen];
        System.arraycopy(A, 0, C, 0, aLen);
        System.arraycopy(B, 0, C, aLen, bLen);
        return C;
    }

    public static <T> T[] concatenateArrays(T[] A, T[] B) {
        int aLen = A.length;
        int bLen = B.length;
        Object[] C = (Object[])Array.newInstance(A.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(A, 0, C, 0, aLen);
        System.arraycopy(B, 0, C, aLen, bLen);
        return C;
    }

    public static boolean isVersionLegal(String expectedVersion) {
        if (TextUtils.isEmpty((CharSequence)expectedVersion)) {
            return false;
        }
        try {
            Double.parseDouble(expectedVersion);
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }
}

