/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import com.aniways.AssetType;
import com.aniways.IconData;
import com.aniways.data.Phrase;

public interface IAniwaysImageSpan {
    public Phrase getPhrase();

    public IconData getIcon();

    public ImageSpanMetadata getImageSpanMetadata();

    public boolean isLoadingImageSpan();

    public static enum AssetProvider {
        Unknown,
        Aniways,
        Giphy;

    }

    public static enum IconSelectionOrigin {
        Unknown,
        ContextualManual,
        ContextualAuto,
        Autoreplace,
        AniwaysKeyboard,
        AniwaysKeyboardGenious,
        OtherKeyboard,
        Paste;


        public static boolean wasSelectedThroughAniways(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == AniwaysKeyboard || selectionOrigin == ContextualAuto || selectionOrigin == ContextualManual || selectionOrigin == Autoreplace || selectionOrigin == AniwaysKeyboardGenious;
        }

        public static boolean isFromContextualReplacement(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == ContextualAuto || selectionOrigin == ContextualManual || selectionOrigin == Autoreplace;
        }

        public static boolean isManual(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == ContextualManual;
        }

        public static boolean isFromUnknownKeyboard(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == OtherKeyboard;
        }

        public static boolean isFromAniwaysKeyboard(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == AniwaysKeyboard;
        }

        public static boolean isFromPaste(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == Paste;
        }

        public static boolean isFromUnknownSource(IconSelectionOrigin selectionOrigin) {
            return selectionOrigin == Unknown;
        }
    }

    public static class ImageSpanMetadata {
        public static final ImageSpanMetadata Empty = new ImageSpanMetadata(IconSelectionOrigin.Unknown, AssetType.Unknown, AssetProvider.Unknown);
        public IconSelectionOrigin iconSelectionOrigin;
        public AssetType assetType;
        public AssetProvider assetProvider;

        public ImageSpanMetadata(IconSelectionOrigin iconSelectionOrigin, AssetType assetType, AssetProvider assetProvider) {
            this.iconSelectionOrigin = iconSelectionOrigin;
            this.assetType = assetType;
            this.assetProvider = assetProvider;
        }

        public ImageSpanMetadata(IconData icon, IconSelectionOrigin iconSelectionOrigin) {
            this.iconSelectionOrigin = iconSelectionOrigin;
            this.assetType = icon.assetType;
            this.assetProvider = icon.assetProvider;
        }

        public boolean isManual() {
            return IconSelectionOrigin.isManual(this.iconSelectionOrigin);
        }

        public boolean isFromUnknownKeyboard() {
            return IconSelectionOrigin.isFromUnknownKeyboard(this.iconSelectionOrigin);
        }

        public boolean isFromAniwaysKeyboard() {
            return IconSelectionOrigin.isFromAniwaysKeyboard(this.iconSelectionOrigin);
        }

        public boolean isFromPaste() {
            return IconSelectionOrigin.isFromPaste(this.iconSelectionOrigin);
        }

        public boolean isFromUnknownSource() {
            return IconSelectionOrigin.isFromUnknownSource(this.iconSelectionOrigin);
        }

        public boolean wasSelectedThroughAniways() {
            return IconSelectionOrigin.wasSelectedThroughAniways(this.iconSelectionOrigin);
        }

        public boolean isFromContextualReplacement() {
            return IconSelectionOrigin.isFromContextualReplacement(this.iconSelectionOrigin);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isIconSentSeperatelyFromText() {
            if (this.assetType == AssetType.Emoji) return false;
            if (this.assetType == AssetType.Emoticons) return false;
            return true;
        }
    }
}

