/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.os.Bundle;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.Reporter;
import com.aniways.analytics.info.InfoManager;
import com.aniways.bugsnag.MetaData;
import com.aniways.bugsnag.android.Bugsnag;
import com.aniways.data.AniwaysPrivateConfig;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class BugsnagReporter
implements Reporter {
    protected static final String TAG = "AniwaysBygsnagReporter";
    private Context mContext;

    public BugsnagReporter(Context context) {
        Bugsnag.register(context, AniwaysPrivateConfig.getInstance().errorHandlingAPIKey);
        Bugsnag.setAppVersion("2.3.05");
        this.registerApplicationLifecycle(context);
        this.mContext = context.getApplicationContext();
    }

    @SuppressLint(value={"NewApi"})
    private void registerApplicationLifecycle(Context applicationContext) {
        if (!Utils.isAndroidVersionAtLeast(14)) {
            return;
        }
        Application.ActivityLifecycleCallbacks lifeCycle = new Application.ActivityLifecycleCallbacks(){

            public void onActivityStopped(Activity activity) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityResumed(Activity activity) {
                Bugsnag.onActivityResume(activity);
            }

            public void onActivityPaused(Activity activity) {
                Bugsnag.onActivityPause(activity);
            }

            public void onActivityDestroyed(Activity activity) {
                Bugsnag.onActivityDestroy(activity);
            }

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                Bugsnag.onActivityCreate(activity);
            }
        };
        if (applicationContext instanceof Application) {
            ((Application)applicationContext).registerActivityLifecycleCallbacks(lifeCycle);
        } else if (applicationContext instanceof Activity) {
            ((Activity)applicationContext).getApplication().registerActivityLifecycleCallbacks(lifeCycle);
        } else if (applicationContext instanceof Service) {
            ((Service)applicationContext).getApplication().registerActivityLifecycleCallbacks(lifeCycle);
        }
    }

    @Override
    public void notify(String tag, String message, Throwable error) {
        MetaData additionalData = new MetaData();
        additionalData.addToTab("TAG", tag);
        additionalData.addToTab("Message", message);
        JSONObject info = new InfoManager().build(this.mContext);
        this.spreadInfo(info, additionalData);
        Bugsnag.notify(error, additionalData);
    }

    private void spreadInfo(JSONObject info, MetaData additionalData) {
        JSONObject flattenJSON = BugsnagReporter.flatten(info, null, "");
        Iterator keys = flattenJSON.keys();
        while (keys.hasNext()) {
            String next = (String)keys.next();
            try {
                additionalData.addToTab(next, flattenJSON.get(next));
            }
            catch (JSONException e) {
                Log.eToGaOnly(true, TAG, "Error adding info json", e);
            }
        }
    }

    private static JSONObject flatten(JSONObject object, JSONObject flattened, String parentKey) {
        if (flattened == null) {
            flattened = new JSONObject();
        }
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String flattenKey = parentKey.equals("") ? key : parentKey + "-" + key;
            try {
                if (object.get(key) instanceof JSONObject) {
                    BugsnagReporter.flatten(object.getJSONObject(key), flattened, flattenKey);
                    continue;
                }
                flattened.put(flattenKey, object.get(key));
            }
            catch (JSONException e) {
                Log.eToGaOnly(true, TAG, "Error flattening info json", e);
            }
        }
        return flattened;
    }
}

