/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.Window;
import android.widget.RelativeLayout;
import com.aniways.Log;
import com.aniways.ui.AniwaysUiUtil;

public class AniwaysTutorialView
extends RelativeLayout {
    private static final String TAG = "AniwaysTutorialView";
    private Context mContext;
    private RectF mHighlightEllipse;
    private Paint mPaint;
    private PorterDuffXfermode mPorterDuffXfermode;
    private GestureDetector mGestureDetector;
    private onTutorialWindowSingleTapConfirmed mOnTutorialWindowSingleTapConfirmedCallback;
    private Rect mScreenRect;
    private RectF mDropDownRect;

    public AniwaysTutorialView(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public AniwaysTutorialView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    public AniwaysTutorialView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.init();
    }

    public boolean isNimbuzz() {
        Context context = this.getContext();
        PackageManager pm = context.getPackageManager();
        String packageName = "";
        if (pm != null) {
            packageName = context.getPackageName();
        }
        Log.d(TAG, "Package name: " + packageName);
        return packageName.startsWith("com.nimbuzz");
    }

    protected void onDraw(Canvas canvas) {
        try {
            super.onDraw(canvas);
            this.mPaint.setAntiAlias(true);
            canvas.drawARGB(0, 0, 0, 0);
            this.mPaint.setColor(0);
            this.mPaint.setXfermode((Xfermode)this.mPorterDuffXfermode);
            canvas.drawOval(this.mHighlightEllipse, this.mPaint);
            if (this.isNimbuzz()) {
                Log.d(TAG, "Highlighting dropdown menu");
                int highlightWidth = AniwaysUiUtil.convertDipsToPixels(40);
                int verticalMargin = AniwaysUiUtil.convertDipsToPixels(5);
                int horizontalMargin = AniwaysUiUtil.convertDipsToPixels(3);
                int highlightHeight = highlightWidth;
                Window window = ((Activity)this.getContext()).getWindow();
                window.getDecorView().getWindowVisibleDisplayFrame(this.mScreenRect);
                int screenWidth = this.mScreenRect.right;
                this.mDropDownRect.left = screenWidth - highlightWidth - horizontalMargin;
                this.mDropDownRect.top = verticalMargin;
                this.mDropDownRect.right = screenWidth - horizontalMargin;
                this.mDropDownRect.bottom = verticalMargin + highlightHeight;
                canvas.drawOval(this.mDropDownRect, this.mPaint);
            }
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onDraw", ex);
        }
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPorterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
        this.mHighlightEllipse = new RectF();
        this.mGestureDetector = new GestureDetector(this.mContext, (GestureDetector.OnGestureListener)new TutorialViewGestureListener());
        this.mScreenRect = new Rect();
        this.mDropDownRect = new RectF();
    }

    public void setHighlightEllipseValues(Rect rect) {
        this.mHighlightEllipse.set(rect);
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            return this.mGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
        }
        catch (Throwable ex) {
            Log.e(true, TAG, "Caught Exception in onTouchEvent", ex);
            return true;
        }
    }

    public void setOnTutorialWindowSingleTapConfirmed(onTutorialWindowSingleTapConfirmed listener) {
        this.mOnTutorialWindowSingleTapConfirmedCallback = listener;
    }

    class TutorialViewGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        TutorialViewGestureListener() {
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            try {
                if (null != AniwaysTutorialView.this.mOnTutorialWindowSingleTapConfirmedCallback) {
                    boolean inHighlightedArea = AniwaysTutorialView.this.mHighlightEllipse.contains(e.getX(), e.getY());
                    return AniwaysTutorialView.this.mOnTutorialWindowSingleTapConfirmedCallback.tutorialWindowSingleTapConfirmed(inHighlightedArea);
                }
                return false;
            }
            catch (Throwable ex) {
                Log.e(true, AniwaysTutorialView.TAG, "Caught Exception in onSingleTapConfirmed", ex);
                return true;
            }
        }
    }

    public static interface onTutorialWindowSingleTapConfirmed {
        public boolean tutorialWindowSingleTapConfirmed(boolean var1);
    }
}

