/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Editable;
import android.text.style.ReplacementSpan;
import android.view.LayoutInflater;
import android.widget.EditText;
import android.widget.TextView;
import com.aniways.AniwaysNonSelectedWordMarkerSpan;
import com.aniways.IAniwaysWordMarkerSpan;
import com.aniways.R;

class AniwaysSelectedWordMarkerSpan
extends ReplacementSpan
implements IAniwaysWordMarkerSpan {
    private final TextView textView;
    private final int paddingWidth;
    private int textHeight;
    private AniwaysNonSelectedWordMarkerSpan nonSelectedSpan;

    public AniwaysSelectedWordMarkerSpan(Context context, String text, float textSizeRawPixels, AniwaysNonSelectedWordMarkerSpan nonSelectedSpan) {
        this.nonSelectedSpan = nonSelectedSpan;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.textView = (TextView)inflater.inflate(R.layout.aniways_contextual_suggestions_marker, null);
        this.textView.setText((CharSequence)text);
        this.textView.setTextSize(0, textSizeRawPixels);
        this.textView.setSelected(true);
        this.paddingWidth = (int)context.getResources().getDimension(R.dimen.aniways_suggestion_box_padding);
    }

    private void prepView() {
        this.textView.measure(0, 0);
        this.textView.layout(0, 0, this.textView.getMeasuredWidth(), this.textView.getMeasuredHeight());
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        this.prepView();
        Paint.FontMetricsInt metrics = paint.getFontMetricsInt();
        y += metrics.descent - this.textHeight;
        if (start > 0) {
            x -= (float)this.paddingWidth;
        }
        canvas.save();
        canvas.translate(x, (float)y);
        this.textView.draw(canvas);
        canvas.restore();
    }

    public int getSize(Paint paint, CharSequence charSequence, int start, int end, Paint.FontMetricsInt fm) {
        this.prepView();
        this.textHeight = this.textView.getHeight();
        int retWidth = this.textView.getWidth();
        if (start > 0) {
            retWidth -= 2 * this.paddingWidth;
            this.textView.setPadding(this.paddingWidth, 0, this.paddingWidth, 0);
        } else {
            retWidth -= this.paddingWidth;
            this.textView.setPadding(0, 0, this.paddingWidth, 0);
        }
        return retWidth;
    }

    @Override
    public void setSelected(EditText textView, boolean selected) {
        if (selected) {
            return;
        }
        Editable text = textView.getText();
        int end = text.getSpanEnd((Object)this);
        int start = text.getSpanStart((Object)this);
        if (start == -1 || end == -1) {
            return;
        }
        text.removeSpan((Object)this);
        text.setSpan((Object)this.nonSelectedSpan, start, end, 33);
    }
}

