/*
 * Decompiled with CFR 0.152.
 */
package com.aniways;

import android.graphics.Point;
import android.graphics.Rect;
import android.support.v4.view.GestureDetectorCompat;
import android.text.Editable;
import android.text.Layout;
import android.text.Spannable;
import android.text.TextWatcher;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.aniways.Aniways;
import com.aniways.AniwaysDynamicImageSpansContainer;
import com.aniways.AniwaysEditText;
import com.aniways.AniwaysEditTextTextWatcher;
import com.aniways.AniwaysGestureListener;
import com.aniways.AniwaysIconConverter;
import com.aniways.AniwaysMessageListViewItemWrapperLayout;
import com.aniways.AniwaysSuggestionSpan;
import com.aniways.AniwaysTextView;
import com.aniways.IAniwaysDynamicImageSpan;
import com.aniways.IAniwaysGestureResponder;
import com.aniways.IAniwaysIconInfoSpan;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IAniwaysTextContainer;
import com.aniways.IAniwaysTextEditor;
import com.aniways.IAniwaysTextWatcher;
import com.aniways.IAniwaysWordMarkerSpan;
import com.aniways.IIconInfoDisplayer;
import com.aniways.ISuggestionDisplayer;
import com.aniways.Log;
import com.aniways.Utils;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.data.AniwaysBackendSyncChecker;
import com.aniways.data.AniwaysPhraseReplacementData;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.AniwaysStatics;
import com.aniways.data.JsonParser;
import com.aniways.quick.action.QuickAction;
import java.util.HashSet;

class AniwaysEditTextAndTextViewCommonPart
implements IAniwaysTextContainer {
    private TextView mTextView;
    private boolean mIsEditText;
    private static final String TAG = "AniwaysEditTextAndTextViewCommonPart";
    private GestureDetectorCompat mGestureDetector;
    private AniwaysGestureListener mGestureListener;
    private IAniwaysTextWatcher mTextWatcher;
    private QuickAction mQuickAction;
    private boolean mTextWatcherEnabled = false;
    boolean mDoNotShowIcons = false;
    private AniwaysDynamicImageSpansContainer mDynamicImageSpansContainer = null;
    private HashSet<AniwaysMessageListViewItemWrapperLayout.OnSetTextListener> mSetTextListeners = new HashSet();

    public AniwaysEditTextAndTextViewCommonPart(TextView textView) {
        AniwaysStatics.makeSureAniwaysIsInitialized(false);
        this.mTextView = textView;
        this.mIsEditText = this.mTextView instanceof AniwaysEditText;
        if (this.mIsEditText) {
            AnalyticsReporter.reportNewSession();
        }
        this.mGestureListener = new AniwaysGestureListener((IAniwaysGestureResponder)this.mTextView);
        this.mGestureDetector = new GestureDetectorCompat(this.mTextView.getContext(), (GestureDetector.OnGestureListener)this.mGestureListener);
        this.mDynamicImageSpansContainer = new AniwaysDynamicImageSpansContainer(this);
        if (this.mIsEditText) {
            this.mTextWatcher = new AniwaysEditTextTextWatcher((AniwaysEditText)this.mTextView);
            this.addTheAniwaysTextWatcher();
        }
    }

    boolean onTextContextMenuItem(int id2) {
        int ID_CUT = 0x1020020;
        int ID_COPY = 0x1020021;
        int ID_PASTE = 0x1020022;
        int min = 0;
        int max = this.mTextView.getText().length();
        int selStart = 0;
        int selEnd = 0;
        if (this.mTextView.isFocused()) {
            selStart = this.mTextView.getSelectionStart();
            selEnd = this.mTextView.getSelectionEnd();
            min = Math.max(0, Math.min(selStart, selEnd));
            max = Math.max(0, Math.max(selStart, selEnd));
        }
        switch (id2) {
            case 0x1020022: {
                this.removeTheAniwaysTextWatcher();
                boolean result = ((IAniwaysTextEditor)this.mTextView).callSuperOnTextContextMenuItem(id2);
                JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
                boolean useSmallIcons = false;
                if (this.mTextView instanceof AniwaysTextView) {
                    useSmallIcons = ((AniwaysTextView)this.mTextView).mUseSmallIcons;
                }
                if (this.mTextView instanceof ISuggestionDisplayer) {
                    AniwaysIconConverter.decodeMessage(this.mTextView.getContext(), (Editable)this.mTextView.getText(), (ISuggestionDisplayer)this.mTextView, null, this, parser, AniwaysPrivateConfig.IconEncodingMethod.Invisible, useSmallIcons, true, false, false);
                } else if (this.isIconInfoDisplayer()) {
                    AniwaysIconConverter.decodeMessage(this.mTextView.getContext(), (Editable)this.mTextView.getText(), null, (IIconInfoDisplayer)this.mTextView, this, parser, AniwaysPrivateConfig.IconEncodingMethod.Invisible, useSmallIcons, true, false, false);
                } else {
                    Log.e(true, TAG, "mTextView is not a suggestion diplayer and not icon info displayer");
                }
                this.addTheAniwaysTextWatcher();
                return result;
            }
            case 0x1020020: {
                return this.copyOrCut(id2, min, max, selStart, selEnd, false);
            }
            case 0x1020021: {
                return this.copyOrCut(id2, min, max, selStart, selEnd, true);
            }
        }
        return ((IAniwaysTextEditor)this.mTextView).callSuperOnTextContextMenuItem(id2);
    }

    boolean dispatchKeyEventPreIme(KeyEvent event) {
        Log.d(TAG, "In dispatch key event pre ime. Key is: " + event.getAction());
        if (event.getKeyCode() == 4) {
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                this.mTextView.getKeyDispatcherState().startTracking(event, (Object)this);
                return true;
            }
            if (event.getAction() == 1) {
                this.mTextView.getKeyDispatcherState().handleUpEvent(event);
                if (event.isTracking() && !event.isCanceled()) {
                    return this.onBack();
                }
                return this.onBack();
            }
        }
        return ((IAniwaysTextEditor)this.mTextView).callSuperDispatchKeyEventPreIme(event);
    }

    boolean onTouchEvent(MotionEvent event) {
        Log.d(TAG, "in on touch event: " + event.getAction());
        this.mGestureDetector.onTouchEvent(event);
        int pos = this.getPositionOfTouchEventInText(event);
        if (pos != -1) {
            AniwaysSuggestionSpan[] suggestions = (AniwaysSuggestionSpan[])((Editable)this.mTextView.getText()).getSpans(pos, pos, AniwaysSuggestionSpan.class);
            IAniwaysIconInfoSpan[] infos = (IAniwaysIconInfoSpan[])((Editable)this.mTextView.getText()).getSpans(pos, pos, IAniwaysIconInfoSpan.class);
            if (suggestions.length != 0 || infos.length != 0) {
                if (this.mGestureListener.ismRecordEvents()) {
                    this.mGestureListener.recordEvent(event);
                }
                if (event.getAction() == 0 && !this.mGestureListener.ismRecordEvents()) {
                    this.mGestureListener.setRecordEvents(true);
                    this.mGestureListener.recordEvent(event);
                }
                if (event.getAction() == 1) {
                    // empty if block
                }
                return true;
            }
            this.mGestureListener.setRecordEvents(false);
        }
        return ((IAniwaysTextEditor)this.mTextView).callSuperOnTouchEvent(event);
    }

    int getPositionOfTouchEventInText(MotionEvent event) {
        Log.d(TAG, "event x: " + event.getX() + " y: " + event.getY());
        if (Utils.isAndroidVersionAtLeast(14)) {
            // empty if block
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= this.mTextView.getTotalPaddingLeft();
        y -= this.mTextView.getTotalPaddingTop();
        x += this.mTextView.getScrollX();
        y += this.mTextView.getScrollY();
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            Log.w(false, TAG, "Reeived null layout for TextView or EditText, so not calculating position of touch event in text and returning -1");
            return -1;
        }
        int line = layout2.getLineForVertical(y);
        int off = layout2.getOffsetForHorizontal(line, (float)x);
        int paragraphDirection = layout2.getParagraphDirection(line);
        int maxLineRight = (int)layout2.getLineWidth(line);
        if (paragraphDirection != 1 && paragraphDirection == -1) {
            Rect bounds = new Rect();
            layout2.getLineBounds(line, bounds);
            x = bounds.width() - x;
            Log.d(TAG, "line bounds: " + bounds.toString());
            Log.d(TAG, "new X: " + x);
        }
        if (x <= maxLineRight + 25) {
            return off;
        }
        return -1;
    }

    @Override
    public Spannable getText() {
        return (Spannable)this.mTextView.getText();
    }

    @Override
    public Point getPointOfPositionInText(int position, boolean fromTop) {
        int leftPadding = this.mTextView.getTotalPaddingLeft();
        int topPadding = this.mTextView.getTotalPaddingTop();
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            Log.w(false, TAG, "Reeived null layout for TextView or EditText, so not calculating point in text and retuirning null");
            return null;
        }
        int line = layout2.getLineForOffset(position);
        int baseline = layout2.getLineBaseline(line);
        float x = layout2.getPrimaryHorizontal(position);
        x += (float)leftPadding;
        x -= (float)this.mTextView.getScrollX();
        float y = baseline;
        y += (float)topPadding;
        y -= (float)this.mTextView.getScrollY();
        if (fromTop) {
            int ascent = layout2.getLineAscent(line);
            y += (float)ascent;
        } else {
            int viewHeight = this.mTextView.getHeight();
            y = (float)viewHeight - y - (float)this.mTextView.getTotalPaddingBottom();
        }
        Point point = new Point(Math.round(x), Math.round(y));
        return point;
    }

    @Override
    public View getView() {
        return this.mTextView;
    }

    private boolean copyOrCut(int id2, int min, int max, int selStart, int selEnd, boolean copy) {
        IAniwaysWordMarkerSpan[] spansToRemove;
        Log.v(TAG, "copy or cut. id: " + id2 + " min: " + min + " max: " + max + " selStart: " + selStart + " selEnd: " + selEnd + " copy: " + copy);
        Editable unchanged = Editable.Factory.getInstance().newEditable(this.mTextView.getText());
        this.removeTheAniwaysTextWatcher();
        Editable dirty = (Editable)this.mTextView.getText();
        IAniwaysImageSpan[] imageSpansStart = (IAniwaysImageSpan[])dirty.getSpans(min, min, IAniwaysImageSpan.class);
        IAniwaysImageSpan[] imageSpansEnd = (IAniwaysImageSpan[])dirty.getSpans(max, max, IAniwaysImageSpan.class);
        if (imageSpansStart != null && imageSpansStart.length > 0) {
            for (IAniwaysImageSpan span : imageSpansStart) {
                int s;
                int e = dirty.getSpanEnd((Object)span);
                if (e == min || (s = dirty.getSpanStart((Object)span)) >= min) continue;
                min = s;
            }
        }
        if (imageSpansEnd != null && imageSpansEnd.length > 0) {
            for (IAniwaysImageSpan span : imageSpansEnd) {
                int e;
                int s = dirty.getSpanStart((Object)span);
                if (s == max || (e = dirty.getSpanEnd((Object)span)) <= max) continue;
                max = e;
            }
        }
        if ((spansToRemove = (IAniwaysWordMarkerSpan[])dirty.getSpans(min, max, IAniwaysWordMarkerSpan.class)) != null && spansToRemove.length > 0) {
            for (IAniwaysWordMarkerSpan spanToRemove : spansToRemove) {
                dirty.removeSpan((Object)spanToRemove);
            }
        }
        String replacement = AniwaysIconConverter.encodeMessage((Spannable)dirty.subSequence(min, max), this.mTextView.getContext(), false, AniwaysPrivateConfig.IconEncodingMethod.Invisible, true);
        CharSequence suffix = dirty.subSequence(max, dirty.length());
        dirty.delete(min, dirty.length());
        dirty.append((CharSequence)replacement);
        dirty.append(suffix);
        this.setSelection(min, min + replacement.length());
        if (!copy) {
            this.addTheAniwaysTextWatcher();
        }
        boolean result = ((IAniwaysTextEditor)this.mTextView).callSuperOnTextContextMenuItem(id2);
        if (copy) {
            ((IAniwaysTextEditor)this.mTextView).setText((CharSequence)unchanged, true);
            this.setSelection(selStart, selEnd);
            this.addTheAniwaysTextWatcher();
        }
        return result;
    }

    private boolean onBack() {
        return Aniways.closeAllOpenedPopups();
    }

    void onSetText(CharSequence newText, Spannable oldText) {
        if (this.mSetTextListeners != null) {
            for (AniwaysMessageListViewItemWrapperLayout.OnSetTextListener listener : this.mSetTextListeners) {
                listener.onSetText(newText);
            }
        }
        if (newText.length() == 0 || newText == oldText) {
            return;
        }
        Editable text = (Editable)this.mTextView.getText();
        this.removeTheAniwaysTextWatcher();
        JsonParser parser = AniwaysPhraseReplacementData.getDataParser();
        boolean useSmallIcons = false;
        if (this.mTextView instanceof AniwaysTextView) {
            useSmallIcons = ((AniwaysTextView)this.mTextView).mUseSmallIcons;
        }
        if (this.mTextView instanceof ISuggestionDisplayer) {
            Log.d(TAG, "Decode start");
            Log.d(TAG, "Decode end");
        } else if (this.isIconInfoDisplayer()) {
            Log.d(TAG, "Start decode");
            AniwaysIconConverter.decodeMessage(this.mTextView.getContext(), text, null, (IIconInfoDisplayer)this.mTextView, this, parser, null, useSmallIcons, false, false, false);
            Log.d(TAG, "End decode");
            if (AniwaysPrivateConfig.getInstance().autoReplaceKeyPhrasesInTextView) {
                Log.d(TAG, "Start autoreplace phrases");
                AniwaysIconConverter.autoreplaceTextWithIcons((Spannable)text, this.mTextView.getContext(), (IIconInfoDisplayer)this.mTextView, useSmallIcons);
                Log.d(TAG, "End autoreplace phrases");
            }
        } else {
            Log.e(true, TAG, "mTextView is not a suggestion diplayer and not icon info displayer");
        }
        if (this.mDoNotShowIcons) {
            AniwaysIconConverter.removeAllAniwaysSpans((Spannable)text);
        }
        this.mDynamicImageSpansContainer.onSetText((Spannable)text, oldText);
        this.addTheAniwaysTextWatcher();
        AniwaysBackendSyncChecker.requestSyncWithServerIfNecessary();
    }

    public void setSelection(int start, int stop) {
        if (stop > this.mTextView.getText().length()) {
            stop = this.mTextView.getText().length();
        }
        ((IAniwaysTextEditor)this.mTextView).callSuperSetSelection(start, stop);
    }

    public void setSelection(int index) {
        if (index > this.mTextView.getText().length()) {
            index = this.mTextView.getText().length();
        }
        ((IAniwaysTextEditor)this.mTextView).callSuperSetSelection(index);
    }

    public void selectAll() {
        ((IAniwaysTextEditor)this.mTextView).callSuperSelectAll();
    }

    public void extendSelection(int index) {
        if (this.mTextView.getSelectionEnd() + index > this.mTextView.getText().length()) {
            index = this.mTextView.getText().length() - this.mTextView.getSelectionEnd();
        }
        ((IAniwaysTextEditor)this.mTextView).callSuperExtendSelection(index);
    }

    Point[] calculateCenterPointsForAboveAndBelowLine(int start, int end) {
        return AniwaysEditTextAndTextViewCommonPart.calculateCenterPointsForAboveAndBelowLine(start, end, this);
    }

    static Point[] calculateCenterPointsForAboveAndBelowLine(int start, int end, IAniwaysTextContainer textContainer) {
        Point startPointForAboveLine = textContainer.getPointOfPositionInText(start, true);
        Point endPointForAboveLine = textContainer.getPointOfPositionInText(end, true);
        if (startPointForAboveLine == null || endPointForAboveLine == null) {
            return null;
        }
        Point centerPointForAboveLine = new Point((startPointForAboveLine.x + endPointForAboveLine.x) / 2, startPointForAboveLine.y);
        Point startPointForBelowLine = textContainer.getPointOfPositionInText(start, false);
        Point endPointForBelowLine = textContainer.getPointOfPositionInText(end, false);
        if (startPointForAboveLine == null || endPointForBelowLine == null) {
            return null;
        }
        Point centerPointForBelowLine = new Point((startPointForBelowLine.x + endPointForBelowLine.x) / 2, endPointForBelowLine.y);
        Log.v(TAG, "start pos: " + start + "end pos: " + end);
        Log.v(TAG, "center point for above line: " + centerPointForAboveLine.x + " " + centerPointForAboveLine.y);
        Log.v(TAG, "center point for below line: " + centerPointForBelowLine.x + " " + centerPointForBelowLine.y);
        return new Point[]{centerPointForAboveLine, centerPointForBelowLine};
    }

    QuickAction createAndSetNewQuickAction(View anchor, JsonParser parser, boolean showCreditsIfStoreIsEnabled) {
        if (this.mQuickAction != null && this.mQuickAction.isShowing().booleanValue()) {
            this.mQuickAction.dismiss();
        }
        this.mQuickAction = new QuickAction(this.mTextView.getContext(), anchor, parser, showCreditsIfStoreIsEnabled, false, true);
        return this.mQuickAction;
    }

    IAniwaysTextWatcher removeTheAniwaysTextWatcher() {
        if (!this.mIsEditText) {
            return this.mTextWatcher;
        }
        if (this.mTextWatcherEnabled) {
            ((IAniwaysTextEditor)this.mTextView).callSuperRemoveTextChangedListener(this.mTextWatcher);
            this.mTextWatcherEnabled = false;
        }
        return this.mTextWatcher;
    }

    IAniwaysTextWatcher addTheAniwaysTextWatcher() {
        if (!this.mIsEditText) {
            return this.mTextWatcher;
        }
        if (!this.mTextWatcherEnabled) {
            ((IAniwaysTextEditor)this.mTextView).callSuperAddTextChangedListener(this.mTextWatcher);
            this.mTextWatcherEnabled = true;
        }
        return this.mTextWatcher;
    }

    @Override
    public void removeTextWatchers() {
        this.removeTheAniwaysTextWatcher();
    }

    @Override
    public void addBackTheTextWatchers() {
        this.addTheAniwaysTextWatcher();
    }

    void removeTextChangedListener(TextWatcher watcher) {
        if (watcher instanceof IAniwaysTextWatcher) {
            Log.e(true, TAG, "Removing the Aniways text watcher not through calling removeTheAniwaysTextWatcher() which makes sure that there is a max of only one such watcher at each time");
            this.removeTheAniwaysTextWatcher();
        } else {
            ((IAniwaysTextEditor)this.mTextView).callSuperRemoveTextChangedListener(watcher);
        }
    }

    void addTextChangedListener(TextWatcher watcher) {
        if (watcher instanceof IAniwaysTextWatcher) {
            Log.e(true, TAG, "Adding the Aniways text watcher not through calling addTheAniwaysTextWatcher() which makes sure that there is a max of only one such watcher at each time");
            this.addTheAniwaysTextWatcher();
        } else {
            ((IAniwaysTextEditor)this.mTextView).callSuperAddTextChangedListener(watcher);
        }
    }

    @Override
    public AniwaysDynamicImageSpansContainer getDynamicImageSpansContainer() {
        return this.mDynamicImageSpansContainer;
    }

    void onRemoveDynamicImageSpan(IAniwaysDynamicImageSpan span) {
        this.mDynamicImageSpansContainer.onRemoveSpan(span);
    }

    void onDetachFromWindow() {
        this.mDynamicImageSpansContainer.onDetachFromWindowCalled();
    }

    void onLayoutCalled() {
        this.mDynamicImageSpansContainer.onLayoutCalled();
    }

    @Override
    public void onLoadedImageSuccessfuly() {
    }

    @Override
    public void onErrorLoadingImage() {
    }

    private boolean isIconInfoDisplayer() {
        return this.mTextView instanceof IIconInfoDisplayer;
    }

    @Override
    public IIconInfoDisplayer getIconInfoDisplayer() {
        if (this.isIconInfoDisplayer()) {
            return (IIconInfoDisplayer)this.mTextView;
        }
        return null;
    }

    @Override
    public void registerSetTextListener(AniwaysMessageListViewItemWrapperLayout.OnSetTextListener setTextListener) {
        this.mSetTextListeners.add(setTextListener);
        setTextListener.onSetText((CharSequence)this.getText());
    }

    @Override
    public void unregisterSetTextListener(AniwaysMessageListViewItemWrapperLayout.OnSetTextListener listener) {
        this.mSetTextListeners.remove(listener);
    }
}

