/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import android.content.Context;
import aniways.com.google.analytics.containertag.common.FunctionType;
import aniways.com.google.analytics.containertag.common.Key;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.analytics.tracking.android.Tracker;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import aniways.com.google.tagmanager.DataLayer;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.TrackerProvider;
import aniways.com.google.tagmanager.TrackingTag;
import aniways.com.google.tagmanager.Types;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class UniversalAnalyticsTag
extends TrackingTag {
    private static final String DEFAULT_TRACKING_ID = "_GTM_DEFAULT_TRACKER_";
    private static final String ID = FunctionType.UNIVERSAL_ANALYTICS.toString();
    private static final String ACCOUNT = Key.ACCOUNT.toString();
    private static final String ANALYTICS_PASS_THROUGH = Key.ANALYTICS_PASS_THROUGH.toString();
    private static final String ANALYTICS_FIELDS = Key.ANALYTICS_FIELDS.toString();
    private static final String TRACK_TRANSACTION = Key.TRACK_TRANSACTION.toString();
    private static final String TRANSACTION_DATALAYER_MAP = Key.TRANSACTION_DATALAYER_MAP.toString();
    private static final String TRANSACTION_ITEM_DATALAYER_MAP = Key.TRANSACTION_ITEM_DATALAYER_MAP.toString();
    private static Map<String, String> defaultTransactionMap;
    private static Map<String, String> defaultItemMap;
    private final Set<String> mTurnOffAnonymizeIpValues;
    private final TrackerProvider mTrackerProvider;
    private final DataLayer mDataLayer;

    public static String getFunctionId() {
        return ID;
    }

    public UniversalAnalyticsTag(Context context, DataLayer dataLayer) {
        this(context, dataLayer, new TrackerProvider(context));
    }

    @VisibleForTesting
    UniversalAnalyticsTag(Context context, DataLayer dataLayer, TrackerProvider trackerProvider) {
        super(ID, new String[0]);
        this.mDataLayer = dataLayer;
        this.mTrackerProvider = trackerProvider;
        this.mTurnOffAnonymizeIpValues = new HashSet<String>();
        this.mTurnOffAnonymizeIpValues.add("");
        this.mTurnOffAnonymizeIpValues.add("0");
        this.mTurnOffAnonymizeIpValues.add("false");
    }

    private boolean checkBooleanProperty(Map<String, TypeSystem.Value> tag, String key) {
        TypeSystem.Value value = tag.get(key);
        return value == null ? false : Types.valueToBoolean(value);
    }

    @Override
    public void evaluateTrackingTag(Map<String, TypeSystem.Value> tag) {
        Tracker tracker = this.mTrackerProvider.getTracker(DEFAULT_TRACKING_ID);
        if (this.checkBooleanProperty(tag, ANALYTICS_PASS_THROUGH)) {
            tracker.send(this.convertToGaFields(tag.get(ANALYTICS_FIELDS)));
        } else if (this.checkBooleanProperty(tag, TRACK_TRANSACTION)) {
            this.sendTransaction(tracker, tag);
        } else {
            Log.w("Ignoring unknown tag.");
        }
        this.mTrackerProvider.close(tracker);
    }

    private String getDataLayerString(String field) {
        Object data = this.mDataLayer.get(field);
        return data == null ? null : data.toString();
    }

    private List<Map<String, String>> getTransactionItems() {
        Object data = this.mDataLayer.get("transactionProducts");
        if (data == null) {
            return null;
        }
        if (!(data instanceof List)) {
            throw new IllegalArgumentException("transactionProducts should be of type List.");
        }
        List list = (List)data;
        for (Object obj : list) {
            if (obj instanceof Map) continue;
            throw new IllegalArgumentException("Each element of transactionProducts should be of type Map.");
        }
        List retData = (List)data;
        return retData;
    }

    private void addParam(Map<String, String> itemParams, String gaKey, String value) {
        if (value != null) {
            itemParams.put(gaKey, value);
        }
    }

    private void sendTransaction(Tracker tracker, Map<String, TypeSystem.Value> tag) {
        String transactionId = this.getDataLayerString("transactionId");
        if (transactionId == null) {
            Log.e("Cannot find transactionId in data layer.");
            return;
        }
        LinkedList<Map<String, String>> sendQueue = new LinkedList<Map<String, String>>();
        try {
            Map<String, String> params = this.convertToGaFields(tag.get(ANALYTICS_FIELDS));
            params.put("&t", "transaction");
            Map<String, String> transactionFields = this.getTransactionFields(tag);
            for (Map.Entry<String, String> entry : transactionFields.entrySet()) {
                this.addParam(params, entry.getValue(), this.getDataLayerString(entry.getKey()));
            }
            sendQueue.add(params);
            List<Map<String, String>> items = this.getTransactionItems();
            if (items != null) {
                for (Map<String, String> item : items) {
                    if (item.get("name") == null) {
                        Log.e("Unable to send transaction item hit due to missing 'name' field.");
                        return;
                    }
                    Map<String, String> itemParams = this.convertToGaFields(tag.get(ANALYTICS_FIELDS));
                    itemParams.put("&t", "item");
                    itemParams.put("&ti", transactionId);
                    Map<String, String> itemFields = this.getTransactionItemFields(tag);
                    for (Map.Entry<String, String> entry : itemFields.entrySet()) {
                        this.addParam(itemParams, entry.getValue(), item.get(entry.getKey()));
                    }
                    sendQueue.add(itemParams);
                }
            }
            for (Map<String, String> gaParam : sendQueue) {
                tracker.send(gaParam);
            }
        }
        catch (IllegalArgumentException e) {
            Log.e("Unable to send transaction", e);
            return;
        }
    }

    private Map<String, String> valueToMap(TypeSystem.Value mapValue) {
        Object o = Types.valueToObject(mapValue);
        if (!(o instanceof Map)) {
            return null;
        }
        Map map = (Map)o;
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            stringMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return stringMap;
    }

    private Map<String, String> convertToGaFields(TypeSystem.Value analyticsFields) {
        if (analyticsFields == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> params = this.valueToMap(analyticsFields);
        if (params == null) {
            return new HashMap<String, String>();
        }
        String aip = params.get("&aip");
        if (aip != null && this.mTurnOffAnonymizeIpValues.contains(aip.toLowerCase())) {
            params.remove("&aip");
        }
        return params;
    }

    private Map<String, String> getTransactionFields(Map<String, TypeSystem.Value> tag) {
        TypeSystem.Value map = tag.get(TRANSACTION_DATALAYER_MAP);
        if (map != null) {
            return this.valueToMap(map);
        }
        if (defaultTransactionMap == null) {
            HashMap<String, String> defaultMap = new HashMap<String, String>();
            defaultMap.put("transactionId", "&ti");
            defaultMap.put("transactionAffiliation", "&ta");
            defaultMap.put("transactionTax", "&tt");
            defaultMap.put("transactionShipping", "&ts");
            defaultMap.put("transactionTotal", "&tr");
            defaultMap.put("transactionCurrency", "&cu");
            defaultTransactionMap = defaultMap;
        }
        return defaultTransactionMap;
    }

    private Map<String, String> getTransactionItemFields(Map<String, TypeSystem.Value> tag) {
        TypeSystem.Value map = tag.get(TRANSACTION_ITEM_DATALAYER_MAP);
        if (map != null) {
            return this.valueToMap(map);
        }
        if (defaultItemMap == null) {
            HashMap<String, String> defaultMap = new HashMap<String, String>();
            defaultMap.put("name", "&in");
            defaultMap.put("sku", "&ic");
            defaultMap.put("category", "&iv");
            defaultMap.put("price", "&ip");
            defaultMap.put("quantity", "&iq");
            defaultMap.put("currency", "&cu");
            defaultItemMap = defaultMap;
        }
        return defaultItemMap;
    }
}

