/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.TypedNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Types {
    private static final Object DEFAULT_OBJECT = null;
    private static Long DEFAULT_INT64 = new Long(0L);
    private static Double DEFAULT_DOUBLE = new Double(0.0);
    private static TypedNumber DEFAULT_NUMBER = TypedNumber.numberWithInt64(0L);
    private static String DEFAULT_STRING = new String("");
    private static Boolean DEFAULT_BOOLEAN = new Boolean(false);
    private static List<Object> DEFAULT_LIST = new ArrayList<Object>(0);
    private static Map<Object, Object> DEFAULT_MAP = new HashMap<Object, Object>();
    private static TypeSystem.Value DEFAULT_VALUE = Types.objectToValue(DEFAULT_STRING);

    private Types() {
    }

    public static Object getDefaultObject() {
        return DEFAULT_OBJECT;
    }

    public static Long getDefaultInt64() {
        return DEFAULT_INT64;
    }

    public static Double getDefaultDouble() {
        return DEFAULT_DOUBLE;
    }

    public static Boolean getDefaultBoolean() {
        return DEFAULT_BOOLEAN;
    }

    public static TypedNumber getDefaultNumber() {
        return DEFAULT_NUMBER;
    }

    public static String getDefaultString() {
        return DEFAULT_STRING;
    }

    public static List<Object> getDefaultList() {
        return DEFAULT_LIST;
    }

    public static Map<Object, Object> getDefaultMap() {
        return DEFAULT_MAP;
    }

    public static TypeSystem.Value getDefaultValue() {
        return DEFAULT_VALUE;
    }

    public static String objectToString(Object o) {
        return o == null ? DEFAULT_STRING : o.toString();
    }

    public static TypedNumber objectToNumber(Object o) {
        if (o instanceof TypedNumber) {
            return (TypedNumber)o;
        }
        if (Types.isInt64ableNumber(o)) {
            return TypedNumber.numberWithInt64(Types.getInt64(o));
        }
        if (Types.isDoubleableNumber(o)) {
            return TypedNumber.numberWithDouble(Types.getDouble(o));
        }
        return Types.parseNumber(Types.objectToString(o));
    }

    public static Long objectToInt64(Object o) {
        return Types.isInt64ableNumber(o) ? Long.valueOf(Types.getInt64(o)) : Types.parseInt64(Types.objectToString(o));
    }

    public static Double objectToDouble(Object o) {
        return Types.isDoubleableNumber(o) ? Double.valueOf(Types.getDouble(o)) : Types.parseDouble(Types.objectToString(o));
    }

    public static Boolean objectToBoolean(Object o) {
        return o instanceof Boolean ? (Boolean)o : Types.parseBoolean(Types.objectToString(o));
    }

    public static String valueToString(TypeSystem.Value v) {
        return Types.objectToString(Types.valueToObject(v));
    }

    public static TypedNumber valueToNumber(TypeSystem.Value v) {
        return Types.objectToNumber(Types.valueToObject(v));
    }

    public static Long valueToInt64(TypeSystem.Value v) {
        return Types.objectToInt64(Types.valueToObject(v));
    }

    public static Double valueToDouble(TypeSystem.Value v) {
        return Types.objectToDouble(Types.valueToObject(v));
    }

    public static Boolean valueToBoolean(TypeSystem.Value v) {
        return Types.objectToBoolean(Types.valueToObject(v));
    }

    public static TypeSystem.Value objectToValue(Object o) {
        TypeSystem.Value returnValue = new TypeSystem.Value();
        boolean containsRef = false;
        if (o instanceof TypeSystem.Value) {
            return (TypeSystem.Value)o;
        }
        if (o instanceof String) {
            returnValue.type = 1;
            returnValue.string = (String)o;
        } else if (o instanceof List) {
            returnValue.type = 2;
            List objectList = (List)o;
            ArrayList<TypeSystem.Value> valueList = new ArrayList<TypeSystem.Value>(objectList.size());
            for (Object listObject : objectList) {
                TypeSystem.Value listValue = Types.objectToValue(listObject);
                if (listValue == DEFAULT_VALUE) {
                    return DEFAULT_VALUE;
                }
                containsRef = containsRef || listValue.containsReferences;
                valueList.add(listValue);
            }
            returnValue.listItem = valueList.toArray(new TypeSystem.Value[0]);
        } else if (o instanceof Map) {
            returnValue.type = 3;
            Set entries = ((Map)o).entrySet();
            ArrayList<TypeSystem.Value> keys = new ArrayList<TypeSystem.Value>(entries.size());
            ArrayList<TypeSystem.Value> values = new ArrayList<TypeSystem.Value>(entries.size());
            for (Map.Entry entry : entries) {
                TypeSystem.Value key = Types.objectToValue(entry.getKey());
                TypeSystem.Value value = Types.objectToValue(entry.getValue());
                if (key == DEFAULT_VALUE || value == DEFAULT_VALUE) {
                    return DEFAULT_VALUE;
                }
                containsRef = containsRef || key.containsReferences || value.containsReferences;
                keys.add(key);
                values.add(value);
            }
            returnValue.mapKey = keys.toArray(new TypeSystem.Value[0]);
            returnValue.mapValue = values.toArray(new TypeSystem.Value[0]);
        } else if (Types.isDoubleableNumber(o)) {
            returnValue.type = 1;
            returnValue.string = o.toString();
        } else if (Types.isInt64ableNumber(o)) {
            returnValue.type = 6;
            returnValue.integer = Types.getInt64(o);
        } else if (o instanceof Boolean) {
            returnValue.type = 8;
            returnValue.boolean_ = (Boolean)o;
        } else {
            Log.e("Converting to Value from unknown object type: " + (o == null ? "null" : o.getClass().toString()));
            return DEFAULT_VALUE;
        }
        returnValue.containsReferences = containsRef;
        return returnValue;
    }

    public static TypeSystem.Value functionIdToValue(String id) {
        TypeSystem.Value value = new TypeSystem.Value();
        value.type = 5;
        value.functionId = id;
        return value;
    }

    public static TypeSystem.Value macroReferenceToValue(String macroName, int ... escapings) {
        TypeSystem.Value value = new TypeSystem.Value();
        value.type = 4;
        value.macroReference = macroName;
        value.containsReferences = true;
        value.escaping = (int[])escapings.clone();
        return value;
    }

    public static TypeSystem.Value templateToValue(TypeSystem.Value ... tokens) {
        TypeSystem.Value value = new TypeSystem.Value();
        value.type = 7;
        boolean containsRef = false;
        value.templateToken = new TypeSystem.Value[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            value.templateToken[i] = tokens[i];
            containsRef = containsRef || tokens[i].containsReferences;
        }
        value.containsReferences = containsRef;
        return value;
    }

    private static boolean isDoubleableNumber(Object o) {
        return o instanceof Double || o instanceof Float || o instanceof TypedNumber && ((TypedNumber)o).isDouble();
    }

    private static double getDouble(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        Log.e("getDouble received non-Number");
        return 0.0;
    }

    private static boolean isInt64ableNumber(Object o) {
        return o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof TypedNumber && ((TypedNumber)o).isInt64();
    }

    private static long getInt64(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        Log.e("getInt64 received non-Number");
        return 0L;
    }

    private static TypedNumber parseNumber(String s) {
        try {
            return TypedNumber.numberWithString(s);
        }
        catch (NumberFormatException longError) {
            Log.e("Failed to convert '" + s + "' to a number.");
            return DEFAULT_NUMBER;
        }
    }

    private static Long parseInt64(String s) {
        TypedNumber result = Types.parseNumber(s);
        return result == DEFAULT_NUMBER ? DEFAULT_INT64 : Long.valueOf(result.longValue());
    }

    private static Double parseDouble(String s) {
        TypedNumber result = Types.parseNumber(s);
        return result == DEFAULT_NUMBER ? DEFAULT_DOUBLE : Double.valueOf(result.doubleValue());
    }

    private static Boolean parseBoolean(String s) {
        if ("true".equalsIgnoreCase(s)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(s)) {
            return Boolean.FALSE;
        }
        return DEFAULT_BOOLEAN;
    }

    public static Object valueToObject(TypeSystem.Value v) {
        if (v == null) {
            return DEFAULT_OBJECT;
        }
        switch (v.type) {
            case 1: {
                return v.string;
            }
            case 2: {
                ArrayList<Object> result = new ArrayList<Object>(v.listItem.length);
                for (TypeSystem.Value val : v.listItem) {
                    Object o = Types.valueToObject(val);
                    if (o == DEFAULT_OBJECT) {
                        return DEFAULT_OBJECT;
                    }
                    result.add(o);
                }
                return result;
            }
            case 3: {
                if (v.mapKey.length != v.mapValue.length) {
                    Log.e("Converting an invalid value to object: " + v.toString());
                    return DEFAULT_OBJECT;
                }
                LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(v.mapValue.length);
                for (int i = 0; i < v.mapKey.length; ++i) {
                    Object key = Types.valueToObject(v.mapKey[i]);
                    Object value = Types.valueToObject(v.mapValue[i]);
                    if (key == DEFAULT_OBJECT || value == DEFAULT_OBJECT) {
                        return DEFAULT_OBJECT;
                    }
                    result.put(key, value);
                }
                return result;
            }
            case 4: {
                Log.e("Trying to convert a macro reference to object");
                return DEFAULT_OBJECT;
            }
            case 5: {
                Log.e("Trying to convert a function id to object");
                return DEFAULT_OBJECT;
            }
            case 6: {
                return v.integer;
            }
            case 7: {
                StringBuffer result = new StringBuffer();
                for (TypeSystem.Value val : v.templateToken) {
                    String s = Types.valueToString(val);
                    if (s == DEFAULT_STRING) {
                        return DEFAULT_OBJECT;
                    }
                    result.append(s);
                }
                return result.toString();
            }
            case 8: {
                return v.boolean_;
            }
        }
        Log.e("Failed to convert a value of type: " + v.type);
        return DEFAULT_OBJECT;
    }
}

