/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

class TypedNumber
extends Number
implements Comparable<TypedNumber> {
    private double mDouble;
    private long mInt64;
    private boolean mIsInt64;

    private TypedNumber(double d) {
        this.mDouble = d;
        this.mIsInt64 = false;
    }

    private TypedNumber(long l) {
        this.mInt64 = l;
        this.mIsInt64 = true;
    }

    public static TypedNumber numberWithDouble(Double d) {
        return new TypedNumber(d);
    }

    public static TypedNumber numberWithInt64(long l) {
        return new TypedNumber(l);
    }

    public static TypedNumber numberWithString(String s) throws NumberFormatException {
        try {
            return new TypedNumber(Long.parseLong(s));
        }
        catch (NumberFormatException e) {
            try {
                return new TypedNumber(Double.parseDouble(s));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(s + " is not a valid TypedNumber");
            }
        }
    }

    public String toString() {
        return this.isInt64() ? Long.toString(this.mInt64) : Double.toString(this.mDouble);
    }

    public boolean equals(Object other) {
        return other instanceof TypedNumber && this.compareTo((TypedNumber)other) == 0;
    }

    public int hashCode() {
        return new Long(this.longValue()).hashCode();
    }

    @Override
    public int compareTo(TypedNumber other) {
        return this.isInt64() && other.isInt64() ? new Long(this.mInt64).compareTo(other.mInt64) : Double.compare(this.doubleValue(), other.doubleValue());
    }

    public boolean isDouble() {
        return !this.isInt64();
    }

    public boolean isInt64() {
        return this.mIsInt64;
    }

    @Override
    public double doubleValue() {
        return this.isInt64() ? (double)this.mInt64 : this.mDouble;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public long longValue() {
        return this.int64Value();
    }

    public long int64Value() {
        return this.isInt64() ? this.mInt64 : (long)this.mDouble;
    }

    @Override
    public int intValue() {
        return this.int32Value();
    }

    public int int32Value() {
        return (int)this.longValue();
    }

    @Override
    public short shortValue() {
        return this.int16Value();
    }

    public short int16Value() {
        return (short)this.longValue();
    }

    @Override
    public byte byteValue() {
        return (byte)this.longValue();
    }
}

