/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import aniways.com.google.tagmanager.HitSendingThread;
import aniways.com.google.tagmanager.HitStore;
import aniways.com.google.tagmanager.HitStoreStateListener;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.NetworkReceiver;
import aniways.com.google.tagmanager.PersistentHitStore;
import aniways.com.google.tagmanager.ServiceManager;

class ServiceManagerImpl
extends ServiceManager {
    private static final int MSG_KEY = 1;
    private static final Object MSG_OBJECT = new Object();
    private Context ctx;
    private HitStore store;
    private volatile HitSendingThread thread;
    private int dispatchPeriodInSeconds = 1800;
    private boolean pendingDispatch = true;
    private boolean readyToDispatch = false;
    private boolean connected = true;
    private boolean listenForNetwork = true;
    private HitStoreStateListener listener = new HitStoreStateListener(){

        @Override
        public void reportStoreIsEmpty(boolean isEmpty) {
            ServiceManagerImpl.this.updatePowerSaveMode(isEmpty, ServiceManagerImpl.this.connected);
        }
    };
    private Handler handler;
    private NetworkReceiver networkReceiver;
    private boolean storeIsEmpty = false;
    private static ServiceManagerImpl instance;

    public static ServiceManagerImpl getInstance() {
        if (instance == null) {
            instance = new ServiceManagerImpl();
        }
        return instance;
    }

    private ServiceManagerImpl() {
    }

    @VisibleForTesting
    static void clearInstance() {
        instance = null;
    }

    @VisibleForTesting
    ServiceManagerImpl(Context ctx, HitSendingThread thread, HitStore store, boolean listenForNetwork) {
        this.store = store;
        this.thread = thread;
        this.listenForNetwork = listenForNetwork;
        this.initialize(ctx, thread);
    }

    private void initializeNetworkReceiver() {
        this.networkReceiver = new NetworkReceiver(this);
        this.networkReceiver.register(this.ctx);
    }

    private void initializeHandler() {
        this.handler = new Handler(this.ctx.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (1 == msg.what && MSG_OBJECT.equals(msg.obj)) {
                    ServiceManagerImpl.this.dispatch();
                    if (ServiceManagerImpl.this.dispatchPeriodInSeconds > 0 && !ServiceManagerImpl.this.storeIsEmpty) {
                        ServiceManagerImpl.this.handler.sendMessageDelayed(ServiceManagerImpl.this.handler.obtainMessage(1, MSG_OBJECT), (long)(ServiceManagerImpl.this.dispatchPeriodInSeconds * 1000));
                    }
                }
                return true;
            }
        });
        if (this.dispatchPeriodInSeconds > 0) {
            this.handler.sendMessageDelayed(this.handler.obtainMessage(1, MSG_OBJECT), (long)(this.dispatchPeriodInSeconds * 1000));
        }
    }

    synchronized void initialize(Context ctx, HitSendingThread thread) {
        if (this.ctx != null) {
            return;
        }
        this.ctx = ctx.getApplicationContext();
        if (this.thread == null) {
            this.thread = thread;
        }
    }

    @VisibleForTesting
    HitStoreStateListener getListener() {
        return this.listener;
    }

    synchronized HitStore getStore() {
        if (this.store == null) {
            if (this.ctx == null) {
                throw new IllegalStateException("Cant get a store unless we have a context");
            }
            this.store = new PersistentHitStore(this.listener, this.ctx);
        }
        if (this.handler == null) {
            this.initializeHandler();
        }
        this.readyToDispatch = true;
        if (this.pendingDispatch) {
            this.dispatch();
            this.pendingDispatch = false;
        }
        if (this.networkReceiver == null && this.listenForNetwork) {
            this.initializeNetworkReceiver();
        }
        return this.store;
    }

    @Override
    public synchronized void dispatch() {
        if (!this.readyToDispatch) {
            Log.v("Dispatch call queued. Dispatch will run once initialization is complete.");
            this.pendingDispatch = true;
            return;
        }
        this.thread.queueToThread(new Runnable(){

            @Override
            public void run() {
                ServiceManagerImpl.this.store.dispatch();
            }
        });
    }

    @Override
    public synchronized void setDispatchPeriod(int dispatchPeriodInSeconds) {
        if (this.handler == null) {
            Log.v("Dispatch period set with null handler. Dispatch will run once initialization is complete.");
            this.dispatchPeriodInSeconds = dispatchPeriodInSeconds;
            return;
        }
        if (!this.storeIsEmpty && this.connected && this.dispatchPeriodInSeconds > 0) {
            this.handler.removeMessages(1, MSG_OBJECT);
        }
        this.dispatchPeriodInSeconds = dispatchPeriodInSeconds;
        if (dispatchPeriodInSeconds > 0 && !this.storeIsEmpty && this.connected) {
            this.handler.sendMessageDelayed(this.handler.obtainMessage(1, MSG_OBJECT), (long)(dispatchPeriodInSeconds * 1000));
        }
    }

    @VisibleForTesting
    synchronized void updatePowerSaveMode(boolean storeIsEmpty, boolean connected) {
        if (this.storeIsEmpty == storeIsEmpty && this.connected == connected) {
            return;
        }
        if ((storeIsEmpty || !connected) && this.dispatchPeriodInSeconds > 0) {
            this.handler.removeMessages(1, MSG_OBJECT);
        }
        if (!storeIsEmpty && connected && this.dispatchPeriodInSeconds > 0) {
            this.handler.sendMessageDelayed(this.handler.obtainMessage(1, MSG_OBJECT), (long)(this.dispatchPeriodInSeconds * 1000));
        }
        Log.v("PowerSaveMode " + (storeIsEmpty || !connected ? "initiated." : "terminated."));
        this.storeIsEmpty = storeIsEmpty;
        this.connected = connected;
    }

    @Override
    synchronized void updateConnectivityStatus(boolean connected) {
        this.updatePowerSaveMode(this.storeIsEmpty, connected);
    }

    @Override
    synchronized void onRadioPowered() {
        if (!this.storeIsEmpty && this.connected && this.dispatchPeriodInSeconds > 0) {
            this.handler.removeMessages(1, MSG_OBJECT);
            this.handler.sendMessage(this.handler.obtainMessage(1, MSG_OBJECT));
        }
    }
}

