/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import android.content.Context;
import android.content.res.AssetManager;
import aniways.com.google.analytics.containertag.proto.Serving;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import aniways.com.google.tagmanager.Container;
import aniways.com.google.tagmanager.JsonUtils;
import aniways.com.google.tagmanager.LoadCallback;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.PreviewManager;
import aniways.com.google.tagmanager.ResourceUtil;
import aniways.com.google.tagmanager.proto.Resource;
import aniways.com.google.tagmanager.protobuf.nano.MessageNano;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class ResourceStorageImpl
implements Container.ResourceStorage {
    private static final String SAVED_RESOURCE_SUB_DIR = "google_tagmanager";
    private static final String SAVED_RESOURCE_FILENAME_PREFIX = "resource_";
    private final Context mContext;
    private final String mContainerId;
    private final ExecutorService mExecutor;
    private LoadCallback<Resource.ResourceWithMetadata> mCallback;

    ResourceStorageImpl(Context context, String containerId) {
        this.mContext = context;
        this.mContainerId = containerId;
        this.mExecutor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void setLoadCallback(LoadCallback<Resource.ResourceWithMetadata> callback) {
        this.mCallback = callback;
    }

    @Override
    public void loadResourceFromDiskInBackground() {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ResourceStorageImpl.this.loadResourceFromDisk();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void loadResourceFromDisk() {
        if (this.mCallback == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.mCallback.startLoad();
        Log.v("Start loading resource from disk ...");
        if ((PreviewManager.getInstance().getPreviewMode() == PreviewManager.PreviewMode.CONTAINER || PreviewManager.getInstance().getPreviewMode() == PreviewManager.PreviewMode.CONTAINER_DEBUG) && this.mContainerId.equals(PreviewManager.getInstance().getContainerId())) {
            this.mCallback.onFailure(LoadCallback.Failure.NOT_AVAILABLE);
            return;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.getResourceFile());
        }
        catch (FileNotFoundException e) {
            Log.d("resource not on disk");
            this.mCallback.onFailure(LoadCallback.Failure.NOT_AVAILABLE);
            return;
        }
        try {
            ByteArrayOutputStream input = new ByteArrayOutputStream();
            ResourceUtil.copyStream(stream, input);
            this.mCallback.onSuccess(Resource.ResourceWithMetadata.parseFrom(input.toByteArray()));
        }
        catch (IOException e) {
            Log.w("error reading resource from disk");
            this.mCallback.onFailure(LoadCallback.Failure.IO_ERROR);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                Log.w("error closing stream for reading resource from disk");
            }
        }
        Log.v("Load resource from disk finished.");
    }

    @Override
    public void saveResourceToDiskInBackground(final Resource.ResourceWithMetadata resource) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ResourceStorageImpl.this.saveResourceToDisk(resource);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serving.Resource loadResourceFromContainerAsset(String assetFile) {
        Log.v("Loading default container from " + assetFile);
        AssetManager assets = this.mContext.getAssets();
        if (assets == null) {
            Log.e("No assets found in package");
            return null;
        }
        InputStream is = null;
        try {
            is = assets.open(assetFile);
        }
        catch (IOException e) {
            Log.w("No asset file: " + assetFile + " found.");
            return null;
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ResourceUtil.copyStream(is, output);
            byte[] outputByteArray = output.toByteArray();
            Serving.Resource result = Serving.Resource.parseFrom(outputByteArray);
            Log.v("Parsed default container: " + result);
            Serving.Resource resource = result;
            return resource;
        }
        catch (IOException e) {
            Log.w("Error when parsing: " + assetFile);
            Serving.Resource resource = null;
            return resource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceUtil.ExpandedResource loadExpandedResourceFromJsonAsset(String assetFile) {
        Log.v("loading default container from " + assetFile);
        AssetManager assets = this.mContext.getAssets();
        if (assets == null) {
            Log.w("Looking for default JSON container in package, but no assets were found.");
            return null;
        }
        InputStream is = null;
        try {
            is = assets.open(assetFile);
            ResourceUtil.ExpandedResource expandedResource = JsonUtils.expandedResourceFromJsonString(this.stringFromInputStream(is));
            return expandedResource;
        }
        catch (IOException e) {
            Log.w("No asset file: " + assetFile + " found (or errors reading it).");
            ResourceUtil.ExpandedResource expandedResource = null;
            return expandedResource;
        }
        catch (JSONException e) {
            Log.w("Error parsing JSON file" + assetFile + " : " + (Object)((Object)e));
            ResourceUtil.ExpandedResource expandedResource = null;
            return expandedResource;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public synchronized void close() {
        this.mExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean saveResourceToDisk(Resource.ResourceWithMetadata resource) {
        FileOutputStream stream = null;
        File file = this.getResourceFile();
        try {
            stream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            Log.e("Error opening resource file for writing");
            return false;
        }
        try {
            stream.write(MessageNano.toByteArray(resource));
            boolean e = true;
            return e;
        }
        catch (IOException e) {
            Log.w("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                Log.w("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    @VisibleForTesting
    File getResourceFile() {
        String fileName = SAVED_RESOURCE_FILENAME_PREFIX + this.mContainerId;
        File dir = this.mContext.getDir(SAVED_RESOURCE_SUB_DIR, 0);
        return new File(dir, fileName);
    }

    private String stringFromInputStream(InputStream is) throws IOException {
        int n;
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        while ((n = reader.read(buffer)) != -1) {
            ((Writer)writer).write(buffer, 0, n);
        }
        return ((Object)writer).toString();
    }
}

