/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import android.content.Context;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import aniways.com.google.tagmanager.HitSender;
import aniways.com.google.tagmanager.HitSendingThread;
import aniways.com.google.tagmanager.HitSendingThreadImpl;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.RateLimiter;
import aniways.com.google.tagmanager.SendHitRateLimiter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

class DelayedHitSender
implements HitSender {
    private static DelayedHitSender sInstance;
    private static final Object sInstanceLock;
    private String mWrapperUrl;
    private String mWrapperQueryParameter;
    private RateLimiter mRateLimiter;
    private HitSendingThread mSendingThread;

    private DelayedHitSender(Context context) {
        this(HitSendingThreadImpl.getInstance(context), new SendHitRateLimiter());
    }

    @VisibleForTesting
    DelayedHitSender(HitSendingThread thread, RateLimiter rateLimiter) {
        this.mSendingThread = thread;
        this.mRateLimiter = rateLimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HitSender getInstance(Context context) {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new DelayedHitSender(context);
            }
            return sInstance;
        }
    }

    @Override
    public void setUrlWrapModeForTesting(String url, String queryParameter) {
        this.mWrapperUrl = url;
        this.mWrapperQueryParameter = queryParameter;
    }

    @Override
    public boolean sendHit(String url) {
        if (!this.mRateLimiter.tokenAvailable()) {
            Log.w("Too many urls sent too quickly with the TagManagerSender, rate limiting invoked.");
            return false;
        }
        if (this.mWrapperUrl != null && this.mWrapperQueryParameter != null) {
            try {
                url = this.mWrapperUrl + "?" + this.mWrapperQueryParameter + "=" + URLEncoder.encode(url, "UTF-8");
                Log.v("Sending wrapped url hit: " + url);
            }
            catch (UnsupportedEncodingException e) {
                Log.w("Error wrapping URL for testing.", e);
                return false;
            }
        }
        this.mSendingThread.sendHit(url);
        return true;
    }

    static {
        sInstanceLock = new Object();
    }
}

