/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import aniways.com.google.analytics.containertag.common.FunctionType;
import aniways.com.google.analytics.containertag.common.Key;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.tagmanager.DataLayer;
import aniways.com.google.tagmanager.TrackingTag;
import aniways.com.google.tagmanager.Types;
import java.util.List;
import java.util.Map;

class DataLayerWriteTag
extends TrackingTag {
    private static final String ID = FunctionType.DATA_LAYER_WRITE.toString();
    private static final String VALUE = Key.VALUE.toString();
    private static final String CLEAR_PERSISTENT_DATA_LAYER_PREFIX = Key.CLEAR_PERSISTENT_DATA_LAYER_PREFIX.toString();
    private final DataLayer mDataLayer;

    public static String getFunctionId() {
        return ID;
    }

    public DataLayerWriteTag(DataLayer dataLayer) {
        super(ID, VALUE);
        this.mDataLayer = dataLayer;
    }

    @Override
    public void evaluateTrackingTag(Map<String, TypeSystem.Value> tag) {
        this.pushToDataLayer(tag.get(VALUE));
        this.clearPersistent(tag.get(CLEAR_PERSISTENT_DATA_LAYER_PREFIX));
    }

    private void clearPersistent(TypeSystem.Value value) {
        if (value == null || value == Types.getDefaultObject()) {
            return;
        }
        String prefix = Types.valueToString(value);
        if (prefix == Types.getDefaultString()) {
            return;
        }
        this.mDataLayer.clearPersistentKeysWithPrefix(prefix);
    }

    private void pushToDataLayer(TypeSystem.Value value) {
        if (value == null || value == Types.getDefaultObject()) {
            return;
        }
        Object o = Types.valueToObject(value);
        if (!(o instanceof List)) {
            return;
        }
        List list = (List)o;
        for (Object obj : list) {
            if (!(obj instanceof Map)) continue;
            Map map = (Map)obj;
            this.mDataLayer.push(map);
        }
    }
}

