/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.tagmanager;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import aniways.com.google.analytics.containertag.common.FunctionType;
import aniways.com.google.analytics.midtier.proto.containertag.TypeSystem;
import aniways.com.google.tagmanager.FunctionCallImplementation;
import aniways.com.google.tagmanager.Log;
import aniways.com.google.tagmanager.Types;
import java.util.Map;

class AppNameMacro
extends FunctionCallImplementation {
    private static final String ID = FunctionType.APP_NAME.toString();
    private final Context mContext;

    public static String getFunctionId() {
        return ID;
    }

    public AppNameMacro(Context context) {
        super(ID, new String[0]);
        this.mContext = context;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public TypeSystem.Value evaluate(Map<String, TypeSystem.Value> parameters) {
        try {
            PackageManager packageManager = this.mContext.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(this.mContext.getPackageName(), 0);
            return Types.objectToValue(packageManager.getApplicationLabel(applicationInfo).toString());
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("App name is not found.", e);
            return Types.getDefaultValue();
        }
    }
}

