/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.analytics.tracking.android;

import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class Utils {
    private static final char[] HEXBYTES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    Utils() {
    }

    public static Map<String, String> parseURLParameters(String parameterString) {
        String[] params;
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String s : params = parameterString.split("&")) {
            String[] ss = s.split("=");
            if (ss.length > 1) {
                parameters.put(ss[0], ss[1]);
                continue;
            }
            if (ss.length != 1 || ss[0].length() == 0) continue;
            parameters.put(ss[0], null);
        }
        return parameters;
    }

    public static double safeParseDouble(String s) {
        return Utils.safeParseDouble(s, 0.0);
    }

    public static double safeParseDouble(String s, double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long safeParseLong(String s) {
        if (s == null) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static boolean safeParseBoolean(String s, boolean defaultValue) {
        if (s != null) {
            if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("1")) {
                return true;
            }
            if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("0")) {
                return false;
            }
        }
        return defaultValue;
    }

    public static String filterCampaign(String campaign) {
        String[] urlParts;
        if (TextUtils.isEmpty((CharSequence)campaign)) {
            return null;
        }
        String urlParameters = campaign;
        if (campaign.contains("?") && (urlParts = campaign.split("[\\?]")).length > 1) {
            urlParameters = urlParts[1];
        }
        if (urlParameters.contains("%3D")) {
            try {
                urlParameters = URLDecoder.decode(urlParameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        } else if (!urlParameters.contains("=")) {
            return null;
        }
        Map<String, String> paramsMap = Utils.parseURLParameters(urlParameters);
        String[] validParameters = new String[]{"dclid", "utm_source", "gclid", "utm_campaign", "utm_medium", "utm_term", "utm_content", "utm_id", "gmob_t"};
        StringBuilder params = new StringBuilder();
        for (int i = 0; i < validParameters.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)paramsMap.get(validParameters[i]))) continue;
            if (params.length() > 0) {
                params.append("&");
            }
            params.append(validParameters[i]).append("=").append(paramsMap.get(validParameters[i]));
        }
        return params.toString();
    }

    static String getLanguage(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)locale.getLanguage())) {
            return null;
        }
        StringBuilder lang = new StringBuilder();
        lang.append(locale.getLanguage().toLowerCase());
        if (!TextUtils.isEmpty((CharSequence)locale.getCountry())) {
            lang.append("-").append(locale.getCountry().toLowerCase());
        }
        return lang.toString();
    }

    static String hexEncode(byte[] bytes) {
        char[] out = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            out[2 * i] = HEXBYTES[b >> 4];
            out[2 * i + 1] = HEXBYTES[b & 0xF];
        }
        return new String(out);
    }

    static int fromHexDigit(char hexDigit) {
        int value = hexDigit - 48;
        if (value > 9) {
            value -= 7;
        }
        return value;
    }

    static byte[] hexDecode(String s) {
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(Utils.fromHexDigit(s.charAt(2 * i)) << 4 | Utils.fromHexDigit(s.charAt(2 * i + 1)));
        }
        return bytes;
    }

    public static void putIfAbsent(Map<String, String> hit, String key, String value) {
        if (!hit.containsKey(key)) {
            hit.put(key, value);
        }
    }
}

