/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.analytics.tracking.android;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import aniways.com.google.analytics.tracking.android.Clock;
import aniways.com.google.analytics.tracking.android.ExceptionReporter;
import aniways.com.google.analytics.tracking.android.GAServiceManager;
import aniways.com.google.analytics.tracking.android.GAUsage;
import aniways.com.google.analytics.tracking.android.GoogleAnalytics;
import aniways.com.google.analytics.tracking.android.Log;
import aniways.com.google.analytics.tracking.android.Logger;
import aniways.com.google.analytics.tracking.android.ParameterLoader;
import aniways.com.google.analytics.tracking.android.ParameterLoaderImpl;
import aniways.com.google.analytics.tracking.android.ServiceManager;
import aniways.com.google.analytics.tracking.android.Tracker;
import aniways.com.google.analytics.tracking.android.TrackerHandler;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class EasyTracker
extends Tracker {
    private static final String EASY_TRACKER_NAME = "easy_tracker";
    private static EasyTracker sInstance;
    private static String sResourcePackageName;
    private final GoogleAnalytics mGoogleAnalytics;
    private static final int DEFAULT_SAMPLE_RATE = 100;
    static final int NUM_MILLISECONDS_TO_WAIT_FOR_OPEN_ACTIVITY = 1000;
    private boolean mIsReportUncaughtExceptionsEnabled;
    private boolean mIsAutoActivityTracking = false;
    private int mActivitiesActive = 0;
    private long mSessionTimeout;
    private long mLastOnStopTime;
    private Context mContext;
    private final Map<String, String> mActivityNameMap = new HashMap<String, String>();
    private ParameterLoader mParameterFetcher;
    private ServiceManager mServiceManager;
    private Clock mClock;
    private Timer mTimer;
    private TimerTask mTimerTask;
    private boolean mIsInForeground = false;
    private boolean mStartSessionOnNextSend = false;

    private EasyTracker(Context ctx) {
        this(ctx, new ParameterLoaderImpl(ctx), GoogleAnalytics.getInstance(ctx), GAServiceManager.getInstance(), null);
    }

    private EasyTracker(Context ctx, ParameterLoader parameterLoader, GoogleAnalytics ga, ServiceManager serviceManager, TrackerHandler handler) {
        super(EASY_TRACKER_NAME, null, handler != null ? handler : ga);
        if (sResourcePackageName != null) {
            parameterLoader.setResourcePackageName(sResourcePackageName);
        }
        this.mGoogleAnalytics = ga;
        this.setContext(ctx, parameterLoader, serviceManager);
        this.mClock = new Clock(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
    }

    public static EasyTracker getInstance(Context ctx) {
        if (sInstance == null) {
            sInstance = new EasyTracker(ctx);
        }
        return sInstance;
    }

    @VisibleForTesting
    static EasyTracker getNewInstance(Context ctx, ParameterLoader parameterLoader, GoogleAnalytics ga, ServiceManager serviceManager, TrackerHandler handler) {
        sInstance = new EasyTracker(ctx, parameterLoader, ga, serviceManager, handler);
        return sInstance;
    }

    boolean checkForNewSession() {
        return this.mSessionTimeout == 0L || this.mSessionTimeout > 0L && this.mClock.currentTimeMillis() > this.mLastOnStopTime + this.mSessionTimeout;
    }

    private void loadParameters() {
        Double sampleRate;
        Logger.LogLevel logLevel;
        String logLevelString;
        String appVersion;
        Log.v("Starting EasyTracker.");
        String trackingId = this.mParameterFetcher.getString("ga_trackingId");
        if (TextUtils.isEmpty((CharSequence)trackingId)) {
            trackingId = this.mParameterFetcher.getString("ga_api_key");
        }
        this.set("&tid", trackingId);
        Log.v("[EasyTracker] trackingId loaded: " + trackingId);
        String appName = this.mParameterFetcher.getString("ga_appName");
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            Log.v("[EasyTracker] app name loaded: " + appName);
            this.set("&an", appName);
        }
        if ((appVersion = this.mParameterFetcher.getString("ga_appVersion")) != null) {
            Log.v("[EasyTracker] app version loaded: " + appVersion);
            this.set("&av", appVersion);
        }
        if ((logLevelString = this.mParameterFetcher.getString("ga_logLevel")) != null && (logLevel = this.getLogLevelFromString(logLevelString)) != null) {
            Log.v("[EasyTracker] log level loaded: " + (Object)((Object)logLevel));
            this.mGoogleAnalytics.getLogger().setLogLevel(logLevel);
        }
        if ((sampleRate = this.mParameterFetcher.getDoubleFromString("ga_sampleFrequency")) == null) {
            sampleRate = new Double(this.mParameterFetcher.getInt("ga_sampleRate", 100));
        }
        if (sampleRate != 100.0) {
            this.set("&sf", Double.toString(sampleRate));
        }
        Log.v("[EasyTracker] sample rate loaded: " + sampleRate);
        int dispatchPeriod = this.mParameterFetcher.getInt("ga_dispatchPeriod", 1800);
        Log.v("[EasyTracker] dispatch period loaded: " + dispatchPeriod);
        this.mServiceManager.setLocalDispatchPeriod(dispatchPeriod);
        this.mSessionTimeout = this.mParameterFetcher.getInt("ga_sessionTimeout", 30) * 1000;
        Log.v("[EasyTracker] session timeout loaded: " + this.mSessionTimeout);
        this.mIsAutoActivityTracking = this.mParameterFetcher.getBoolean("ga_autoActivityTracking") || this.mParameterFetcher.getBoolean("ga_auto_activity_tracking");
        Log.v("[EasyTracker] auto activity tracking loaded: " + this.mIsAutoActivityTracking);
        boolean isAnonymizeIpEnabled = this.mParameterFetcher.getBoolean("ga_anonymizeIp");
        if (isAnonymizeIpEnabled) {
            this.set("&aip", "1");
            Log.v("[EasyTracker] anonymize ip loaded: " + isAnonymizeIpEnabled);
        }
        this.mIsReportUncaughtExceptionsEnabled = this.mParameterFetcher.getBoolean("ga_reportUncaughtExceptions");
        if (this.mIsReportUncaughtExceptionsEnabled) {
            ExceptionReporter reporter = new ExceptionReporter(this, this.mServiceManager, Thread.getDefaultUncaughtExceptionHandler(), this.mContext);
            Thread.setDefaultUncaughtExceptionHandler(reporter);
            Log.v("[EasyTracker] report uncaught exceptions loaded: " + this.mIsReportUncaughtExceptionsEnabled);
        }
        boolean dryRun = this.mParameterFetcher.getBoolean("ga_dryRun");
        this.mGoogleAnalytics.setDryRun(dryRun);
    }

    private Logger.LogLevel getLogLevelFromString(String logLevelString) {
        try {
            return Logger.LogLevel.valueOf(logLevelString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @VisibleForTesting
    void overrideUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        if (this.mIsReportUncaughtExceptionsEnabled) {
            Thread.setDefaultUncaughtExceptionHandler(handler);
        }
    }

    private void setContext(Context ctx, ParameterLoader parameterLoader, ServiceManager serviceManager) {
        if (ctx == null) {
            Log.e("Context cannot be null");
        }
        this.mContext = ctx.getApplicationContext();
        this.mServiceManager = serviceManager;
        this.mParameterFetcher = parameterLoader;
        this.loadParameters();
    }

    public void activityStart(Activity activity) {
        GAUsage.getInstance().setUsage(GAUsage.Field.EASY_TRACKER_ACTIVITY_START);
        this.clearExistingTimer();
        if (!this.mIsInForeground && this.mActivitiesActive == 0 && this.checkForNewSession()) {
            this.mStartSessionOnNextSend = true;
        }
        this.mIsInForeground = true;
        ++this.mActivitiesActive;
        if (this.mIsAutoActivityTracking) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("&t", "appview");
            GAUsage.getInstance().setDisableUsage(true);
            this.set("&cd", this.getActivityName(activity));
            this.send(params);
            GAUsage.getInstance().setDisableUsage(false);
        }
    }

    public void activityStop(Activity activity) {
        GAUsage.getInstance().setUsage(GAUsage.Field.EASY_TRACKER_ACTIVITY_STOP);
        --this.mActivitiesActive;
        this.mActivitiesActive = Math.max(0, this.mActivitiesActive);
        this.mLastOnStopTime = this.mClock.currentTimeMillis();
        if (this.mActivitiesActive == 0) {
            this.clearExistingTimer();
            this.mTimerTask = new NotInForegroundTimerTask();
            this.mTimer = new Timer("waitForActivityStart");
            this.mTimer.schedule(this.mTimerTask, 1000L);
        }
    }

    @Deprecated
    public void dispatchLocalHits() {
        this.mServiceManager.dispatchLocalHits();
    }

    private synchronized void clearExistingTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private String getActivityName(Activity activity) {
        String canonicalName = activity.getClass().getCanonicalName();
        if (this.mActivityNameMap.containsKey(canonicalName)) {
            return this.mActivityNameMap.get(canonicalName);
        }
        String name = this.mParameterFetcher.getString(canonicalName);
        if (name == null) {
            name = canonicalName;
        }
        this.mActivityNameMap.put(canonicalName, name);
        return name;
    }

    @VisibleForTesting
    void setClock(Clock clock) {
        this.mClock = clock;
    }

    @VisibleForTesting
    int getActivitiesActive() {
        return this.mActivitiesActive;
    }

    @Override
    public void send(Map<String, String> params) {
        if (this.mStartSessionOnNextSend) {
            params.put("&sc", "start");
            this.mStartSessionOnNextSend = false;
        }
        super.send(params);
    }

    public static void setResourcePackageName(String resourcePackageName) {
        sResourcePackageName = resourcePackageName;
    }

    private class NotInForegroundTimerTask
    extends TimerTask {
        private NotInForegroundTimerTask() {
        }

        @Override
        public void run() {
            EasyTracker.this.mIsInForeground = false;
        }
    }
}

