/*
 * Decompiled with CFR 0.152.
 */
package aniways.com.google.analytics.tracking.android;

import android.content.Context;
import aniways.com.google.analytics.tracking.android.DefaultProvider;
import aniways.com.google.analytics.tracking.android.Log;
import aniways.com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;

class ClientIdDefaultProvider
implements DefaultProvider {
    private static ClientIdDefaultProvider sInstance;
    private static final Object sInstanceLock;
    private final Context mContext;
    private String mClientId;
    private boolean mClientIdLoaded = false;
    private final Object mClientIdLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeProvider(Context c) {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new ClientIdDefaultProvider(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void dropInstance() {
        Object object = sInstanceLock;
        synchronized (object) {
            sInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientIdDefaultProvider getProvider() {
        Object object = sInstanceLock;
        synchronized (object) {
            return sInstance;
        }
    }

    protected ClientIdDefaultProvider(Context c) {
        this.mContext = c;
        this.asyncInitializeClientId();
    }

    @Override
    public boolean providesField(String field) {
        return "&cid".equals(field);
    }

    @Override
    public String getValue(String field) {
        if ("&cid".equals(field)) {
            return this.blockingGetClientId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String blockingGetClientId() {
        if (!this.mClientIdLoaded) {
            Object object = this.mClientIdLock;
            synchronized (object) {
                if (!this.mClientIdLoaded) {
                    Log.v("Waiting for clientId to load");
                    do {
                        try {
                            this.mClientIdLock.wait();
                        }
                        catch (InterruptedException e) {
                            Log.e("Exception while waiting for clientId: " + e);
                        }
                    } while (!this.mClientIdLoaded);
                }
            }
        }
        Log.v("Loaded clientId");
        return this.mClientId;
    }

    private boolean storeClientId(String clientId) {
        try {
            Log.v("Storing clientId.");
            FileOutputStream fos = this.mContext.openFileOutput("gaClientId", 0);
            fos.write(clientId.getBytes());
            fos.close();
            return true;
        }
        catch (FileNotFoundException e) {
            Log.e("Error creating clientId file.");
            return false;
        }
        catch (IOException e) {
            Log.e("Error writing to clientId file.");
            return false;
        }
    }

    protected String generateClientId() {
        String result = UUID.randomUUID().toString().toLowerCase();
        if (!this.storeClientId(result)) {
            result = "0";
        }
        return result;
    }

    private void asyncInitializeClientId() {
        Thread clientIdFetcherThread = new Thread("client_id_fetcher"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ClientIdDefaultProvider.this.mClientIdLock;
                synchronized (object) {
                    ClientIdDefaultProvider.this.mClientId = ClientIdDefaultProvider.this.initializeClientId();
                    ClientIdDefaultProvider.this.mClientIdLoaded = true;
                    ClientIdDefaultProvider.this.mClientIdLock.notifyAll();
                }
            }
        };
        clientIdFetcherThread.start();
    }

    @VisibleForTesting
    String initializeClientId() {
        String rslt = null;
        try {
            FileInputStream input = this.mContext.openFileInput("gaClientId");
            byte[] bytes = new byte[128];
            int readLen = input.read(bytes, 0, 128);
            if (input.available() > 0) {
                Log.e("clientId file seems corrupted, deleting it.");
                input.close();
                this.mContext.deleteFile("gaClientId");
            } else if (readLen <= 0) {
                Log.e("clientId file seems empty, deleting it.");
                input.close();
                this.mContext.deleteFile("gaClientId");
            } else {
                rslt = new String(bytes, 0, readLen);
                input.close();
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Log.e("Error reading clientId file, deleting it.");
            this.mContext.deleteFile("gaClientId");
        }
        if (rslt == null) {
            rslt = this.generateClientId();
        }
        return rslt;
    }

    static {
        sInstanceLock = new Object();
    }
}

