package com.aniways.quick.action;

import android.content.Context;

import com.aniways.AniwaysSuggestionSpan;
import com.aniways.IAniwaysImageSpan;
import com.aniways.IconData;
import com.aniways.Log;
import com.aniways.analytics.AnalyticsReporter;
import com.aniways.analytics.GoogleAnalyticsReporter;
import com.aniways.data.AniwaysConfiguration;
import com.aniways.data.AniwaysPrivateConfig;
import com.aniways.data.Phrase;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by moran on 1/14/2015.
 */
public class SuggestionPopupModelBuilder {
    private static SuggestionPopupModelBuilder instance;

    private SuggestionPopupModelBuilder() {
    }

    public static SuggestionPopupModelBuilder getInstance(){
        if (instance == null){
            instance = new SuggestionPopupModelBuilder();
        }

        return instance;
    }

    public SuggestionViewModel build(ContextualPopupCreationContext creationContext, Context context){
        if (creationContext == null || creationContext.phrase == null){
            return null;
        }

        SuggestionViewModel model = new SuggestionViewModel();

        PhraseContextualContentViewProvider suggestedIconsView = initContextualIconView(creationContext, context);
        PhraseContextualContentViewProvider suggestedAnimatedGifView = initContextualAnimatedGifView(creationContext, context);

        model.addView(suggestedIconsView);
        model.addView(suggestedAnimatedGifView);

        return model;
    }

    private PhraseContextualContentViewProvider initContextualAnimatedGifView(ContextualPopupCreationContext creationContext, Context context) {
        if (creationContext.phrase.animatedGifs == null || creationContext.phrase.animatedGifs.isEmpty()){
            return null;
        }

        return new PhraseContextualAnimatedGifsContentViewProvider(creationContext, context);
    }

    private PhraseContextualContentViewProvider initContextualIconView(ContextualPopupCreationContext creationContext, Context context) {
        if (creationContext.phrase.icons == null || creationContext.phrase.icons.isEmpty()){
            return null;
        }

        return new PhraseContextualIconsContentViewProvider(creationContext, context);
    }
}

