package com.aniways.quick.action;

import android.view.View;

public class SelectedGridItemInfo{
    private int rows;
    private int columns;
    private int column;
    private int row;
    private View gridItem;
    private int position;
    private int totalNumberOfItems;

    public SelectedGridItemInfo(int columns, int column, int row, int rows, View item, int position, int totalNumberOfItems) {
        this.columns = columns;
        this.column = column;
        this.row = row;
        this.rows = rows;
        gridItem = item;
        this.position = position;
        this.totalNumberOfItems = totalNumberOfItems;
    }

    public int getItemListIndex(){
        return column + columns*row;
    }

    public int getColumns() {
        return columns;
    }

    public int getColumn() {
        return column;
    }

    public int getRow() {
        return row;
    }

    public View getGridItem() {
        return gridItem;
    }

    public int getPosition() {
        return position;
    }

    public int getTotalNumberOfItems() {
        return totalNumberOfItems;
    }

    public int getNumRows() {
        return rows;
    }

    public int getNumColumns() {
        return columns;
    }
}
