package com.aniways.quick.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by moran on 1/17/2015.
 */
public class EventAggregator {

    private static EventAggregator instance;
    private HashMap<String,IEventListener> listeners;

    private EventAggregator() {
        listeners = new HashMap<>();
    }

    public static EventAggregator getInstance(){
        if (instance == null){
            instance = new EventAggregator();
        }

        return instance;
    }

    public void register(String key, IEventListener listener){
        listeners.put(key, listener);
    }

    public void unRegister(String key){
        listeners.remove(key);
    }

    public void notify(IEvent event){
        for(Map.Entry<String, IEventListener> entry : listeners.entrySet()){
            entry.getValue().notify(event);
        }
    }
}

